/*
 * Decompiled with CFR 0.152.
 */
package utils;

import ext.LMAFunction;

class WaistFunction
extends LMAFunction {
    static final int W0 = 0;
    static final int Z0 = 1;
    private double lambda;

    public WaistFunction(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double getY(double x, double[] a) {
        double zr = Math.PI * a[0] * a[0] / this.lambda;
        return a[0] * Math.sqrt(1.0 + Math.pow((x - a[1]) / zr, 2.0));
    }

    @Override
    public double getPartialDerivate(double x, double[] a, int ak) {
        double zr = Math.PI * a[0] * a[0] / this.lambda;
        double rad = Math.sqrt(1.0 + Math.pow((x - a[1]) / zr, 2.0));
        switch (ak) {
            case 0: {
                return rad * (1.0 - 2.0 * Math.pow((x - a[1]) / zr / rad, 2.0));
            }
            case 1: {
                return -(x - a[1]) / zr / zr * a[0] / rad;
            }
        }
        throw new RuntimeException("No such parameter index: " + ak);
    }
}

