/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Cavity;
import components.Component;
import components.Database;
import components.Lens;
import components.Material;
import components.PartialBeam;
import io.XmlDoc;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentSet;
import utils.FileFilter;
import utils.JamMtException;

public class Settings {
    public static final String FS = System.getProperty("file.separator");
    public static final File STARTUP_FOLDER = new File(System.getProperty("user.home") + FS + ".JamMt");
    public static final File DB_FOLDER = new File(STARTUP_FOLDER + FS + "db");
    public static final File THEME_FOLDER = new File(STARTUP_FOLDER + FS + "themes");
    public static final File CONFIG_FILE = new File(STARTUP_FOLDER + FS + "config");
    public static final File LOG_FILE = new File(STARTUP_FOLDER + FS + "JamMt.log");
    private String curFile = "";
    public Beam beam;
    public ComponentSet defaultLenses = new ComponentSet();
    public CavitySet defaultCavities = new CavitySet();
    public ComponentSet fittingLenses = new ComponentSet();
    public ComponentSet components = new ComponentSet();
    public CavitySet CSdisp = new CavitySet(this);
    public String yAxis;
    public String y2Axis;
    public boolean autoScale;
    public String xMin;
    public String xMax;
    public String yMin;
    public String yMax;
    public String y2Min;
    public String y2Max;
    private int xRes;
    public boolean info;
    public boolean showTan;
    public boolean rotate;
    public String colortheme;
    public String openPath;
    public String savePath;
    public String dataPath;
    public String exportPath;
    public double dx_min;
    public boolean single_lens_use;
    public boolean right_focus;
    public boolean lens_overlap;
    public boolean nearby_solution;
    public double target_w0;
    public double target_z0_min;
    public double target_z0_max;
    public double target_w0_y;
    public double target_z0_min_y;
    public double target_z0_max_y;
    public double shiftingRange_start;
    public double shiftingRange_end;
    public double fitVisibility;
    public int Nlenses;
    private int grid_size;
    public ArrayList<Material> materials = new ArrayList();
    public ArrayList<String> eqns = new ArrayList();

    public int getGridSize() {
        return this.grid_size;
    }

    public void setGridSize(int size) throws JamMtException {
        if (size <= 0) {
            throw new JamMtException("The grid size has to be greater than zero.");
        }
        this.grid_size = size;
    }

    public int getResolution() {
        return this.xRes;
    }

    public void setResolution(int r) throws JamMtException {
        if (r <= 0) {
            throw new JamMtException("The resolution has to be greater than zero.");
        }
        this.xRes = r;
    }

    public Settings() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.beam = new Beam(new PartialBeam(3.7E-4, 0.0, 1.064E-6), this.components, this.CSdisp);
            this.CSdisp.setBeam(this.beam);
            this.defaultLenses.addComponent(new Lens(0.0, 0.05, 0.025));
            this.defaultLenses.addComponent(new Lens(0.01, -0.05, 0.025));
            this.defaultLenses.addComponent(new Lens(0.02, 0.1, 0.025));
            this.defaultLenses.addComponent(new Lens(0.03, -0.1, 0.025));
            this.defaultLenses.addComponent(new Lens(0.04, 0.2, 0.025));
            this.defaultLenses.addComponent(new Lens(0.05, -0.2, 0.025));
            this.fittingLenses.addComponent(new Lens(0.0, -0.1, 0.025));
            this.fittingLenses.addComponent(new Lens(0.0, 0.1, 0.025));
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        double[] bv = new double[]{1.03961212, 0.231792344, 1.01046945};
        double[] cv = new double[]{6.00069867E-15, 2.00179144E-14, 1.03560653E-10};
        this.eqns.add("vis($1,$2)=100*($1-$2)/($1+$2)");
        this.yAxis = "waistsize";
        this.y2Axis = "empty";
        this.autoScale = false;
        this.xMin = "auto";
        this.xMax = "auto";
        this.yMin = "-2000";
        this.yMax = "2000";
        this.y2Min = "auto";
        this.y2Max = "auto";
        this.xRes = 101;
        this.info = false;
        this.showTan = false;
        this.rotate = false;
        this.colortheme = "default";
        this.openPath = ".";
        this.savePath = ".";
        this.dataPath = ".";
        this.exportPath = ".";
        this.dx_min = 0.01;
        this.single_lens_use = false;
        this.right_focus = true;
        this.lens_overlap = true;
        this.nearby_solution = false;
        this.target_w0_y = 2.0E-5;
        this.target_w0 = 2.0E-5;
        this.target_z0_min_y = 0.79;
        this.target_z0_min = 0.79;
        this.target_z0_max_y = 0.8;
        this.target_z0_max = 0.8;
        this.shiftingRange_start = 0.0;
        this.shiftingRange_end = 0.8;
        this.fitVisibility = 0.99;
        this.Nlenses = 2;
        this.grid_size = 100;
    }

    public void writeToFile() {
        this.writeToFile(CONFIG_FILE.getAbsolutePath());
    }

    public void writeToFile(String fname) {
        if (!fname.endsWith("config")) {
            this.curFile = fname;
        }
        try {
            for (Cavity cav : this.CSdisp.getCavities()) {
                ComponentSet cavityComponents = new ComponentSet();
                for (Lens l : this.components.getLenses()) {
                    if (!cav.contains(l)) continue;
                    l.setCavityComponent(true);
                    cavityComponents.addComponent(l);
                }
                cav.setComponents(cavityComponents);
            }
            XmlDoc doc = new XmlDoc(fname, true);
            doc.writeSettings(this);
            doc.close();
        }
        catch (Exception e) {
            String mesg = "Error while saving file '" + fname + "':\n\n";
            mesg = mesg + e.toString();
            Logger.getLogger("JamMt").severe(mesg);
        }
    }

    public void loadFromFile() {
        this.loadFromFile(CONFIG_FILE.getAbsolutePath());
    }

    public void loadFromFile(String fname) {
        if (fname.equals("")) {
            return;
        }
        if (!fname.endsWith("config")) {
            this.curFile = fname;
        }
        try {
            XmlDoc doc = new XmlDoc(fname, false);
            doc.loadSettings(this);
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").warning(e.toString());
        }
        for (Cavity cav : this.CSdisp.getCavities()) {
            for (Lens l : cav.getComponents().getLenses()) {
                this.components.addComponent(l);
            }
        }
        this.beam.updateBeam();
    }

    public String getCurrentFile() {
        return this.curFile;
    }

    public String getCurrentFileBasename() {
        int idx = 1 + this.curFile.lastIndexOf(System.getProperty("file.separator"));
        return this.curFile.substring(idx);
    }

    public void loadDatabases() {
        this.loadDatabases(DB_FOLDER);
    }

    public void loadDatabases(File folder) {
        this.materials.clear();
        this.defaultLenses.removeAll();
        for (File f : folder.listFiles(new FileFilter(".jamDB"))) {
            Database db = new Database(f);
            File file = new File(folder + System.getProperty("file.separator") + db.getName() + ".disabled");
            db.setEnabled(!file.exists());
            if (!db.isEnabled()) continue;
            for (Component c : db.getComponents().getComponents()) {
                this.defaultLenses.addComponent(c);
            }
            for (Material m : db.getMaterials()) {
                this.materials.add(m);
            }
        }
    }
}

