/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.PartialBeam;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.Formatter;
import utils.JamMtException;

public class QParameter {
    private double reX;
    private double imX;
    private double reY;
    private double imY;
    private double z;

    public QParameter(double z, double re, double im) throws JamMtException {
        this(z, re, im, re, im);
    }

    public QParameter(double z, double reX, double imX, double reY, double imY) throws JamMtException {
        if (imX == 0.0 || imY == 0.0) {
            throw new JamMtException("Imaginary part of the q parameter is zero!");
        }
        this.z = z;
        this.reX = reX;
        this.imX = imX;
        this.reY = reY;
        this.imY = imY;
    }

    public double getRePart(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' not supported!");
        }
        if (plane.equals("x")) {
            return this.reX;
        }
        return this.reY;
    }

    public double getImPart(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' not supported!");
        }
        if (plane.equals("x")) {
            return this.imX;
        }
        return this.imY;
    }

    public void propagate(ABCDmatrix Mx, double z) {
        this.propagate(Mx, Mx, z);
    }

    public void propagate(ABCDmatrix Mx, ABCDmatrix My, double z) {
        this.z = z;
        try {
            double A = Mx.getElement("A");
            double B = Mx.getElement("B");
            double C = Mx.getElement("C");
            double D = Mx.getElement("D");
            double qabs = this.reX * this.reX + this.imX * this.imX;
            double nenner = C * C * qabs + D * D + 2.0 * C * D * this.reX;
            this.reX = (A * C * qabs + B * D + (A * D + B * C) * this.reX) / nenner;
            this.imX = Mx.determinant() * this.imX / nenner;
            A = My.getElement("A");
            B = My.getElement("B");
            C = My.getElement("C");
            D = My.getElement("D");
            qabs = this.reY * this.reY + this.imY * this.imY;
            nenner = C * C * qabs + D * D + 2.0 * C * D * this.reY;
            this.reY = (A * C * qabs + B * D + (A * D + B * C) * this.reY) / nenner;
            this.imY = My.determinant() * this.imY / nenner;
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
    }

    public PartialBeam toBeam(double n, double lambda) {
        double w0x = Math.sqrt(this.imX / Math.PI * lambda);
        double w0y = Math.sqrt(this.imY / Math.PI * lambda);
        double dzx = this.reX * n;
        double dzy = this.reY * n;
        try {
            PartialBeam b = new PartialBeam(w0x, this.z - dzx, w0y, this.z - dzy, lambda / n);
            return b;
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
            return null;
        }
    }

    public String toString() {
        return "" + Formatter.defaultFormat(this.reX) + " + i* " + Formatter.defaultFormat(this.imX);
    }
}

