/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.BeamAnalyzer;
import components.Component;
import components.Lens;
import components.Material;
import components.Substrate;
import components.TextLabel;
import gui.BeamAnalyzerEditor;
import gui.MainWindow;
import gui.SubstrateEditor;
import gui.TextLabelEditor;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import utils.ComponentSet;
import utils.DrawingArea;
import utils.Formatter;
import utils.JamMtException;

public class MouseEventHandler
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    private ComponentSet components;
    private Rectangle2D hotSpot = new Rectangle2D.Double();

    public MouseEventHandler(ComponentSet components) {
        this.components = components;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean i = false;
        for (Component comp : this.components.getComponents()) {
            Rectangle2D h = this.getHotSpot(comp);
            if (!h.contains(e.getX(), e.getY())) continue;
            this.components.setCurrent(comp);
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ArrayList<Material> materials = MainWindow.getInstance().getSettings().materials;
        for (Component comp : this.components.getComponents()) {
            Rectangle2D h = this.getHotSpot(comp);
            if (!h.contains(e.getX(), e.getY())) continue;
            if (e.getClickCount() == 2) {
                if (comp instanceof BeamAnalyzer) {
                    new BeamAnalyzerEditor(MainWindow.getInstance().getMainWnd(), (BeamAnalyzer)comp);
                } else if (comp instanceof TextLabel) {
                    new TextLabelEditor(MainWindow.getInstance().getMainWnd(), (TextLabel)comp);
                } else if (comp instanceof Lens) {
                    new SubstrateEditor(MainWindow.getInstance().getMainWnd(), (Lens)comp, materials, this.components);
                }
            } else {
                this.components.setCurrent(comp);
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MainWindow.getInstance().getDrawingArea().updatePlotRange();
        MainWindow.getInstance().getDrawingArea().getPlotData();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (MainWindow.getInstance().getSettings().rotate) {
            this.updateRotationAngle(e);
        } else {
            this.updateLocation(e);
            MainWindow.getInstance().getDrawingArea().updatePlotRange();
            MainWindow.getInstance().getDrawingArea().getPlotData();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String tooltip = null;
        for (Component comp : this.components.getComponents()) {
            Rectangle2D h = this.getHotSpot(comp);
            if (h.contains(e.getX(), e.getY())) {
                tooltip = "<html>";
                MainWindow.getInstance().getMainWnd().setCursor(new Cursor(12));
                if (MainWindow.getInstance().getSettings().info) break;
                tooltip = tooltip + comp.getName() + ":<br>";
                tooltip = tooltip + "z = " + Formatter.defaultFormat(comp.getPosition()) + " m<br>";
                if (comp instanceof Lens) {
                    try {
                        tooltip = comp instanceof Substrate ? tooltip + "f = " + Formatter.defaultFormat(((Substrate)comp).getFocalLength("x") * 1000.0) + " mm<br>" : tooltip + "f = " + Formatter.defaultFormat(((Lens)comp).getFocalLength("x") * 1000.0) + " mm<br>";
                    }
                    catch (JamMtException je) {
                        Logger.getLogger("JamMt").severe(je.toString());
                    }
                    tooltip = tooltip + "a = " + Formatter.defaultFormat(((Lens)comp).getAperture() * 1000.0) + " mm";
                }
                tooltip = tooltip + "</html>";
                break;
            }
            MainWindow.getInstance().getMainWnd().setCursor(new Cursor(0));
        }
        if (tooltip != null) {
            MainWindow.getInstance().getGlassPane().setToolTipText(tooltip);
            return;
        }
        MainWindow.getInstance().getMainWnd().setCursor(new Cursor(0));
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        double x = da.getScreenCoordinates(e.getX(), e.getY()).getX();
        double y = da.getScreenCoordinates(e.getX(), e.getY()).getY();
        if (Math.abs(y) < MainWindow.getInstance().getBeam().getWaistSizeAt(x, "x") * 1000000.0) {
            tooltip = "<html> Partial beam:<br>";
            tooltip = tooltip + "w0 = " + Formatter.defaultFormat(MainWindow.getInstance().getBeam().getW0At(x, "x") * 1000000.0) + " \u03bcm<br>";
            tooltip = tooltip + "z0 = " + Formatter.defaultFormat(MainWindow.getInstance().getBeam().getZ0At(x, "x")) + " m";
            tooltip = tooltip + "</html>";
        }
        MainWindow.getInstance().getGlassPane().setToolTipText(tooltip);
    }

    public void updateLocation(MouseEvent e) {
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        Component comp = this.components.getCurrent();
        if (comp != null) {
            double curPos = comp.getPosition();
            double newPos = da.getScreenCoordinates(e.getX(), e.getY()).getX();
            double dx = newPos - curPos;
            comp.setPosition(newPos);
            Collections.sort(this.components.getComponents());
            this.components.updateGroup(comp.getGroupID(), dx);
        }
    }

    private void updateRotationAngle(MouseEvent e) {
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        Component comp = this.components.getCurrent();
        if (comp != null && comp instanceof Substrate) {
            Substrate sub = (Substrate)comp;
            Rectangle2D r = this.getHotSpot(comp);
            double center = r.getX() + r.getWidth() / 2.0;
            double dx = (double)e.getX() - center;
            if (Math.abs(dx) < r.getWidth()) {
                double angle = -dx / r.getWidth() * 90.0;
                sub.setAngleInDegrees(angle);
            }
        }
    }

    public void setHotSpot(Rectangle2D h) {
        this.hotSpot = h;
    }

    private Rectangle2D getHotSpot(Component comp) {
        double z = comp.getPosition();
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        Point2D xy = da.getGraphCoordinates(z, 0.0);
        return new Rectangle2D.Double(xy.getX() - this.hotSpot.getWidth() / 2.0, this.hotSpot.getY(), this.hotSpot.getWidth(), this.hotSpot.getHeight());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int sign = e.getWheelRotation();
        double fraction = 0.1;
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                da.zoom("y", (double)sign * fraction);
            } else {
                da.shift("y", (double)sign * fraction);
            }
        } else if (e.isControlDown()) {
            da.zoom("z", (double)sign * fraction);
        } else {
            da.shift("z", (double)sign * fraction);
        }
    }
}

