/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Lens;
import components.PartialBeam;
import components.Substrate;
import java.util.logging.Logger;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentSet;
import utils.Formatter;
import utils.JamMtException;

public class ModematchingSolution {
    public double visibility_x;
    public double visibility_y;
    public PartialBeam beam;
    public PartialBeam initialBeam;
    public PartialBeam targetBeam;
    public ComponentSet components;

    public ModematchingSolution(ComponentSet set, PartialBeam initialBeam, PartialBeam targetBeam) {
        this.components = set;
        this.initialBeam = initialBeam;
        this.targetBeam = targetBeam;
        try {
            Beam b = new Beam(initialBeam, this.components, new CavitySet());
            this.beam = b.getLast();
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        this.visibility_x = this.beam.calculateOverlap(targetBeam, "x");
        this.visibility_y = this.beam.calculateOverlap(targetBeam, "y");
    }

    public String toString() {
        double f = 0.0;
        double vis_tmp = 0.0;
        double vis_tmp_y = 0.0;
        String ausgabe = "";
        for (Lens l : this.components.getLenses()) {
            if (l instanceof Substrate) {
                f = ((Substrate)l).getFocalLength("x");
            } else {
                try {
                    f = l.getFocalLength("x");
                }
                catch (JamMtException je) {
                    Logger.getLogger("JamMt").severe(je.toString());
                }
            }
            ausgabe = ausgabe + "f=" + Formatter.defaultFormat(f * 1000.0) + " mm @ z=" + Formatter.defaultFormat(l.getPosition()) + ", ";
        }
        if (this.visibility_x == this.visibility_y) {
            ausgabe = ausgabe + " (v=" + Formatter.defaultFormat(this.visibility_x * 100.0) + " %)";
        } else {
            ausgabe = ausgabe + " (vx=" + Formatter.defaultFormat(this.visibility_x * 100.0) + " %, ";
            ausgabe = ausgabe + " vy=" + Formatter.defaultFormat(this.visibility_y * 100.0) + " %)";
        }
        return ausgabe;
    }
}

