/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Component;
import components.PartialBeam;
import java.util.Vector;
import org.jdesktop.swingworker.SwingWorker;
import utils.ComponentSet;
import utils.FitParameter;
import utils.ModematchingSolution;

public abstract class ModematchingFinder
extends SwingWorker<Void, Void> {
    PartialBeam initialBeam;
    PartialBeam resultingBeam;
    ComponentSet fitLenses;
    ComponentSet persistentSet;
    FitParameter fitparameter;
    Vector<ModematchingSolution> solutions = new Vector();
    boolean cancel = false;

    public ModematchingFinder(PartialBeam initialBeam, PartialBeam resultingBeam, ComponentSet fitLenses, ComponentSet persistentSet, FitParameter fp) {
        this.initialBeam = initialBeam;
        this.resultingBeam = resultingBeam;
        this.fitLenses = fitLenses;
        this.persistentSet = persistentSet;
        this.fitparameter = fp;
    }

    protected abstract void startSearch();

    public Vector<ModematchingSolution> getSolutions() {
        return this.solutions;
    }

    public void addComponentSetIfValid(ComponentSet curSet, PartialBeam btmp) {
        double vis = this.fitparameter.visibility;
        double vis_tmp = 0.0;
        double vis_tmp_y = 0.0;
        double z0_tmp = btmp.getWaistPosition("x");
        double z0_tmp_y = btmp.getWaistPosition("y");
        double z0_res_min = this.resultingBeam.getWaistPosition("x");
        double z0_res_max = z0_res_min + this.fitparameter.dz0x;
        double z0_res_min_y = this.resultingBeam.getWaistPosition("y");
        double z0_res_max_y = z0_res_min_y + this.fitparameter.dz0y;
        PartialBeam bres = (PartialBeam)this.resultingBeam.clone();
        if ((z0_tmp < z0_res_min || z0_tmp > z0_res_max) && (z0_tmp_y < z0_res_min_y || z0_tmp_y > z0_res_max_y)) {
            vis_tmp = 0.0;
            vis_tmp_y = 0.0;
        } else {
            bres.setWaistPosition(btmp.getWaistPosition("x"), btmp.getWaistPosition("y"));
            vis_tmp = btmp.calculateOverlap(bres, "x");
            vis_tmp_y = btmp.calculateOverlap(bres, "y");
        }
        if (vis_tmp > vis && vis_tmp_y > vis) {
            boolean found = false;
            for (ModematchingSolution st : this.solutions) {
                if (!st.components.comparableTo(curSet)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.solutions.add(new ModematchingSolution(curSet, this.initialBeam, bres));
            }
        }
    }

    public static Vector<ComponentSet> getLensSets(ComponentSet fitLenses, int nl) {
        int i;
        Vector<ComponentSet> sets = new Vector<ComponentSet>();
        Vector<Integer> idx = new Vector<Integer>();
        Vector<Integer> interval = new Vector<Integer>();
        int sz = fitLenses.getLenses().size();
        if (nl == 0 || sz == 0) {
            return sets;
        }
        for (i = 0; i < nl; ++i) {
            idx.add(0);
            interval.add((int)Math.pow(sz, i));
        }
        i = 1;
        while ((double)i <= Math.pow(sz, nl)) {
            ComponentSet set = new ComponentSet();
            for (int j = 0; j < nl; ++j) {
                Component l = (Component)fitLenses.getLenses().get((Integer)idx.elementAt(j)).clone();
                set.addComponent(l);
                if (i % (Integer)interval.elementAt(j) != 0) continue;
                idx.setElementAt(((Integer)idx.elementAt(j) + 1) % sz, j);
            }
            if (ModematchingFinder.isNewSet(set, sets)) {
                sets.add(set);
            }
            ++i;
        }
        return sets;
    }

    public static boolean isNewSet(ComponentSet set, Vector<ComponentSet> sets) {
        for (ComponentSet cset : sets) {
            if (!cset.isComparableTo(set)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Void doInBackground() {
        this.startSearch();
        return null;
    }

    @Override
    public void done() {
    }
}

