/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import utils.JamMtException;

public class MathParser {
    private String exp;
    private String file;
    private Vector<String> h;
    private Vector<String> fcts = new Vector();

    public MathParser(String exp, String file) {
        this.exp = exp;
        this.file = file;
    }

    public MathParser(String exp) {
        this.exp = exp.replaceAll(" ", "");
    }

    public void setFunctions(ArrayList<String> fcts) {
        for (String f : fcts) {
            this.fcts.add(f);
        }
    }

    private void setValues(Vector<String> h) {
        this.h = h;
    }

    public double getValue() throws JamMtException {
        Vector values = new Vector();
        for (String f : this.fcts) {
            this.replaceUserDefinedFunction(f);
        }
        String eqn = this.substitute();
        return this.evaluate(eqn);
    }

    private void replaceUserDefinedFunction(String f) throws JamMtException {
        this.h = new Vector();
        for (int i = 0; i < 10; ++i) {
            this.h.addElement("0.0");
        }
        String fname = f.substring(0, f.indexOf("("));
        int idx = this.exp.indexOf(fname);
        if (idx < 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(f, "=");
        String lhs = st.nextToken();
        String rhs = st.nextToken();
        st = new StringTokenizer(lhs.substring(lhs.indexOf("(") + 1, lhs.indexOf(")")), ",");
        Vector<String> vars = new Vector<String>();
        while (st.hasMoreTokens()) {
            vars.add(st.nextToken());
        }
        int fstart = this.exp.indexOf(fname);
        int fend = this.exp.indexOf(")", fstart) + 1;
        st = new StringTokenizer(this.exp.substring(this.exp.indexOf("(", fstart) + 1, this.exp.indexOf(")", fstart)), ",");
        Vector<String> vals = new Vector<String>();
        while (st.hasMoreTokens()) {
            vals.add(st.nextToken());
        }
        for (int i = this.h.size(); i > 0; --i) {
            idx = vars.indexOf("$" + i);
            if (idx < 0) continue;
            this.h.setElementAt((String)vals.elementAt(idx), i - 1);
        }
        MathParser mpTmp = new MathParser(rhs);
        mpTmp.setValues(this.h);
        this.exp = this.exp.replace(this.exp.substring(fstart, fend), "" + mpTmp.getValue());
    }

    public Vector<Double> getValues() {
        Vector<Double> ret = new Vector<Double>();
        try {
            String zeile;
            BufferedReader fin = new BufferedReader(new FileReader(this.file));
            while ((zeile = fin.readLine()) != null) {
                if (zeile.startsWith("#") || zeile.length() == 0) continue;
                StringTokenizer st = new StringTokenizer(zeile);
                this.h = new Vector();
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    if (tmp.toLowerCase().equals("nan")) {
                        Logger.getLogger("JamMt").severe("NaN value occured, replacing it by 0 ...");
                        tmp = "0.0";
                    }
                    this.h.addElement(tmp);
                }
                String eqn = this.substitute();
                ret.addElement(this.evaluate(eqn));
            }
            fin.close();
        }
        catch (Exception e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        return ret;
    }

    private String substitute() {
        String ret = new String(this.exp);
        try {
            for (int i = this.h.size(); i > 0; --i) {
                ret = ret.replaceAll("\\$" + i, this.h.elementAt(i - 1));
            }
        }
        catch (Exception e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        return ret;
    }

    private double evaluate(String eqn) throws JamMtException {
        double ret;
        StringBuffer sb = new StringBuffer("(" + eqn + ")");
        String ibrk = new String("");
        String result = "";
        int index = -1;
        while (!(ibrk = this.getInnerBracket(sb.toString())).equals("")) {
            result = this.parseExpression(ibrk);
            index = sb.indexOf(ibrk);
            sb.replace(index - 1, index + ibrk.length() + 1, result);
        }
        try {
            ret = Double.parseDouble(sb.toString());
        }
        catch (Exception e) {
            throw new JamMtException(e.toString());
        }
        return ret;
    }

    private String getInnerBracket(String eqn) {
        int index = -1;
        StringBuffer substr = new StringBuffer();
        index = eqn.indexOf(")");
        if (index > 0) {
            substr.append(eqn.substring(0, index));
            index = substr.lastIndexOf("(");
            if (index >= 0) {
                substr = new StringBuffer(substr.substring(index + 1, substr.length()));
            }
        } else {
            return "";
        }
        return substr.toString();
    }

    private String parseExpression(String exp) {
        String operator;
        int i;
        StringBuffer p_exp = new StringBuffer(exp);
        int prev_op = 120;
        for (int i2 = 1; i2 < p_exp.length(); ++i2) {
            char op = p_exp.charAt(i2);
            if (op == 'e' || op == 'E') {
                ++i2;
                continue;
            }
            if ("+-*/".indexOf(prev_op) < 0 && "+-*/".indexOf(op) >= 0) {
                p_exp.insert(i2 + 1, " ");
                p_exp.insert(i2, " ");
                i2 += 2;
            }
            prev_op = op;
        }
        StringTokenizer st = new StringTokenizer(p_exp.toString());
        Vector<String> term = new Vector<String>();
        double value = 0.0;
        double result = 0.0;
        while (st.hasMoreTokens()) {
            term.addElement(st.nextToken());
        }
        for (i = 0; i < term.size(); ++i) {
            operator = (String)term.elementAt(i);
            if (operator.equals("*")) {
                value = new Double((String)term.elementAt(i - 1)) * new Double((String)term.elementAt(i + 1));
                term.insertElementAt(String.valueOf(value), i - 1);
                term.remove(i);
                term.remove(i);
                term.remove(i);
                --i;
            }
            if (!operator.equals("/")) continue;
            value = new Double((String)term.elementAt(i - 1)) / new Double((String)term.elementAt(i + 1));
            term.insertElementAt(String.valueOf(value), i - 1);
            term.remove(i);
            term.remove(i);
            term.remove(i);
            --i;
        }
        for (i = 0; i < term.size(); ++i) {
            operator = (String)term.elementAt(i);
            if (operator.equals("+")) {
                value = new Double((String)term.elementAt(i - 1)) + new Double((String)term.elementAt(i + 1));
                term.insertElementAt(String.valueOf(value), i - 1);
                term.remove(i);
                term.remove(i);
                term.remove(i);
                --i;
            }
            if (!operator.equals("-")) continue;
            value = new Double((String)term.elementAt(i - 1)) - new Double((String)term.elementAt(i + 1));
            term.insertElementAt(String.valueOf(value), i - 1);
            term.remove(i);
            term.remove(i);
            term.remove(i);
            --i;
        }
        return (String)term.elementAt(0);
    }
}

