/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ListManager<T> {
    private ArrayList<T> content = new ArrayList();
    private DefaultListModel model = new DefaultListModel();
    private JList list;

    public ListManager(JList list) {
        this(list, null);
    }

    public ListManager(JList list, ArrayList<T> content) {
        this.list = list;
        if (content != null) {
            this.content = content;
        }
        list.setModel(this.model);
        this.update(0);
    }

    private void update(int idx) {
        this.model.clear();
        for (T t : this.content) {
            this.model.addElement(t.toString());
        }
        if (idx >= 0 && idx < this.content.size()) {
            this.list.setSelectedIndex(idx);
        }
    }

    public void updateCurrentItem(T t) {
        int idx = this.currentIndex();
        if (idx < 0) {
            return;
        }
        this.content.set(idx, t);
        this.update(idx);
    }

    public T getSelectedItem() {
        int idx = this.currentIndex();
        if (idx < 0) {
            return null;
        }
        return this.content.get(idx);
    }

    public void addItem(T t) {
        if (t == null) {
            return;
        }
        this.content.add(t);
        this.update(this.content.size() - 1);
    }

    public void deleteItem(int idx) {
        if (idx < 0) {
            return;
        }
        this.content.remove(idx);
        this.update(0);
    }

    public void deleteCurrentItem() {
        this.deleteItem(this.currentIndex());
    }

    public int currentIndex() {
        int idx = this.list.getSelectedIndex();
        if (idx < 0 || idx >= this.content.size()) {
            return -1;
        }
        return idx;
    }

    public ArrayList<T> getContent() {
        return this.content;
    }
}

