/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Component;
import components.Lens;
import components.Substrate;
import gui.MainWindow;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import utils.CavitySet;
import utils.ComponentSet;
import utils.DrawingArea;
import utils.Settings;

public class KeyEventHandler
extends KeyAdapter {
    private ComponentSet components;
    private CavitySet cs;
    private Settings sets;
    private boolean mainUpdate = true;

    public KeyEventHandler(Settings sets) {
        this.sets = sets;
        this.components = sets.components;
        this.cs = sets.CSdisp;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        this.mainUpdate = true;
        if (e.isShiftDown()) {
            this.handleShiftDown(key, this.components, this.cs);
        } else if (e.isControlDown()) {
            this.handleControlDown(key);
        } else {
            this.handleKeyEvent(key, this.components, this.cs);
        }
        MainWindow.getInstance().getDrawingArea().updatePlotRange();
        MainWindow.getInstance().getDrawingArea().getPlotData();
        if (this.mainUpdate) {
            MainWindow.getInstance().mainUpdate();
        }
    }

    private void handleShiftDown(int key, ComponentSet components, CavitySet cavities) {
        Component current = components.getCurrent();
        ArrayList<Lens> list = components.getLenses();
        if (key == 37) {
            if (this.sets.rotate && current instanceof Substrate) {
                ((Substrate)current).rotateByDegrees(-0.1);
            } else {
                this.moveComponent(-0.1);
            }
            this.mainUpdate = false;
        } else if (key == 39) {
            if (this.sets.rotate && current instanceof Substrate) {
                ((Substrate)current).rotateByDegrees(0.1);
            } else {
                this.moveComponent(0.1);
            }
            this.mainUpdate = false;
        } else if (key != 57 || current instanceof Substrate) {
            // empty if block
        }
    }

    private void handleControlDown(int key) {
        Component current = this.components.getCurrent();
        if (key == 37) {
            if (this.sets.rotate && current instanceof Substrate) {
                ((Substrate)current).rotateByDegrees(-10.0);
            } else {
                this.moveComponent(-10.0);
            }
            this.mainUpdate = false;
        } else if (key == 39) {
            if (this.sets.rotate && current instanceof Substrate) {
                ((Substrate)current).rotateByDegrees(10.0);
            } else {
                this.moveComponent(10.0);
            }
            this.mainUpdate = false;
        }
    }

    private void handleKeyEvent(int key, ComponentSet components, CavitySet cavities) {
        Component current = components.getCurrent();
        if (current == null) {
            return;
        }
        switch (key) {
            case 37: {
                if (this.sets.rotate && current instanceof Substrate) {
                    ((Substrate)current).rotateByDegrees(-1.0);
                } else {
                    this.moveComponent(-1.0);
                }
                this.mainUpdate = false;
                break;
            }
            case 39: {
                if (this.sets.rotate && current instanceof Substrate) {
                    ((Substrate)current).rotateByDegrees(1.0);
                } else {
                    this.moveComponent(1.0);
                }
                this.mainUpdate = false;
            }
        }
    }

    private void moveComponent(double dx) {
        Component comp = this.components.getCurrent();
        if (comp == null) {
            return;
        }
        DrawingArea da = MainWindow.getInstance().getDrawingArea();
        double curPos = comp.getPosition();
        double newPos = da.getGraphCoordinates(curPos, 0.0).getX() + dx;
        newPos = da.getScreenCoordinates(newPos, 0.0).getX();
        double dx_new = newPos - curPos;
        comp.setPosition(newPos);
        Collections.sort(this.components.getComponents());
        this.components.updateGroup(comp.getGroupID(), dx_new);
    }
}

