/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Component;
import components.Lens;
import components.PartialBeam;
import java.util.Vector;
import java.util.logging.Logger;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentSet;
import utils.FitParameter;
import utils.JamMtException;
import utils.ModematchingFinder;

public class GridSearch
extends ModematchingFinder {
    public GridSearch(PartialBeam initialBeam, PartialBeam resultingBeam, ComponentSet fitLenses, ComponentSet persistentSet, FitParameter fp) {
        super(initialBeam, resultingBeam, fitLenses, persistentSet, fp);
    }

    @Override
    public void startSearch() {
        int i;
        int k = 0;
        int sz = this.fitparameter.grid_size;
        int nl = this.fitparameter.nl;
        Vector<Double> pos = new Vector<Double>();
        Vector<Integer> idx = new Vector<Integer>();
        Vector<Integer> interval = new Vector<Integer>();
        for (i = 0; i < sz; ++i) {
            pos.add(this.fitparameter.z_start + (double)i * (this.fitparameter.z_end - this.fitparameter.z_start) / (double)sz);
        }
        for (i = 0; i < nl; ++i) {
            idx.add(0);
            interval.add((int)Math.pow(sz, i));
        }
        Vector<ComponentSet> lensSet = ModematchingFinder.getLensSets(this.fitLenses, this.fitparameter.nl);
        int N = lensSet.size() * (int)Math.pow(sz, nl);
        try {
            Beam b = new Beam((PartialBeam)this.initialBeam.clone(), new ComponentSet(), new CavitySet());
            for (ComponentSet set : lensSet) {
                if (!this.cancel) {
                    int n = 0;
                    int i2 = 1;
                    while ((double)i2 <= Math.pow(sz, nl) && !this.cancel) {
                        this.setProgress((int)(((double)k * Math.pow(sz, nl) + (double)n++) * 100.0 / (double)N));
                        ComponentSet curSet = new ComponentSet();
                        for (Lens c : this.persistentSet.getLenses()) {
                            curSet.addComponent(c);
                        }
                        for (int j = 0; j < nl; ++j) {
                            Component l = (Component)set.getLenses().get(j).clone();
                            l.detachAll();
                            l.setPosition((Double)pos.elementAt((Integer)idx.elementAt(j)));
                            curSet.addComponent(l);
                            if (i2 % (Integer)interval.elementAt(j) != 0) continue;
                            idx.setElementAt(((Integer)idx.elementAt(j) + 1) % sz, j);
                        }
                        b.setLenses(curSet);
                        this.addComponentSetIfValid(curSet, b.getLast());
                        ++i2;
                    }
                    ++k;
                    continue;
                }
                break;
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }
}

