/*
 * Decompiled with CFR 0.152.
 */
package utils;

import ext.LMA;
import ext.LMAFunction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import utils.Formatter;
import utils.JamMtException;
import utils.WaistFunction;

public class GaussBeamFitter {
    Vector<Double> w = new Vector();
    Vector<Double> wy = new Vector();
    Vector<Double> z = new Vector();
    double w0 = 0.0;
    double z0 = 0.0;
    double w0y = 0.0;
    double z0y = 0.0;
    String message = "";
    private double lambda;

    public GaussBeamFitter(String fname, double lambda) {
        try {
            this.setWaveLength(lambda);
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        this.readDataFromFile(fname);
        this.computeBeamParameters();
    }

    public void setWaveLength(double lambda) throws JamMtException {
        if (lambda <= 0.0) {
            throw new JamMtException("The wavelength has to be greater than zero (was " + lambda + ").");
        }
        this.lambda = lambda;
    }

    private void readDataFromFile(String fname) {
        try {
            String zeile;
            FileReader fin = new FileReader(fname);
            BufferedReader br = new BufferedReader(fin);
            while ((zeile = br.readLine()) != null) {
                if (zeile.startsWith("#") || zeile.equals("")) continue;
                StringTokenizer st = new StringTokenizer(zeile);
                this.z.add(Double.parseDouble(st.nextToken()) * 0.01);
                this.w.add(Double.parseDouble(st.nextToken()) * 1.0E-6);
                if (!st.hasMoreTokens()) continue;
                this.wy.add(Double.parseDouble(st.nextToken()) * 1.0E-6);
            }
            fin.close();
        }
        catch (Exception e) {
            String mesg = "Error while reading file '" + fname + "':\n\n";
            mesg = mesg + e.toString();
            Logger.getLogger("JamMt").severe(mesg);
        }
    }

    private void computeBeamParameters() {
        int min = 0;
        double[] para = new double[2];
        double[][] data = new double[2][this.w.size()];
        for (int i = 0; i < this.w.size(); ++i) {
            data[0][i] = this.z.elementAt(i);
            data[1][i] = this.w.elementAt(i);
            if (!(this.w.elementAt(i) < this.w.elementAt(min))) continue;
            min = i;
        }
        para[0] = this.w.elementAt(min);
        para[1] = this.z.elementAt(min);
        LMA lma = new LMA((LMAFunction)new WaistFunction(this.lambda), para, data);
        lma.fit();
        this.w0 = lma.parameters[0];
        this.z0 = lma.parameters[1];
        this.message = this.message + "Fit results after " + lma.iterationCount + " iterations (chi2 = " + Formatter.expFormat(lma.chi2) + ")\n";
        this.message = this.message + "  w0 = " + Formatter.defaultFormat(this.w0 * 1000000.0) + " \u03bcm\n";
        this.message = this.message + "  z0 = " + Formatter.defaultFormat(this.z0 * 100.0) + " cm\n";
        min = 0;
        if (this.wy.size() != 0) {
            for (int i = 0; i < this.wy.size(); ++i) {
                data[1][i] = this.wy.elementAt(i);
                if (!(this.wy.elementAt(i) < this.wy.elementAt(min))) continue;
                min = i;
            }
            para[0] = this.wy.elementAt(min);
            para[1] = this.z.elementAt(min);
            lma = new LMA((LMAFunction)new WaistFunction(this.lambda), para, data);
            lma.fit();
            this.w0y = lma.parameters[0];
            this.z0y = lma.parameters[1];
            this.message = this.message + "\n\nFit results after " + lma.iterationCount + " iterations (chi2 = " + Formatter.expFormat(lma.chi2) + ")\n";
            this.message = this.message + "  w0y = " + Formatter.defaultFormat(this.w0y * 1000000.0) + " \u03bcm\n";
            this.message = this.message + "  z0y = " + Formatter.defaultFormat(this.z0y * 100.0) + " cm\n";
        } else {
            this.w0y = this.w0;
            this.z0y = this.z0;
        }
    }

    public String messages() {
        return this.message;
    }

    public double getW0(String plane) {
        if (plane.equals("x")) {
            return this.w0;
        }
        return this.w0y;
    }

    public double getZ0(String plane) {
        if (plane.equals("x")) {
            return this.z0;
        }
        return this.z0y;
    }
}

