/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Formatter {
    private static void setLocale() {
        Locale.setDefault(Locale.ENGLISH);
    }

    public static String defaultFormat(double x) {
        Formatter.setLocale();
        DecimalFormat fmt = new DecimalFormat("#.###");
        return fmt.format(x);
    }

    public static String expFormat(double x) {
        Formatter.setLocale();
        DecimalFormat fmt = new DecimalFormat("#.###E0");
        return fmt.format(x);
    }

    public static String autoFormat(double x) {
        int i;
        DecimalFormat fmt = new DecimalFormat("0.00");
        double[] fact = new double[]{1.0E-6, 0.001, 1.0, 1000.0};
        String[] meas = new String[]{"\u00b5m", "mm", "m", "km"};
        if (x == 0.0) {
            return "0.00 m";
        }
        if (x > 100000.0) {
            return new DecimalFormatSymbols().getInfinity();
        }
        for (i = meas.length - 1; i >= 0 && !(Math.abs(x / fact[i]) >= 1.0); --i) {
        }
        if (i < 0) {
            return "" + Formatter.expFormat(x) + " m";
        }
        return "" + fmt.format(x / fact[i]) + " " + meas[i];
    }

    public static String residualFormat(double x, double norm) {
        int N = (int)(x / norm);
        double r = x - (double)N * norm;
        return "" + N + "*u + " + Formatter.autoFormat(r);
    }

    public static String timeFormat(int t) {
        Formatter.setLocale();
        DecimalFormat fmt = new DecimalFormat("00");
        return fmt.format((double)t);
    }
}

