/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gui.MainWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import utils.Beam;
import utils.BeamObserver;
import utils.ColorTheme;
import utils.ComponentSet;
import utils.JamMtException;
import utils.Settings;

public class DrawingArea
extends ChartPanel
implements BeamObserver {
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private XYSeriesCollection y2dataset = new XYSeriesCollection();
    private XYPlot plot;
    private int STEPS;
    private double xmin;
    private double xmax;
    private Beam beam;
    private ComponentSet components;
    private Settings sets;
    private ColorTheme theme;
    private float[] dash = new float[]{2.0f, 2.0f};
    private BasicStroke stroke = new BasicStroke(2.0f, 0, 1, 2.0f, this.dash, 0.0f);

    public DrawingArea(Settings sets) {
        super(new JFreeChart(new XYPlot()), true);
        this.sets = sets;
        this.beam = sets.beam;
        this.components = sets.components;
        this.beam.attach(this);
        try {
            this.theme = new ColorTheme(sets.colortheme);
        }
        catch (JamMtException e) {
            sets.colortheme = "default";
            try {
                this.theme = new ColorTheme(sets.colortheme);
            }
            catch (JamMtException ex) {
                Logger.getLogger("JamMt").severe("Failed to fall back to the default colortheme");
            }
        }
        this.createChart();
        this.updatePlotRange();
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void createChart() {
        String xLabel = "z [m]";
        String yLabel = this.sets.yAxis;
        JFreeChart jfc = ChartFactory.createXYLineChart(null, xLabel, yLabel, this.dataset, PlotOrientation.VERTICAL, false, false, false);
        this.plot = (XYPlot)jfc.getPlot();
        if (!this.sets.y2Axis.equals("empty")) {
            NumberAxis y2axis = new NumberAxis(this.sets.y2Axis);
            this.plot.setRangeAxis(1, y2axis);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setDataset(1, this.y2dataset);
            this.plot.mapDatasetToRangeAxis(1, 1);
            if (!this.sets.autoScale) {
                if (!this.sets.y2Min.equals("auto")) {
                    y2axis.setLowerBound(Double.parseDouble(this.sets.y2Min));
                }
                if (!this.sets.y2Max.equals("auto")) {
                    y2axis.setUpperBound(Double.parseDouble(this.sets.y2Max));
                }
            }
            if (this.sets.y2Axis.equals("waistsize")) {
                y2axis.setLabel("w(z) [\u03bcm]");
            } else if (this.sets.y2Axis.equals("radius of curvature")) {
                y2axis.setLabel("Roc [m]");
            } else {
                y2axis.setLabel("phi [\u00b0]");
            }
            y2axis.setLabelAngle(Math.PI);
        }
        ValueAxis yaxis = this.plot.getRangeAxis(0);
        if (!this.sets.autoScale) {
            if (!this.sets.yMin.equals("auto")) {
                yaxis.setLowerBound(Double.parseDouble(this.sets.yMin));
            }
            if (!this.sets.yMax.equals("auto")) {
                yaxis.setUpperBound(Double.parseDouble(this.sets.yMax));
            }
        }
        ValueAxis xaxis = this.plot.getDomainAxis(0);
        if (!this.sets.autoScale) {
            if (!this.sets.xMin.equals("auto")) {
                xaxis.setLowerBound(Double.parseDouble(this.sets.xMin));
            }
            if (!this.sets.xMax.equals("auto")) {
                xaxis.setUpperBound(Double.parseDouble(this.sets.xMax));
            }
        }
        if (this.sets.yAxis.equals("waistsize")) {
            yaxis.setLabel("w(z) [\u03bcm]");
        } else if (this.sets.yAxis.equals("radius of curvature")) {
            yaxis.setLabel("Roc [m]");
        } else {
            yaxis.setLabel("phi [\u00b0]");
        }
        this.theme.apply(this);
        this.setChart(jfc);
    }

    public void setColors(Color ChartFgCol, Color ChartFg2Col, Color ChartBgCol, Color GridCol) {
        this.plot.getRenderer().setSeriesPaint(0, ChartFgCol);
        this.plot.getRenderer().setSeriesPaint(1, ChartFgCol);
        this.plot.getRenderer().setSeriesPaint(2, ChartFgCol);
        this.plot.getRenderer().setSeriesPaint(3, ChartFgCol);
        StandardXYItemRenderer rendery2 = new StandardXYItemRenderer(2);
        rendery2.setSeriesPaint(0, ChartFg2Col);
        rendery2.setSeriesPaint(1, ChartFg2Col);
        rendery2.setSeriesPaint(2, ChartFg2Col);
        rendery2.setSeriesPaint(3, ChartFg2Col);
        this.plot.setRenderer(1, rendery2);
        if (this.plot.getRangeAxis(1) != null) {
            this.plot.getRangeAxis(1).setLabelPaint(ChartFg2Col);
        }
        this.plot.getRenderer().setSeriesStroke(2, this.stroke);
        this.plot.getRenderer().setSeriesStroke(3, this.stroke);
        rendery2.setSeriesStroke(2, this.stroke);
        rendery2.setSeriesStroke(3, this.stroke);
        this.plot.setDomainGridlinePaint(GridCol);
        this.plot.setRangeGridlinePaint(GridCol);
        this.plot.setBackgroundPaint(ChartBgCol);
    }

    private void updateChart() {
        this.getPlotData();
    }

    public void updatePlotRange() {
        this.xmin = -2.0 * this.beam.getInitialBeam().getRayleighRange("x");
        this.xmax = 2.0 * this.beam.getInitialBeam().getRayleighRange("x");
        if (this.components.getLenses().size() != 0) {
            double tmp = Math.min(this.components.getFirstLens().getPosition(), this.beam.getInitialBeam().getWaistPosition("x"));
            if (tmp < this.xmin) {
                this.xmin = tmp;
            }
            if ((tmp = Math.max(this.components.getLastLens().getPosition(), this.beam.getLast().getWaistPosition("x"))) > this.xmax) {
                this.xmax = tmp;
            }
            this.xmin *= 1.1;
            this.xmax *= 1.1;
        }
        if (!this.sets.autoScale) {
            if (!this.sets.xMin.equals("auto")) {
                this.xmin = Double.parseDouble(this.sets.xMin);
            }
            if (!this.sets.xMax.equals("auto")) {
                this.xmax = Double.parseDouble(this.sets.xMax);
            }
        }
    }

    public void getPlotData() {
        XYSeries xyp = new XYSeries((Comparable)((Object)"Beam"), false);
        XYSeries xym = new XYSeries((Comparable)((Object)""), false);
        XYSeries xy2p = new XYSeries((Comparable)((Object)"Beam"), false);
        XYSeries xy2m = new XYSeries((Comparable)((Object)""), false);
        XYSeries xyp_tan = new XYSeries((Comparable)((Object)"Beam"), false);
        XYSeries xym_tan = new XYSeries((Comparable)((Object)""), false);
        XYSeries xy2p_tan = new XYSeries((Comparable)((Object)"Beam"), false);
        XYSeries xy2m_tan = new XYSeries((Comparable)((Object)""), false);
        this.STEPS = this.sets.getResolution();
        this.dataset.removeAllSeries();
        this.y2dataset.removeAllSeries();
        for (int i = 0; i <= this.STEPS; ++i) {
            double y;
            double x = this.xmin + (double)i * (this.xmax - this.xmin) / (double)this.STEPS;
            if (this.sets.yAxis.equals("waistsize")) {
                y = this.beam.getWaistSizeAt(x, "x");
                xyp.add(x, y * 1000000.0, false);
                xym.add(x, -y * 1000000.0, false);
                if (this.sets.showTan) {
                    y = this.beam.getWaistSizeAt(x, "y");
                    xyp_tan.add(x, y * 1000000.0, false);
                    xym_tan.add(x, -y * 1000000.0, false);
                }
            } else if (this.sets.yAxis.equals("radius of curvature")) {
                y = this.beam.getRadiusAt(x, "x");
                xyp.add(x, y, false);
                if (this.sets.showTan) {
                    y = this.beam.getRadiusAt(x, "y");
                    xyp_tan.add(x, y, false);
                }
            } else if (this.sets.yAxis.equals("gouy phase")) {
                y = this.beam.getGouyPhaseAt(x, "x");
                xyp.add(x, y * 180.0 / Math.PI, false);
                if (this.sets.showTan) {
                    y = this.beam.getGouyPhaseAt(x, "y");
                    xyp_tan.add(x, y * 180.0 / Math.PI, false);
                }
            }
            if (this.sets.y2Axis.equals("waistsize")) {
                y = this.beam.getWaistSizeAt(x, "x");
                xy2p.add(x, y * 1000000.0, false);
                xy2m.add(x, -y * 1000000.0, false);
                if (!this.sets.showTan) continue;
                y = this.beam.getWaistSizeAt(x, "y");
                xy2p_tan.add(x, y * 1000000.0, false);
                xy2m_tan.add(x, -y * 1000000.0, false);
                continue;
            }
            if (this.sets.y2Axis.equals("radius of curvature")) {
                y = this.beam.getRadiusAt(x, "x");
                xy2p.add(x, y, false);
                if (!this.sets.showTan) continue;
                y = this.beam.getRadiusAt(x, "y");
                xy2p_tan.add(x, y, false);
                continue;
            }
            if (this.sets.y2Axis.equals("gouy phase")) {
                y = this.beam.getGouyPhaseAt(x, "x");
                xy2p.add(x, y * 180.0 / Math.PI, false);
                if (!this.sets.showTan) continue;
                y = this.beam.getGouyPhaseAt(x, "y");
                xy2p_tan.add(x, y * 180.0 / Math.PI, false);
                continue;
            }
            if (this.sets.y2Axis.equals("empty")) {
                y = 0.0;
                continue;
            }
            y = 0.0;
            Logger.getLogger("JamMt").severe("Unknown plot quantity");
            System.exit(1);
        }
        this.dataset.addSeries(xyp);
        this.dataset.addSeries(xym);
        this.dataset.addSeries(xyp_tan);
        this.dataset.addSeries(xym_tan);
        this.y2dataset.addSeries(xy2p);
        this.y2dataset.addSeries(xy2m);
        this.y2dataset.addSeries(xy2p_tan);
        this.y2dataset.addSeries(xy2m_tan);
    }

    public Point2D getGraphCoordinates(double x, double y) {
        Rectangle2D dtArea = this.getScreenDataArea();
        ValueAxis xAxis = this.getPlot().getDomainAxis();
        ValueAxis yAxis = this.getPlot().getRangeAxis();
        RectangleEdge xEdge = this.getPlot().getDomainAxisEdge();
        RectangleEdge yEdge = this.getPlot().getRangeAxisEdge();
        double chartX = xAxis.valueToJava2D(x, dtArea, xEdge);
        double chartY = yAxis.valueToJava2D(y, dtArea, yEdge);
        return new Point2D.Double(chartX, chartY);
    }

    public Point2D getScreenCoordinates(double x, double y) {
        Rectangle2D dtArea = this.getScreenDataArea();
        ValueAxis xAxis = this.getPlot().getDomainAxis();
        ValueAxis yAxis = this.getPlot().getRangeAxis();
        RectangleEdge xEdge = this.getPlot().getDomainAxisEdge();
        RectangleEdge yEdge = this.getPlot().getRangeAxisEdge();
        double chartX = xAxis.java2DToValue(x, dtArea, xEdge);
        double chartY = yAxis.java2DToValue(y, dtArea, yEdge);
        return new Point2D.Double(chartX, chartY);
    }

    @Override
    public void beamUpdate(Beam b) {
        this.updateChart();
    }

    public void zoom(String axis, double factor) {
        ValueAxis xAxis = this.plot.getDomainAxis();
        ValueAxis yAxis = this.plot.getRangeAxis();
        double x1 = xAxis.getLowerBound();
        double x2 = xAxis.getUpperBound();
        double y1 = yAxis.getLowerBound();
        double y2 = yAxis.getUpperBound();
        double dx = (x2 - x1) * factor;
        double dy = (y2 - y1) * factor;
        this.sets.autoScale = false;
        if (axis.equals("y")) {
            this.sets.yMin = "" + (y1 - dy);
            this.sets.yMax = "" + (y2 + dy);
        }
        if (axis.equals("z")) {
            this.sets.xMin = "" + (x1 - dx);
            this.sets.xMax = "" + (x2 + dx);
        }
        MainWindow.getInstance().mainUpdate();
    }

    public void shift(String axis, double factor) {
        ValueAxis xAxis = this.plot.getDomainAxis();
        ValueAxis yAxis = this.plot.getRangeAxis();
        double x1 = xAxis.getLowerBound();
        double x2 = xAxis.getUpperBound();
        double y1 = yAxis.getLowerBound();
        double y2 = yAxis.getUpperBound();
        double dx = (x2 - x1) * factor;
        double dy = (y2 - y1) * factor;
        this.sets.autoScale = false;
        if (axis.equals("y")) {
            this.sets.yMin = "" + (y1 + dy);
            this.sets.yMax = "" + (y2 + dy);
        }
        if (axis.equals("z")) {
            this.sets.xMin = "" + (x1 + dx);
            this.sets.xMax = "" + (x2 + dx);
        }
        MainWindow.getInstance().mainUpdate();
    }
}

