/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.BeamAnalyzer;
import components.Component;
import components.Lens;
import components.TextLabel;
import gui.StatusBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.Beam;
import utils.ComponentDrawer;
import utils.JamMtException;
import utils.ModematchingSolution;
import utils.Settings;

public class ComponentSet {
    private ArrayList<Component> set = new ArrayList();
    protected int current = -1;
    protected Beam b = null;
    protected ComponentDrawer drawer = null;
    protected StatusBar bar;

    public void setComponentDrawer(ComponentDrawer d) {
        for (Component comp : this.set) {
            if (this.drawer != null) {
                comp.detach(this.drawer);
            }
            comp.attach(d);
        }
        this.drawer = d;
    }

    public void setBeam(Beam newbeam) {
        for (Component comp : this.set) {
            if (this.b != null) {
                comp.detach(this.b);
            }
            comp.attach(newbeam);
        }
        this.b = newbeam;
    }

    public void setStatusBar(StatusBar bar) {
        for (Component comp : this.set) {
            if (this.bar != null) {
                comp.detach(this.bar);
            }
            comp.attach(bar);
        }
        this.bar = bar;
    }

    public void addComponent(Component comp) {
        if (comp == null) {
            return;
        }
        if (this.drawer != null) {
            comp.attach(this.drawer);
        }
        if (this.b != null) {
            comp.attach(this.b);
        }
        this.set.add(comp);
        Collections.sort(this.set);
        if (this.drawer != null && this.b != null) {
            this.setCurrent(comp);
        }
    }

    public void removeAll() {
        this.set.clear();
    }

    public void removeAnalyzer(int idx) {
        int i = -1;
        for (Component comp : this.set) {
            if (comp instanceof BeamAnalyzer) {
                ++i;
            }
            if (idx != i) continue;
            this.removeComponent(comp);
            break;
        }
    }

    public void removeComponent(int idx) {
        this.removeComponent(this.set.get(idx));
    }

    public void removeComponent(Component comp) {
        if (comp == null) {
            return;
        }
        this.set.remove(comp);
        comp.detachAll();
        if (this.set.size() != 0) {
            this.setCurrent(this.set.get(0));
        }
    }

    public void setCurrent(Component comp) {
        if (comp == null) {
            return;
        }
        for (Component c : this.set) {
            c.setCurrent(false);
        }
        if (comp != null) {
            comp.setCurrent(true);
            this.current = this.set.indexOf(comp);
        }
    }

    private ComponentSet sortByFocalLength() {
        ComponentSet set = new ComponentSet();
        try {
            for (Lens c : this.getLenses()) {
                c.setPosition(c.getFocalLength("x"));
                set.addComponent(c);
            }
            Collections.sort(set.getLenses());
            for (Lens c : this.getLenses()) {
                c.setFocalLength("x", c.getPosition());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    public boolean isComparableTo(ComponentSet set) {
        ComponentSet orderedSet1 = set.sortByFocalLength();
        ComponentSet orderedSet2 = this.sortByFocalLength();
        try {
            for (int i = 0; i < set.getLenses().size(); ++i) {
                if (orderedSet1.getLenses().get(i).getFocalLength("x") == orderedSet2.getLenses().get(i).getFocalLength("x")) continue;
                return false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public boolean contains(Component l) {
        if (l == null) {
            return false;
        }
        for (Component ll : this.set) {
            if (l != ll) continue;
            return true;
        }
        return false;
    }

    public Component getCurrent() {
        for (Component comp : this.set) {
            if (!comp.isCurrent()) continue;
            return comp;
        }
        return null;
    }

    public void setComponents(ArrayList<Component> set) {
        this.set = new ArrayList();
        for (Component comp : set) {
            this.addComponent(comp);
        }
    }

    public ArrayList<Component> getComponents() {
        return this.set;
    }

    public ArrayList<Lens> getLenses() {
        ArrayList<Lens> ret = new ArrayList<Lens>();
        for (Component comp : this.set) {
            if (!(comp instanceof Lens)) continue;
            ret.add((Lens)comp);
        }
        return ret;
    }

    public void setLenses(ArrayList<Lens> newlenses) {
        this.set = new ArrayList();
        for (Lens l : newlenses) {
            this.addComponent(l);
        }
    }

    public ArrayList<TextLabel> getTextLabel() {
        ArrayList<TextLabel> ret = new ArrayList<TextLabel>();
        for (Component comp : this.set) {
            if (!(comp instanceof TextLabel)) continue;
            ret.add((TextLabel)comp);
        }
        return ret;
    }

    public ArrayList<BeamAnalyzer> getBeamAnalyzer() {
        ArrayList<BeamAnalyzer> ret = new ArrayList<BeamAnalyzer>();
        for (Component comp : this.set) {
            if (!(comp instanceof BeamAnalyzer)) continue;
            ret.add((BeamAnalyzer)comp);
        }
        return ret;
    }

    public void getNext() {
        if (this.current < 0) {
            return;
        }
        this.current = this.current == this.set.size() - 1 ? 0 : ++this.current;
        this.setCurrent(this.set.get(this.current));
        if (this.drawer != null) {
            this.drawer.repaint();
        }
    }

    public void getPrevious() {
        if (this.current < 0) {
            return;
        }
        this.current = this.current == 0 ? this.set.size() - 1 : --this.current;
        this.setCurrent(this.set.get(this.current));
        if (this.drawer != null) {
            this.drawer.repaint();
        }
    }

    public void updateGroup(int id, double dx) {
        if (id == 0) {
            return;
        }
        for (Component l : this.set) {
            if (l.isCurrent() || l.getGroupID() != id) continue;
            double curPos = l.getPosition();
            l.setPosition(curPos + dx);
            Collections.sort(this.set);
        }
    }

    public double getSpaceBetween(Component l1, Component l2) {
        double p2;
        if (l1 == null || l2 == null) {
            return 0.0;
        }
        double p1 = l1.getPosition();
        p1 = p1 < (p2 = l2.getPosition()) ? (p1 += l1.getThickness() / 2.0) : (p1 -= l1.getThickness() / 2.0);
        p2 = p1 < p2 ? (p2 -= l2.getThickness() / 2.0) : (p2 += l2.getThickness() / 2.0);
        return Math.abs(p2 - p1);
    }

    public Lens getLastLens() {
        int idx = -1;
        for (Component comp : this.set) {
            if (!(comp instanceof Lens)) continue;
            idx = this.set.indexOf(comp);
        }
        return (Lens)this.set.get(idx);
    }

    public Lens getFirstLens() {
        for (Component comp : this.set) {
            if (!(comp instanceof Lens)) continue;
            return (Lens)comp;
        }
        return null;
    }

    public ABCDmatrix getABCDmatrixAt(double z, String plane) {
        ABCDmatrix M = new ABCDmatrix();
        try {
            Lens l = new Lens(0.0, 0.1, 0.025);
            Lens ll = new Lens(0.0, 0.1, 0.025);
            ArrayList<Lens> lenses = this.getLenses();
            if (lenses.size() == 0) {
                return M;
            }
            if (z < this.getFirstLens().getPosition()) {
                return M;
            }
            M.timesLeft(this.getFirstLens().getABCD(plane));
            for (int i = 1; i < lenses.size(); ++i) {
                l = lenses.get(i - 1);
                ll = lenses.get(i);
                if (z < ll.getPosition()) {
                    return M;
                }
                M.timesLeft(new ABCDmatrix(1.0, this.getSpaceBetween(l, ll), 0.0, 1.0));
                M.timesLeft(ll.getABCD(plane));
            }
            M.timesLeft(new ABCDmatrix(1.0, z - ll.getPosition(), 0.0, 1.0));
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return M;
    }

    public boolean vetoLensSet(double z0_tmp, Settings sets, Vector<ModematchingSolution> solution) {
        boolean veto = false;
        boolean found_case = false;
        double d = 0.0;
        if (sets.right_focus && z0_tmp < this.getLastLens().getPosition()) {
            return true;
        }
        for (int i = 0; i < this.set.size(); ++i) {
            for (int j = 0; j < this.set.size(); ++j) {
                Lens l = (Lens)this.set.get(i);
                Lens ll = (Lens)this.set.get(j);
                if (i == j) continue;
                if (sets.lens_overlap && (d = Math.abs(l.getPosition() - ll.getPosition())) <= (l.getThickness() + ll.getThickness()) / 2.0) {
                    return true;
                }
                if (!sets.single_lens_use) continue;
                try {
                    if (l.getFocalLength("x") != ll.getFocalLength("x")) continue;
                    return true;
                }
                catch (JamMtException je) {
                    Logger.getLogger("JamMt").severe(je.toString());
                }
            }
        }
        if (sets.nearby_solution) {
            if (solution.size() == 0) {
                return false;
            }
            for (ModematchingSolution sol : solution) {
                if (!this.comparableTo(sol.components, sets.dx_min)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean comparableTo(Object obj) {
        if (obj instanceof ComponentSet) {
            ComponentSet cset = (ComponentSet)obj;
            if (cset.getLenses().size() != this.set.size()) {
                return false;
            }
            for (int i = 0; i < this.set.size(); ++i) {
                if (cset.getLenses().get(i).comparableTo(this.set.get(i))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    private boolean comparableTo(ComponentSet cset, double dx) {
        if (this.set.size() != cset.getLenses().size()) {
            return false;
        }
        Collections.sort(this.set);
        Collections.sort(cset.getLenses());
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                double f1 = ((Lens)this.set.get(i)).getFocalLength("x");
                double f2 = cset.getLenses().get(i).getFocalLength("x");
                if (f1 != f2) {
                    return false;
                }
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            double dist = Math.abs(this.set.get(i).getPosition() - cset.getLenses().get(i).getPosition());
            if (!(dist > dx)) continue;
            return false;
        }
        return true;
    }

    public void ungroup(int id, boolean all) {
        try {
            for (Component comp : this.getComponents()) {
                if (all) {
                    comp.setGroupID(0);
                    continue;
                }
                if (id != comp.getGroupID()) continue;
                comp.setGroupID(0);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }
}

