/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.BeamAnalyzer;
import components.Component;
import components.Lens;
import components.Substrate;
import components.TextLabel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import utils.Beam;
import utils.ColorTheme;
import utils.ComponentSet;
import utils.DrawingArea;
import utils.JamMtException;
import utils.MouseEventHandler;
import utils.Observer;
import utils.Settings;

public class ComponentDrawer
extends JComponent
implements Observer {
    private Settings sets;
    private Beam beam;
    private DrawingArea da;
    private ComponentSet components;
    private Color infobox_bg;
    private Color infobox_fg;
    private MouseEventHandler meh;
    private Rectangle2D area;
    private ColorTheme theme;
    private HashMap<String, ImageIcon> images = new HashMap();
    private HashMap<String, Double> yCoordinates = new HashMap();
    private HashMap<String, Double> heights = new HashMap();

    public ComponentDrawer(DrawingArea da, Settings sets) {
        this.da = da;
        this.sets = sets;
        this.area = da.getScreenDataArea();
        this.beam = sets.beam;
        this.components = sets.components;
        this.components.setComponentDrawer(this);
        this.meh = new MouseEventHandler(this.components);
        this.addMouseListener(this.meh);
        this.addMouseMotionListener(this.meh);
        this.addMouseWheelListener(this.meh);
        try {
            this.theme = new ColorTheme(sets.colortheme);
        }
        catch (JamMtException e) {
            sets.colortheme = "default";
            try {
                this.theme = new ColorTheme(sets.colortheme);
            }
            catch (JamMtException ex) {
                Logger.getLogger("JamMt").severe("Failed to set the default colortheme");
            }
        }
        this.theme.apply(this);
    }

    public void setImages(HashMap<String, ImageIcon> img, HashMap<String, Double> coord, HashMap<String, Double> height) {
        this.images = img;
        this.yCoordinates = coord;
        this.heights = height;
    }

    public void setColors(Color info_bg, Color info_fg) {
        this.infobox_bg = info_bg;
        this.infobox_fg = info_fg;
    }

    private String getFlavor(Lens l) {
        String flavor = "";
        if (l instanceof Substrate) {
            Substrate s = (Substrate)l;
            flavor = Math.abs(s.getLeftRoc("x")) >= Double.POSITIVE_INFINITY ? flavor + "plan-" : (s.getLeftRoc("x") < 0.0 ? flavor + "convex-" : flavor + "concave-");
            flavor = Math.abs(s.getRightRoc("x")) >= Double.POSITIVE_INFINITY ? flavor + "plan" : (s.getRightRoc("x") > 0.0 ? flavor + "convex" : flavor + "concave");
        } else {
            try {
                flavor = l.getFocalLength("x") > 0.0 ? "convex-convex" : "concave-concave";
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
        return flavor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int i = 0;
        this.area = this.da.getScreenDataArea();
        Graphics2D g2d = (Graphics2D)g;
        for (Component comp : this.components.getComponents()) {
            double pos = comp.getPosition();
            String curComponent = "";
            if (comp instanceof Substrate) {
                curComponent = "substrate";
            } else if (comp instanceof Lens) {
                curComponent = "lens";
            } else if (comp instanceof BeamAnalyzer) {
                curComponent = "beam-analyzer";
            } else if (comp instanceof TextLabel) {
                curComponent = "text-label";
            }
            String flavor = "";
            boolean flip = false;
            if (comp instanceof Lens) {
                flavor = flavor + "_" + this.getFlavor((Lens)comp);
            }
            double angle = 0.0;
            if (comp instanceof Substrate) {
                angle = ((Substrate)comp).getAngleInRadians();
            }
            if (flavor.equals("_convex-plan")) {
                flavor = "_plan-convex";
                flip = true;
            } else if (flavor.equals("_concave-plan")) {
                flavor = "_plan-concave";
                flip = true;
            } else if (flavor.equals("_concave-convex")) {
                flavor = "_convex-concave";
                flip = true;
            }
            String name = "";
            name = this.sets.rotate ? name + "_rotate" : name + "_default";
            name = comp.isCurrent() ? name + "_active" : name + "_inactive";
            double y = this.yCoordinates.get(curComponent);
            double h = this.heights.get(curComponent);
            ImageIcon curImage = this.images.get(curComponent + flavor + name);
            if (curImage == null) {
                curImage = this.images.get(curComponent + flavor + "_default_active");
            }
            if (curImage == null) {
                Logger.getLogger("JamMt").severe("Default image not found in theme '" + this.sets.colortheme + "'!\n  Please add the file '" + curComponent + flavor + "_default_active.png'");
            }
            this.drawImage(g2d, curImage, pos, y, h, false, flip, angle);
            curComponent = "handle";
            y = this.yCoordinates.get(curComponent);
            h = this.heights.get(curComponent);
            curImage = this.images.get(curComponent + name);
            if (curImage == null) {
                curImage = this.images.get(curComponent + "_default_active");
            }
            if (curImage == null) {
                Logger.getLogger("JamMt").severe("Default image not found in theme '" + this.sets.colortheme + "'!\n  Please add the file '" + curComponent + "_default_active.png'");
            }
            this.drawImage(g2d, curImage, pos, y, h, true, false, 0.0);
            if (this.beam.isClippedBy(comp)) {
                curComponent = "clipping";
                y = this.yCoordinates.get(curComponent);
                h = this.heights.get(curComponent);
                curImage = this.images.get(curComponent + name);
                if (curImage == null) {
                    curImage = this.images.get(curComponent + "_default_active");
                }
                this.drawImage(g2d, curImage, pos, y, h, false, false, 0.0);
            }
            y = this.yCoordinates.get("verbose-info-box");
            if (this.sets.info) {
                this.drawVerboseInfo(g2d, comp, pos, y, i++);
            }
            y = this.yCoordinates.get("info-box");
            this.drawInfo(g2d, comp, pos, y);
        }
    }

    private void drawImage(Graphics2D g, ImageIcon img, double x, double y, double h, boolean isHotSpot, boolean flip, double angle) {
        x = this.da.getGraphCoordinates(x, 0.0).getX();
        double screen_height = this.area.getY() + this.area.getHeight();
        y = this.area.getY() + screen_height / 2.0 - y * screen_height;
        double w = (h *= screen_height) * (double)img.getIconWidth() / (double)img.getIconHeight();
        int i = 1;
        if (flip) {
            i = -1;
        }
        double xc = x;
        double yc = y;
        x -= (double)i * w / 2.0;
        w = (double)i * w;
        g.rotate(angle, xc, yc);
        g.drawImage(img.getImage(), (int)x, (int)(y -= h / 2.0), (int)w, (int)h, null);
        g.rotate(-angle, xc, yc);
        if (isHotSpot) {
            this.meh.setHotSpot(new Rectangle2D.Double(x - w / 2.0, y, w, h));
        }
    }

    private void drawInfo(Graphics2D g, Component comp, double x, double y) {
        x = this.da.getGraphCoordinates(x, 0.0).getX();
        double screen_height = this.area.getY() + this.area.getHeight();
        y = this.area.getY() + screen_height / 2.0 - y * screen_height;
        String info = "";
        if (comp.getGroupID() != 0) {
            info = info + "GID = " + comp.getGroupID();
        }
        if (comp instanceof Substrate) {
            Substrate s;
            if (info != "") {
                info = info + ", ";
            }
            if ((s = (Substrate)comp).getMirror() == 1) {
                info = info + " (";
            }
            if (s.getMirror() == 2) {
                info = info + " )";
            }
            if (s.getMirror() == 3) {
                info = info + " ()";
            }
        }
        if (comp instanceof TextLabel) {
            if (info != "") {
                info = info + "\n";
            }
            info = info + comp.getName();
        }
        if (info != "") {
            this.drawFramedText(g, info, (int)x, y, 't');
        }
    }

    private void drawVerboseInfo(Graphics2D g, Component comp, double x, double y, int n) {
        x = this.da.getGraphCoordinates(x, 0.0).getX();
        double screen_height = this.area.getY() + this.area.getHeight();
        y = this.area.getY() + screen_height / 2.0 - Math.pow(-1.0, n) * y * screen_height;
        char alignment = 'b';
        if (n % 2 == 0) {
            alignment = 't';
        }
        this.drawFramedText(g, comp.getInfo(), (int)x, y, alignment);
    }

    private void drawFramedText(Graphics2D g, String str, double x, double y, char alignment) {
        String[] s = str.split("\n");
        double y_orig = y;
        double max_h = 0.0;
        double max_w = 0.0;
        Paint c = g.getPaint();
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout("No string.", g.getFont(), frc);
        Rectangle2D rect = layout.getBounds();
        for (String a : s) {
            layout = new TextLayout(a, g.getFont(), frc);
            rect = layout.getBounds();
            if (max_h < rect.getHeight()) {
                max_h = rect.getHeight();
            }
            if (!(max_w < rect.getWidth())) continue;
            max_w = rect.getWidth();
        }
        double margin = 0.5 * max_h;
        double linedist = 0.5 * max_h;
        if (alignment == 'b') {
            y_orig -= max_h * (double)s.length + 2.0 * margin + linedist * (double)(s.length - 1);
        }
        rect.setRect(x -= max_w / 2.0, y_orig, max_w + 2.0 * margin, max_h * (double)s.length + 2.0 * margin + linedist * (double)(s.length - 1));
        g.setPaint(this.infobox_bg);
        g.fill(rect);
        g.setPaint(this.infobox_fg);
        x += margin;
        y_orig += margin;
        int cnt = 0;
        for (String a : s) {
            layout = new TextLayout(a, g.getFont(), frc);
            layout.draw(g, (float)x, (float)(y_orig += max_h));
            if (cnt != s.length - 1) {
                y_orig += linedist;
            }
            ++cnt;
        }
        g.setPaint(c);
    }

    @Override
    public void update(Component comp) {
        Point2D xy = this.da.getGraphCoordinates(comp.getPosition(), 0.0);
        int y2 = (int)this.area.getY();
        int y1 = (int)((double)y2 + this.area.getHeight());
        if (comp instanceof Lens) {
            this.repaint((int)xy.getX() - 50, (int)xy.getY() - 100, 100, 200);
        } else {
            this.repaint((int)xy.getX() - 100, y2 - 20, 200, y1 - y2 + 40);
        }
    }
}

