/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import utils.ComponentDrawer;
import utils.DrawingArea;
import utils.JamMtException;
import utils.Settings;

public class ColorTheme {
    private Color ChartFgCol = new Color(255, 0, 0);
    private Color ChartFg2Col = new Color(0, 200, 0);
    private Color ChartBgCol = new Color(230, 230, 230);
    private Color GridCol = new Color(30, 30, 30);
    private Color InfoboxBgCol = new Color(250, 250, 250);
    private Color InfoboxFgCol = new Color(40, 40, 40);
    private HashMap<String, ImageIcon> images = new HashMap();
    private HashMap<String, Double> yCoordinates = new HashMap();
    private HashMap<String, Double> heights = new HashMap();

    public ColorTheme(String name) throws JamMtException {
        this(name, Settings.THEME_FOLDER.getAbsolutePath());
    }

    public ColorTheme(String name, String path) throws JamMtException {
        URL defaultTheme = null;
        URL theme = null;
        this.yCoordinates.put("handle", -0.4);
        this.heights.put("handle", 0.1);
        this.yCoordinates.put("lens", 0.0);
        this.heights.put("lens", 0.4);
        this.yCoordinates.put("substrate", 0.0);
        this.heights.put("substrate", 0.4);
        this.yCoordinates.put("beam-analyzer", 0.0);
        this.heights.put("beam-analyzer", 0.8);
        this.yCoordinates.put("clipping", 0.0);
        this.heights.put("clipping", 0.2);
        this.yCoordinates.put("text-label", 0.0);
        this.heights.put("text-label", 0.8);
        this.yCoordinates.put("info-box", 0.5);
        this.yCoordinates.put("verbose-info-box", 0.4);
        try {
            Class<?> clazz = this.getClass();
            defaultTheme = clazz.getResource("/defaultTheme/default.theme");
            theme = name == "default" ? defaultTheme : new URL("file://" + path + Settings.FS + name + Settings.FS + name + ".theme");
        }
        catch (MalformedURLException e) {
            Logger.getLogger("JamMt").warning(e.toString());
        }
        try {
            this.parseColorTheme(theme);
        }
        catch (IOException e) {
            throw new JamMtException("Unable to load theme: " + theme);
        }
        this.loadImages(name, path);
    }

    private void parseColorTheme(URL theme) throws IOException {
        String line;
        BufferedReader f = new BufferedReader(new InputStreamReader(theme.openStream()));
        while ((line = f.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            if (line.contains(":")) {
                this.parseColor(line);
                continue;
            }
            if (!line.contains("=")) continue;
            this.parseValue(line);
        }
        f.close();
    }

    private void parseValue(String line) {
        StringTokenizer st = new StringTokenizer(line, "=");
        String name = "";
        double value = 0.0;
        name = st.nextToken().trim();
        value = Double.parseDouble(st.nextToken().trim());
        if (name.equals("handle_y")) {
            this.yCoordinates.put("handle", value);
        } else if (name.equals("lens_y")) {
            this.yCoordinates.put("lens", value);
        } else if (name.equals("substrate_y")) {
            this.yCoordinates.put("substrate", value);
        } else if (name.equals("beam-analyzer_y")) {
            this.yCoordinates.put("beam-analyzer", value);
        } else if (name.equals("clipping_y")) {
            this.yCoordinates.put("clipping", value);
        } else if (name.equals("text-label_y")) {
            this.yCoordinates.put("text-label", value);
        } else if (name.equals("info-box_y")) {
            this.yCoordinates.put("info-box", value);
        } else if (name.equals("handle_h")) {
            this.heights.put("handle", value);
        } else if (name.equals("lens_h")) {
            this.heights.put("lens", value);
        } else if (name.equals("substrate_h")) {
            this.heights.put("substrate", value);
        } else if (name.equals("beam-analyzer_h")) {
            this.heights.put("beam-analyzer", value);
        } else if (name.equals("clipping_h")) {
            this.heights.put("clipping", value);
        } else if (name.equals("text-label_h")) {
            this.heights.put("text-label", value);
        } else if (name.equals("info-box_h")) {
            this.heights.put("info-box", value);
        } else {
            Logger.getLogger("JamMt").warning("Unknown variable '" + name + "'");
        }
    }

    private void parseColor(String line) {
        StringTokenizer st = new StringTokenizer(line, ":");
        String name = "";
        int b = 0;
        int g = 0;
        int r = 0;
        int a = 255;
        try {
            name = st.nextToken().trim();
            st = new StringTokenizer(st.nextToken(), ",");
            r = Integer.parseInt(st.nextToken().trim());
            g = Integer.parseInt(st.nextToken().trim());
            b = Integer.parseInt(st.nextToken().trim());
            a = Integer.parseInt(st.nextToken().trim());
        }
        catch (NoSuchElementException e) {
            Logger.getLogger("JamMt").warning("Error while loading colortheme. Unable to parse line '" + line + "'");
        }
        if (name.equals("ChartFgCol")) {
            this.ChartFgCol = new Color(r, g, b, a);
        } else if (name.equals("ChartFg2Col")) {
            this.ChartFg2Col = new Color(r, g, b, a);
        } else if (name.equals("ChartBgCol")) {
            this.ChartBgCol = new Color(r, g, b, a);
        } else if (name.equals("GridCol")) {
            this.GridCol = new Color(r, g, b, a);
        } else if (name.equals("InfoboxFgCol")) {
            this.InfoboxFgCol = new Color(r, g, b, a);
        } else if (name.equals("InfoboxBgCol")) {
            this.InfoboxBgCol = new Color(r, g, b, a);
        } else {
            Logger.getLogger("JamMt").warning("Unknown variable '" + name + "'");
        }
    }

    public void apply(DrawingArea da) {
        da.setColors(this.ChartFgCol, this.ChartFg2Col, this.ChartBgCol, this.GridCol);
    }

    private void addImage(String theme, String name, String path) {
        URL img = null;
        if (theme == "default") {
            img = this.getClass().getResource("/defaultTheme/" + name + ".png");
            if (img != null) {
                this.images.put(name, new ImageIcon(img));
            }
        } else {
            try {
                img = new URL("file://" + path + Settings.FS + theme + Settings.FS + name + ".png");
                if (new File(img.getFile()).exists()) {
                    this.images.put(name, new ImageIcon(img));
                }
            }
            catch (IOException e) {
                Logger.getLogger("JamMt").warning(e.toString());
            }
        }
    }

    private void loadImages(String theme, String path) {
        Vector<String> components = new Vector<String>();
        Vector<String> modes = new Vector<String>();
        Vector<String> states = new Vector<String>();
        Vector<String> flavors = new Vector<String>();
        components.add("handle");
        components.add("lens");
        components.add("substrate");
        components.add("beam-analyzer");
        components.add("text-label");
        components.add("clipping");
        modes.add("default");
        modes.add("rotate");
        states.add("active");
        states.add("inactive");
        flavors.add("convex-convex");
        flavors.add("concave-concave");
        flavors.add("plan-plan");
        flavors.add("plan-convex");
        flavors.add("plan-concave");
        flavors.add("convex-concave");
        for (String component : components) {
            for (String mode : modes) {
                for (String state : states) {
                    String name = "";
                    if (component == "lens") {
                        for (int i = 0; i < 2; ++i) {
                            name = component + "_" + (String)flavors.get(i) + "_" + mode + "_" + state;
                            this.addImage(theme, name, path);
                        }
                        continue;
                    }
                    if (component == "substrate") {
                        for (String flavor : flavors) {
                            name = component + "_" + flavor + "_" + mode + "_" + state;
                            this.addImage(theme, name, path);
                        }
                        continue;
                    }
                    name = component + "_" + mode + "_" + state;
                    this.addImage(theme, name, path);
                }
            }
        }
    }

    public void apply(ComponentDrawer cd) {
        cd.setImages(this.images, this.yCoordinates, this.heights);
        cd.setColors(this.InfoboxBgCol, this.InfoboxFgCol);
    }
}

