/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Cavity;
import components.Lens;
import components.PartialBeam;
import components.Substrate;
import java.util.Vector;
import java.util.logging.Logger;
import utils.Beam;
import utils.ComponentSet;
import utils.Formatter;
import utils.JamMtException;
import utils.Settings;

public class CavitySet {
    private Vector<Cavity> cavities = new Vector();
    private Settings sets;
    private Beam beam;
    private ComponentSet LSdisp = new ComponentSet();

    public CavitySet() {
    }

    public CavitySet(Settings sets) {
        this.sets = sets;
        this.beam = sets.beam;
        this.LSdisp = sets.components;
    }

    public void setBeam(Beam beam) {
        this.beam = beam;
    }

    public Beam getBeam() {
        return this.beam;
    }

    public Vector<Cavity> getCavities() {
        return this.cavities;
    }

    public void removeCavity(Cavity cav) {
        if (cav == null) {
            return;
        }
        this.groupSubstrates(cav, false);
        try {
            cav.getEndMirror("left").setMirror(0);
            cav.getEndMirror("right").setMirror(0);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        this.beam.updateBeam();
        this.cavities.remove(cav);
    }

    public Cavity getCavity(Lens l) {
        Substrate m1 = null;
        Substrate m2 = null;
        for (Cavity cav : this.cavities) {
            try {
                m1 = cav.getEndMirror("left");
                m2 = cav.getEndMirror("right");
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            if (!this.LSdisp.contains(m1) || !this.LSdisp.contains(m2) || !m1.equals(l) && !m2.equals(l)) continue;
            return cav;
        }
        return null;
    }

    private int getCID(Cavity cav) {
        int cid = 10;
        int idx = this.cavities.indexOf(cav);
        if (idx >= 0) {
            return cid + idx;
        }
        return 0;
    }

    public void groupSubstrates(Cavity cav, boolean group) {
        int cid = this.getCID(cav);
        try {
            for (Lens l : cav.getComponents().getLenses()) {
                if (cav.isGrouped()) {
                    l.setGroupID(cid);
                    continue;
                }
                l.setGroupID(0);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    public void toggleGroup(Cavity cav) {
        int cid = this.getCID(cav);
        try {
            for (Lens l : cav.getComponents().getLenses()) {
                if (cav.isGrouped()) {
                    l.setGroupID(0);
                    continue;
                }
                l.setGroupID(cid);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        cav.setGrouped(!cav.isGrouped());
    }

    public PartialBeam getEigenMode(Cavity cav) {
        ComponentSet comp = new ComponentSet();
        for (Lens l : this.LSdisp.getLenses()) {
            if (!cav.contains(l)) continue;
            comp.addComponent(l);
        }
        try {
            cav.setComponents(comp);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return cav.getEigenmode(this.beam.getWaveLength());
    }

    public String getInfo(Cavity cav) {
        PartialBeam em;
        PartialBeam im = em = cav.getEigenmode(this.beam.getWaveLength());
        try {
            double iface_pos = cav.getEndMirror("left").getPosition() - cav.getEndMirror("left").getThickness() / 2.0;
            im = this.beam.getBeamAt(iface_pos);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        String info = "";
        try {
            if (cav.isStable()) {
                double vis_x = em.calculateOverlap(im, "x");
                double vis_y = em.calculateOverlap(im, "y");
                info = info + "w0_x = " + Formatter.defaultFormat(em.getWaistSize("x") * 1000000.0) + " \u03bcm\n";
                info = info + "z0_x = " + Formatter.defaultFormat(em.getWaistPosition("x") * 100.0) + " cm\n";
                info = info + "V_x = " + Formatter.defaultFormat(vis_x * 100.0) + " %\n";
                info = info + "g_x = " + Formatter.defaultFormat(cav.getStabilityParameter("x")) + "\n\n";
                if (this.sets.showTan) {
                    info = info + "w0_y = " + Formatter.defaultFormat(em.getWaistSize("y") * 1000000.0) + " \u03bcm\n";
                    info = info + "z0_y = " + Formatter.defaultFormat(em.getWaistPosition("y") * 100.0) + " cm\n";
                    info = info + "V_y = " + Formatter.defaultFormat(vis_y * 100.0) + " %\n";
                    info = info + "g_y = " + Formatter.defaultFormat(cav.getStabilityParameter("y")) + "\n";
                }
            } else {
                info = info + "Cavity is unstable!\n";
                info = info + "  g_x = " + Formatter.defaultFormat(cav.getStabilityParameter("x")) + "\n";
                info = info + "  g_y = " + Formatter.defaultFormat(cav.getStabilityParameter("y")) + "\n";
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return info;
    }
}

