/*
 * Decompiled with CFR 0.152.
 */
package utils;

import components.Cavity;
import components.Component;
import components.Lens;
import components.PartialBeam;
import components.Substrate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.BeamObserver;
import utils.CavitySet;
import utils.ComponentSet;
import utils.JamMtException;
import utils.Observer;
import utils.QParameter;

public class Beam
implements Observer {
    private List<PartialBeam> pbeam = new ArrayList<PartialBeam>();
    private double lambda = 0.0;
    private ComponentSet components = new ComponentSet();
    private CavitySet cavities;
    List<BeamObserver> bobs = new ArrayList<BeamObserver>();

    public Beam(PartialBeam b, ComponentSet components, CavitySet cavities) throws JamMtException {
        this.cavities = cavities;
        this.setWaveLength(b.getWaveLength());
        this.components = components;
        this.components.setBeam(this);
        this.pbeam.add(0, b);
        this.updateBeam();
    }

    public void setLenses(ComponentSet set) {
        for (Lens l : this.components.getLenses()) {
            l.detach(this);
        }
        this.components = set;
        for (Lens l : this.components.getLenses()) {
            l.attach(this);
        }
        this.updateBeam();
    }

    public int getNumberOfBeams() {
        return this.pbeam.size();
    }

    public List<PartialBeam> getPartialBeams() {
        return this.pbeam;
    }

    public PartialBeam getInitialBeam() {
        if (this.pbeam.size() == 0) {
            return null;
        }
        return this.pbeam.get(0);
    }

    public void setInitialBeam(PartialBeam b) throws JamMtException {
        this.pbeam.removeAll(this.pbeam);
        this.pbeam.add(b);
        this.setWaveLength(b.getWaveLength());
        this.updateBeam();
    }

    public void setInitialBeam(double w0x, double z0x, double w0y, double z0y, double lambda) throws JamMtException {
        this.setWaveLength(lambda);
        this.pbeam.removeAll(this.pbeam);
        this.pbeam.add(new PartialBeam(w0x, z0x, w0y, z0y, lambda));
        this.updateBeam();
    }

    public PartialBeam getLast() {
        return this.pbeam.get(this.pbeam.size() - 1);
    }

    public double getWaveLength() {
        return this.lambda;
    }

    public void setWaveLength(double l) throws JamMtException {
        if (l <= 0.0) {
            throw new JamMtException("The wavelength has to be greater than zero (was " + l + ").");
        }
        this.lambda = l;
    }

    public PartialBeam getBeamAt(double z) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i);
    }

    public double getW0At(double z, String plane) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getWaistSize(plane);
    }

    public double getZ0At(double z, String plane) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getWaistPosition(plane);
    }

    public double getWaistSizeAt(double z, String plane) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getSizeAt(z, plane);
    }

    public double getRadiusAt(double z, String plane) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getRadiusAt(z, plane);
    }

    public double getGouyPhaseAt(double z, String plane) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getGouyPhaseAt(z, plane);
    }

    public QParameter getQParameterAt(double z) {
        int i = this.getBeamIndex(z);
        return this.pbeam.get(i).getQParameterAt(z);
    }

    private int getBeamIndex(double z) {
        int i = 0;
        for (Lens l : this.components.getLenses()) {
            double pos = l.getPosition();
            if (l instanceof Substrate) {
                if (z <= pos - l.getThickness() / 2.0) break;
                ++i;
                if (z <= pos + l.getThickness() / 2.0) {
                    break;
                }
            } else if (z <= pos) break;
            ++i;
        }
        return i;
    }

    public void attach(BeamObserver o) {
        this.bobs.add(o);
    }

    public void detach(BeamObserver o) {
        this.bobs.remove(o);
    }

    public void detachAll() {
        this.bobs.clear();
    }

    public void fireUpdate() {
        Iterator<BeamObserver> it = this.bobs.iterator();
        while (it.hasNext()) {
            it.next().beamUpdate(this);
        }
    }

    public void updateBeam() {
        PartialBeam b = this.getInitialBeam();
        ABCDmatrix Mx = new ABCDmatrix();
        ABCDmatrix My = new ABCDmatrix();
        double lambda = b.getWaveLength();
        this.pbeam.removeAll(this.pbeam);
        this.pbeam.add(b);
        try {
            for (Lens l : this.components.getLenses()) {
                QParameter q;
                double pos;
                Object em = null;
                if (l instanceof Substrate) {
                    PartialBeam mode;
                    Cavity cav;
                    Substrate s = (Substrate)l;
                    double n = s.getIndexOfRefraction();
                    pos = s.getPosition() - s.getThickness() / 2.0;
                    if ((s.getMirror() == 1 || s.getMirror() == 3) && (cav = this.cavities.getCavity(s)) != null && (mode = this.cavities.getEigenMode(cav)) != null) {
                        b = mode;
                    }
                    q = new QParameter(pos, pos - b.getWaistPosition("x"), Math.PI * Math.pow(b.getWaistSize("x"), 2.0) / lambda, pos - b.getWaistPosition("y"), Math.PI * Math.pow(b.getWaistSize("y"), 2.0) / lambda);
                    Mx = s.getABCD("left", "x");
                    My = s.getABCD("left", "y");
                    q.propagate(Mx, My, pos);
                    b = q.toBeam(n, lambda);
                    this.pbeam.add(b);
                    Mx = s.getABCD("prop", "x");
                    My = s.getABCD("prop", "y");
                    q.propagate(Mx, My, pos += s.getThickness());
                    Mx = s.getABCD("right", "x");
                    My = s.getABCD("right", "y");
                    q.propagate(Mx, My, pos);
                    b = q.toBeam(1.0, lambda);
                    this.pbeam.add(b);
                    continue;
                }
                pos = l.getPosition();
                q = new QParameter(pos, pos - b.getWaistPosition("x"), Math.PI * Math.pow(b.getWaistSize("x"), 2.0) / lambda, pos - b.getWaistPosition("y"), Math.PI * Math.pow(b.getWaistSize("y"), 2.0) / lambda);
                Mx = l.getABCD("x");
                My = l.getABCD("y");
                q.propagate(Mx, My, pos);
                b = q.toBeam(1.0, lambda);
                this.pbeam.add(b);
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        this.fireUpdate();
    }

    @Override
    public void update(Component comp) {
        if (comp instanceof Lens) {
            this.updateBeam();
        }
    }

    public boolean isClippedBy(Component c) {
        if (!(c instanceof Lens)) {
            return false;
        }
        Lens l = (Lens)c;
        double ap = l instanceof Substrate ? l.getAperture() / 3.0 * Math.cos(((Substrate)l).getAngleInRadians()) : l.getAperture() / 3.0;
        return this.getWaistSizeAt(l.getPosition(), "x") > ap;
    }
}

