/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.logging.Logger;
import utils.JamMtException;

public class ABCDmatrix {
    private double A = 1.0;
    private double B = 0.0;
    private double C = 0.0;
    private double D = 1.0;

    public ABCDmatrix() {
    }

    public ABCDmatrix(double A, double B, double C, double D) throws JamMtException {
        this.A = A;
        this.B = B;
        this.C = C;
        this.D = D;
        this.checkMatrix();
    }

    public void setElement(String e, double value) throws JamMtException {
        if (e.equals("A")) {
            this.A = value;
        } else if (e.equals("B")) {
            this.B = value;
        } else if (e.equals("C")) {
            this.C = value;
        } else if (e.equals("D")) {
            this.D = value;
        } else {
            throw new JamMtException("ABCD matrix has no element named '" + e + "'!");
        }
        this.checkMatrix();
    }

    public double getElement(String e) throws JamMtException {
        if (!(e.equals("A") || e.equals("B") || e.equals("C") || e.equals("D"))) {
            throw new JamMtException("ABCD matrix has no element named '" + e + "'!");
        }
        if (e.equals("A")) {
            return this.A;
        }
        if (e.equals("B")) {
            return this.B;
        }
        if (e.equals("C")) {
            return this.C;
        }
        return this.D;
    }

    public void timesLeft(ABCDmatrix M) {
        try {
            ABCDmatrix tmp = new ABCDmatrix(this.A, this.B, this.C, this.D);
            this.A = M.getElement("A") * tmp.getElement("A") + M.getElement("B") * tmp.getElement("C");
            this.B = M.getElement("A") * tmp.getElement("B") + M.getElement("B") * tmp.getElement("D");
            this.C = M.getElement("C") * tmp.getElement("A") + M.getElement("D") * tmp.getElement("C");
            this.D = M.getElement("C") * tmp.getElement("B") + M.getElement("D") * tmp.getElement("D");
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
    }

    public ABCDmatrix invert() {
        try {
            ABCDmatrix inv = new ABCDmatrix(this.D, -this.B, -this.C, this.A);
            return inv;
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
            return this;
        }
    }

    public double trace() {
        return this.A + this.D;
    }

    public double determinant() {
        return this.A * this.D - this.B * this.C;
    }

    private void checkMatrix() throws JamMtException {
        if (Math.abs(this.determinant() - 1.0) > 1.0E-6) {
            throw new JamMtException("ABCD matrix is invalid, because det(M) = " + this.determinant() + " != 1.0");
        }
    }

    public String toString() {
        return this.A + "   " + this.B + "\n" + this.C + "   " + this.D;
    }
}

