/*
 * Decompiled with CFR 0.152.
 */
package tests;

import io.XmlDoc;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import utils.JamMtException;
import utils.Settings;

public class Xml_Test {
    @Test(expected=JamMtException.class)
    public void testReadingFromNonExistingFile() throws JamMtException {
        XmlDoc doc = new XmlDoc("ThisFileDoesNotExist", false);
    }

    @Test
    public void testXSLTransformation() {
        String fin = "resources/XmlTest.jam";
        String fout = "resources/XmlTest.jam.tmp";
        Settings sets = new Settings();
        sets.loadFromFile(fin);
        sets.writeToFile(fout);
        try {
            Document input = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.newControlParser(), (Reader)new FileReader(fin));
            Document output = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.newControlParser(), (Reader)new FileReader(fout));
            int cnt = 1;
            DetailedDiff diff = new DetailedDiff(new Diff(input, output));
            List diffList = diff.getAllDifferences();
            if (diffList.size() != 0) {
                for (Object obj : diffList) {
                    Difference diffFound = (Difference)obj;
                    System.err.println("Difference nr. " + cnt++ + " : " + diffFound.getDescription());
                    System.err.println("   Location: " + diffFound.getControlNodeDetail().getXpathLocation());
                    System.err.println("          -> expected '" + diffFound.getControlNodeDetail().getValue() + "', found '" + diffFound.getTestNodeDetail().getValue() + "'");
                }
            }
            Assert.assertTrue(diffList.size() == 0);
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
    }
}

