/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Substrate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.ABCDmatrix;
import utils.JamMtException;

public class Substrate_Test {
    private final double EPS = 1.0E-12;
    private Substrate s;

    @Before
    public void setUp() {
        try {
            this.s = new Substrate(0.0, 1.5, 0.01, -0.1, 0.1, 0.025);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testGetAngleInDegrees() {
        this.s.setAngleInRadians(Math.PI);
        Assert.assertEquals(180.0, this.s.getAngleInDegrees(), 1.0E-12);
    }

    @Test
    public void testSetAngleInDegrees() {
        this.s.setAngleInDegrees(180.0);
        Assert.assertEquals(Math.PI, this.s.getAngleInRadians(), 1.0E-12);
    }

    @Test
    public void testGetEffectiveFocalLength() {
        try {
            this.s.setThickness(0.0);
        }
        catch (JamMtException e) {
            Assert.assertTrue(false);
        }
        Assert.assertEquals(0.1, this.s.getFocalLength("x"), 1.0E-12);
    }

    @Test
    public void testGetThickness() {
        this.s.setAngleInDegrees(45.0);
        Assert.assertEquals(0.014142135623731, this.s.getThickness(), 1.0E-12);
    }

    @Test(expected=JamMtException.class)
    public void testSetIndexOfRefractionThrowsException() throws JamMtException {
        this.s.setIndexOfRefraction(0.8);
    }

    @Test(expected=JamMtException.class)
    public void testABCDmatrixThrowingException() throws JamMtException {
        this.s.getABCD("z");
    }

    @Test(expected=JamMtException.class)
    public void testSetCoatingThrowingException() throws JamMtException {
        this.s.setCoating("bottom");
    }

    @Test(expected=JamMtException.class)
    public void testABCDpartialMatrixThrowingException() throws JamMtException {
        this.s.getABCD("fiber", "z");
    }

    @Test
    public void testABCD() {
        try {
            this.s.setThickness(0.0);
            ABCDmatrix M = this.s.getABCD("x");
            Assert.assertEquals(1.0, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-10.0, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(1.0, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test
    public void testABCDpropagation() {
        try {
            this.s.setAngleInDegrees(45.0);
            ABCDmatrix M = this.s.getABCD("prop", "x");
            Assert.assertEquals(1.0, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.00942809041582063, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(1.0, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test
    public void testABCDleftInterface() {
        try {
            this.s.setAngleInDegrees(45.0);
            ABCDmatrix M = this.s.getABCD("left", "x");
            Assert.assertEquals(1.0, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-6.15768874345748, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(1.0, M.getElement("D"), 1.0E-12);
            M = this.s.getABCD("left", "y");
            Assert.assertEquals(1.24721912892465, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-9.87426924531961, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(0.801783725737273, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test
    public void testABCDrightInterface() {
        try {
            this.s.setAngleInDegrees(45.0);
            ABCDmatrix M = this.s.getABCD("right", "x");
            Assert.assertEquals(1.0, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-6.15768874345748, M.getElement("C"), 1.0E-12);
            M = this.s.getABCD("right", "y");
            Assert.assertEquals(0.801783725737273, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-9.87426924531961, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(1.24721912892465, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }
}

