/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.PartialBeam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.ABCDmatrix;
import utils.JamMtException;
import utils.QParameter;

public class QParameter_Test {
    private QParameter q;
    private ABCDmatrix M_d;
    private ABCDmatrix M_f;
    private final double EPS = 1.0E-12;

    @Before
    public void setUp() {
        try {
            this.q = new QParameter(0.0, 0.0, 0.05, 0.01, 0.06);
            this.M_d = new ABCDmatrix(1.0, 0.03, 0.0, 1.0);
            this.M_f = new ABCDmatrix(1.0, 0.0, -10.0, 1.0);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test(expected=JamMtException.class)
    public void testZeroImPart() throws JamMtException {
        this.q = new QParameter(0.0, 1.0, 0.0);
    }

    @Test(expected=JamMtException.class)
    public void testGetRealThrowsException() throws JamMtException {
        this.q.getRePart("z");
    }

    @Test(expected=JamMtException.class)
    public void testGetImagThrowsException() throws JamMtException {
        this.q.getImPart("z");
    }

    @Test
    public void testPropagateInFreeSpace() {
        double z0 = this.q.toBeam(1.0, 1.064E-6).getWaistPosition("x");
        double w0 = this.q.toBeam(1.0, 1.064E-6).getWaistSize("x");
        this.q.propagate(this.M_d, 0.03);
        try {
            Assert.assertEquals(0.03, this.q.getRePart("x"), 1.0E-12);
            Assert.assertEquals(0.04, this.q.getRePart("y"), 1.0E-12);
            Assert.assertTrue(this.q.getImPart("x") == 0.05);
            Assert.assertTrue(this.q.getImPart("y") == 0.06);
        }
        catch (JamMtException je) {
            // empty catch block
        }
        Assert.assertEquals(z0, this.q.toBeam(1.0, 1.064E-6).getWaistPosition("x"), 1.0E-12);
        Assert.assertEquals(w0, this.q.toBeam(1.0, 1.064E-6).getWaistSize("x"), 1.0E-12);
    }

    @Test
    public void testPropagateThroughThinLens() {
        this.q.propagate(this.M_f, 0.0);
        try {
            Assert.assertEquals(-0.02, this.q.getRePart("x"), 1.0E-12);
            Assert.assertEquals(0.04, this.q.getImPart("x"), 1.0E-12);
            Assert.assertEquals(-0.0230769230769231, this.q.getRePart("y"), 1.0E-12);
            Assert.assertEquals(0.0512820512820513, this.q.getImPart("y"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test
    public void testToPartialBeam() {
        PartialBeam b = this.q.toBeam(2.0, 1.064E-6);
        Assert.assertEquals(5.32E-7, b.getWaveLength(), 1.0E-12);
        Assert.assertEquals(0.0, b.getWaistPosition("x"), 1.0E-12);
        Assert.assertEquals(1.30131033750515E-4, b.getWaistSize("x"), 1.0E-12);
        Assert.assertEquals(-0.02, b.getWaistPosition("y"), 1.0E-12);
        Assert.assertEquals(1.42551405233246E-4, b.getWaistSize("y"), 1.0E-12);
    }
}

