/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Lens;
import components.PartialBeam;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentSet;
import utils.FitParameter;
import utils.GridSearch;
import utils.JamMtException;
import utils.ModematchingFinder;
import utils.ModematchingSolution;

public class Modematching_Test {
    private double EPS = 1.0E-12;
    private ComponentSet testset;
    private Lens l1;
    private Lens l2;
    private Lens l3;

    @Before
    public void setUp() {
        this.testset = new ComponentSet();
        try {
            this.l1 = new Lens(0.0, 0.1, 0.025);
            this.l2 = new Lens(0.0, 0.2, 0.025);
            this.l3 = new Lens(0.0, 0.3, 0.025);
            this.testset.addComponent(this.l1);
            this.testset.addComponent(this.l2);
            this.testset.addComponent(this.l3);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testLensSetCombinationsWithoutLenses() {
        Vector<ComponentSet> sets = ModematchingFinder.getLensSets(new ComponentSet(), 0);
        Assert.assertEquals(0L, sets.size());
        sets = ModematchingFinder.getLensSets(new ComponentSet(), 10);
        Assert.assertEquals(0L, sets.size());
        sets = ModematchingFinder.getLensSets(this.testset, 0);
        Assert.assertEquals(0L, sets.size());
    }

    @Test
    public void testLensSetCombinationsWithOneLens() {
        Vector<ComponentSet> sets = ModematchingFinder.getLensSets(this.testset, 1);
        Assert.assertEquals(3L, sets.size());
        for (ComponentSet set : sets) {
            Assert.assertEquals(1L, set.getLenses().size());
        }
        try {
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(1).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(2).getLenses().get(0).getFocalLength("x"), this.EPS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLensSetCombinationsWithTwoLenses() {
        Vector<ComponentSet> sets = ModematchingFinder.getLensSets(this.testset, 2);
        Assert.assertEquals(6L, sets.size());
        for (ComponentSet set : sets) {
            Assert.assertEquals(2L, set.getLenses().size());
        }
        try {
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(1).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(1).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(2).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(2).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(3).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(3).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(4).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(4).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(5).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(5).getLenses().get(1).getFocalLength("x"), this.EPS);
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
    }

    @Test
    public void testLensSetCombinationsWithThreeLenses() {
        Vector<ComponentSet> sets = ModematchingFinder.getLensSets(this.testset, 3);
        Assert.assertEquals(10L, sets.size());
        for (ComponentSet set : sets) {
            Assert.assertEquals(3L, set.getLenses().size());
        }
        try {
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(0).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(1).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(1).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(1).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(2).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(2).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(2).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(3).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(3).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(3).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(4).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(4).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(4).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.3, sets.get(5).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(5).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(5).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(6).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(6).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(6).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(7).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(7).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(7).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.1, sets.get(8).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(8).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(8).getLenses().get(2).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(9).getLenses().get(0).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(9).getLenses().get(1).getFocalLength("x"), this.EPS);
            Assert.assertEquals(0.2, sets.get(9).getLenses().get(2).getFocalLength("x"), this.EPS);
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
    }

    @Test
    public void testIsNewSet() {
        try {
            Vector<ComponentSet> sets = new Vector<ComponentSet>();
            sets.add(this.testset);
            Assert.assertFalse(ModematchingFinder.isNewSet(this.testset, sets));
            ComponentSet newset = new ComponentSet();
            Lens l1 = new Lens(0.0, 0.1, 0.025);
            Lens l2 = new Lens(0.0, 0.2, 0.025);
            Lens l3 = new Lens(0.0, 0.2, 0.025);
            newset.addComponent(l1);
            newset.addComponent(l2);
            newset.addComponent(l3);
            Assert.assertTrue(ModematchingFinder.isNewSet(newset, sets));
            sets.add(newset);
            ComponentSet fakenewset = new ComponentSet();
            l1 = new Lens(0.0, 0.2, 0.025);
            l2 = new Lens(0.0, 0.3, 0.025);
            l3 = new Lens(0.0, 0.1, 0.025);
            fakenewset.addComponent(l1);
            fakenewset.addComponent(l2);
            fakenewset.addComponent(l3);
            Assert.assertFalse(ModematchingFinder.isNewSet(fakenewset, sets));
            ComponentSet anothernewset = new ComponentSet();
            l1 = new Lens(0.0, 0.1, 0.025);
            l2 = new Lens(0.0, 0.2, 0.025);
            l3 = new Lens(0.0, 0.1, 0.025);
            anothernewset.addComponent(l1);
            anothernewset.addComponent(l2);
            anothernewset.addComponent(l3);
            Assert.assertTrue(ModematchingFinder.isNewSet(anothernewset, sets));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testSolutionsAreInRange() {
        FitParameter fp = new FitParameter();
        fp.visibility = 0.99;
        fp.nl = 2;
        fp.z_start = 0.0;
        fp.z_end = 0.8;
        fp.grid_size = 100;
        fp.dz0x = 0.01;
        fp.dz0y = 0.01;
        ComponentSet fittingLenses = new ComponentSet();
        ComponentSet persistentSet = new ComponentSet();
        try {
            fittingLenses.addComponent(new Lens(0.0, 0.1, 0.025));
            fittingLenses.addComponent(new Lens(0.0, -0.1, 0.025));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
        try {
            PartialBeam initialBeam = new PartialBeam(3.7E-4, 0.0, 3.7E-4, 0.0, 1.064E-6);
            GridSearch fit = new GridSearch(initialBeam, new PartialBeam(2.0E-5, 0.79, 2.0E-5, 0.79, 1.064E-6), fittingLenses, persistentSet, fp);
            fit.startSearch();
            Vector<ModematchingSolution> sols = fit.getSolutions();
            Assert.assertEquals(33L, sols.size());
            for (ModematchingSolution sol : sols) {
                Assert.assertTrue(sol.visibility_x >= 0.99);
                Assert.assertTrue(sol.visibility_y >= 0.99);
            }
            Beam b = new Beam(initialBeam, new ComponentSet(), new CavitySet());
            for (ModematchingSolution sol : sols) {
                b.setLenses(sol.components);
                Assert.assertTrue(b.getLast().getWaistPosition("x") >= 0.79);
                Assert.assertTrue(b.getLast().getWaistPosition("y") >= 0.79);
                Assert.assertTrue(b.getLast().getWaistPosition("x") <= 0.8);
                Assert.assertTrue(b.getLast().getWaistPosition("y") <= 0.8);
            }
        }
        catch (JamMtException e) {
            Assert.assertTrue(false);
        }
    }
}

