/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Lens;
import components.Substrate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.ABCDmatrix;
import utils.ComponentSet;
import utils.JamMtException;

public class LensSet_Test {
    private final double EPS = 1.0E-6;
    Lens l1;
    Lens l2;
    ComponentSet set = new ComponentSet();

    @Before
    public void setUp() {
        try {
            this.l1 = new Lens(-0.1, 0.1, 0.5, 0.025);
            this.l2 = new Lens(0.1, 0.1, 0.5, 0.025);
            this.set.addComponent(this.l1);
            this.set.addComponent(this.l2);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testABCDmatrix() {
        try {
            ABCDmatrix Mx = this.l1.getABCD("x");
            ABCDmatrix My = this.l1.getABCD("y");
            Assert.assertEquals(1.0, Mx.getElement("A"), 1.0E-6);
            Assert.assertEquals(0.0, Mx.getElement("B"), 1.0E-6);
            Assert.assertEquals(-10.0, Mx.getElement("C"), 1.0E-6);
            Assert.assertEquals(1.0, Mx.getElement("D"), 1.0E-6);
            Assert.assertEquals(1.0, My.getElement("A"), 1.0E-6);
            Assert.assertEquals(0.0, My.getElement("B"), 1.0E-6);
            Assert.assertEquals(-2.0, My.getElement("C"), 1.0E-6);
            Assert.assertEquals(1.0, My.getElement("D"), 1.0E-6);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test(expected=JamMtException.class)
    public void testSetApertureThrowingException() throws JamMtException {
        this.l1.setAperture(-0.1);
    }

    @Test(expected=JamMtException.class)
    public void testABCDmatrixThrowingException() throws JamMtException {
        ABCDmatrix M = this.l1.getABCD("z");
    }

    @Test(expected=JamMtException.class)
    public void testGetFocalLengthThrowingException() throws JamMtException {
        this.l1.getFocalLength("z");
    }

    @Test(expected=JamMtException.class)
    public void testSetFocalLengthThrowingException() throws JamMtException {
        this.l1.setFocalLength("z", 0.2);
    }

    @Test(expected=JamMtException.class)
    public void testZeroFocalLength() throws JamMtException {
        this.l1.setFocalLength("x", 0.0);
    }

    @Test
    public void testCompare() {
        Assert.assertEquals(-1L, this.l1.compareTo(this.l2));
        Assert.assertEquals(1L, this.l2.compareTo(this.l1));
    }

    @Test
    public void testGetSpaceBetweenLenses() {
        Assert.assertEquals(0.2, this.set.getSpaceBetween(this.l1, this.l2), 1.0E-6);
    }

    @Test
    public void testGetSpaceBetweenSubstrates() {
        try {
            Substrate s1 = new Substrate(0.01, 1.5, 0.1, -0.01, 0.01, 0.025);
            Substrate s2 = new Substrate(0.2, 1.8, 0.01, -0.01, 0.01, 0.025);
            s1.setAngleInDegrees(45.0);
            Assert.assertEquals(0.114289321881345, this.set.getSpaceBetween(s1, s2), 1.0E-6);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testGetSystemsABCDmatrix() {
        ComponentSet set = new ComponentSet();
        try {
            set.addComponent(new Lens(0.0, 0.604, 0.025));
            set.addComponent(new Lens(0.67901, 0.075, 0.025));
            set.addComponent(new Lens(6.37901, 0.3436, 0.025));
            set.addComponent(new Lens(6.48701, -0.2291, 0.025));
            double z = set.getLastLens().getPosition() + 0.4;
            ABCDmatrix M = set.getABCDmatrixAt(z, "x");
            Assert.assertEquals(-0.08921484, M.getElement("A"), 0.01);
            Assert.assertEquals(-38.11395, M.getElement("B"), 1.0E-5);
            Assert.assertEquals(-0.009939184, M.getElement("C"), 0.001);
            Assert.assertEquals(-15.58435, M.getElement("D"), 1.0E-6);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }
}

