/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Component;
import components.Lens;
import components.PartialBeam;
import java.util.ArrayList;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.ComponentSet;
import utils.JamMtException;
import utils.ModematchingSolution;
import utils.Settings;

public class LensFitter_Test {
    Settings settings;
    ArrayList<Component> list;

    @Before
    public void setUp() {
        this.settings = new Settings();
        this.settings.right_focus = false;
        this.settings.lens_overlap = false;
        this.settings.single_lens_use = false;
        this.settings.nearby_solution = false;
        this.list = new ArrayList();
    }

    @Test
    public void testVetoLensSet_RightFocus() {
        this.settings.right_focus = true;
        try {
            Lens l1 = new Lens(0.0, 0.2, 0.025);
            Lens l2 = new Lens(0.1, 0.1, 0.025);
            this.list.add(l1);
            this.list.add(l2);
            ComponentSet set = new ComponentSet();
            set.setComponents(this.list);
            Assert.assertTrue(set.vetoLensSet(0.05, this.settings, new Vector<ModematchingSolution>()));
            Assert.assertFalse(set.vetoLensSet(0.15, this.settings, new Vector<ModematchingSolution>()));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testVetoLensSet_LensOverlap() {
        this.settings.lens_overlap = true;
        try {
            Lens l1 = new Lens(0.0, 0.2, 0.025);
            Lens l2 = new Lens(0.0, 0.1, 0.025);
            this.list.add(l1);
            this.list.add(l2);
            ComponentSet set = new ComponentSet();
            set.setComponents(this.list);
            Assert.assertTrue(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
            set.getLenses().get(0).setThickness(0.01);
            set.getLenses().get(1).setThickness(0.01);
            set.getLenses().get(1).setPosition(0.008);
            Assert.assertTrue(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
            set.getLenses().get(1).setPosition(0.011);
            Assert.assertFalse(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testVetoLensSet_SingleLensUse() {
        this.settings.single_lens_use = true;
        try {
            Lens l1 = new Lens(0.0, 0.2, 0.025);
            Lens l2 = new Lens(0.1, 0.2, 0.025);
            this.list.add(l1);
            this.list.add(l2);
            ComponentSet set = new ComponentSet();
            set.setComponents(this.list);
            Assert.assertTrue(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
            set.getLenses().get(1).setFocalLength("x", 0.1);
            Assert.assertFalse(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
            set.getLenses().get(1).setPosition(set.getLenses().get(0).getPosition());
            set.getLenses().get(1).setFocalLength("x", set.getLenses().get(0).getFocalLength("x"));
            Assert.assertTrue(set.vetoLensSet(0.0, this.settings, new Vector<ModematchingSolution>()));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testVetoLensSet_NearbySolution() {
        this.settings.nearby_solution = true;
        try {
            Lens l1 = new Lens(0.0, 0.1, 0.025);
            Lens l2 = new Lens(0.1, 0.2, 0.025);
            this.list.add(l1);
            this.list.add(l2);
            ComponentSet set = new ComponentSet();
            set.setComponents(this.list);
            Vector<ModematchingSolution> solution = new Vector<ModematchingSolution>();
            solution.add(new ModematchingSolution(set, new PartialBeam(2.0E-5, 0.0, 1.064E-6), new PartialBeam(1.8E-5, 0.0, 1.064E-6)));
            Assert.assertTrue(set.vetoLensSet(0.0, this.settings, solution));
            solution.get((int)0).components.getLenses().get(1).setPosition(0.15);
            Assert.assertTrue(set.vetoLensSet(0.06, this.settings, solution));
            solution.get((int)0).components.getLenses().get(1).setPosition(0.18);
            Assert.assertTrue(set.vetoLensSet(0.06, this.settings, solution));
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }
}

