/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Cavity;
import components.Lens;
import components.Substrate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.ComponentSet;
import utils.JamMtException;

public class Cavity_Test {
    private final double EPS = 1.0E-12;
    private Cavity cav;
    private Substrate m;

    @Before
    public void setUp() {
        try {
            this.m = new Substrate(0.0, 1.5, 0.01, -0.1, 0.1, 0.025);
            this.cav = new Cavity("Test", this.m, this.m, false, "right", "left");
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test(expected=JamMtException.class)
    public void testConstructorThrowsException() throws JamMtException {
        ComponentSet lenses = new ComponentSet();
        lenses.addComponent(new Lens(0.0, 0.1, 0.025));
        lenses.addComponent(new Lens(0.0, 0.1, 0.025));
        Cavity cav = new Cavity("Test", lenses, false, "right", "left");
    }

    @Test(expected=JamMtException.class)
    public void testSetEndMirrorSideThrowsException() throws JamMtException {
        this.cav.setEndMirror("none", this.m);
    }

    @Test(expected=JamMtException.class)
    public void testGetEndMirrorThrowsException() throws JamMtException {
        this.cav.getEndMirror("none");
    }

    @Test(expected=JamMtException.class)
    public void testGetStabilityParameterThrowsException() throws JamMtException {
        this.cav.getStabilityParameter("none");
    }

    @Test(expected=JamMtException.class)
    public void testSetComponentsEmptySetThrowsException() throws JamMtException {
        this.cav.setComponents(new ComponentSet());
    }

    @Test(expected=JamMtException.class)
    public void testSetComponentsWrongEndMirrorThrowsException() throws JamMtException {
        ComponentSet set = new ComponentSet();
        set.addComponent(new Lens(0.0, 0.1, 0.025));
        this.cav.setComponents(set);
    }

    @Test
    public void testMonolithicCavity() {
        try {
            Substrate mono = new Substrate(0.1, 2.233, 0.0065, -0.008, 0.008, 0.025);
            this.cav = new Cavity("Test", mono, mono, false, "left", "right");
            Assert.assertTrue(this.cav.isStable());
            Assert.assertEquals(0.1, this.cav.getInnerEigenmode(1.064E-6).getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(2.44115726597645E-5, this.cav.getInnerEigenmode(1.064E-6).getWaistSize("x"), 1.0E-12);
            Assert.assertEquals(3.1680640071231E-5, this.cav.getInnerEigenmode(1.064E-6).getSizeAt(0.09675, "x"), 1.0E-12);
            Assert.assertEquals(-0.00799999999999997, this.cav.getInnerEigenmode(1.064E-6).getRadiusAt(0.09675, "x"), 1.0E-12);
            Assert.assertEquals(0.0977152913619204, this.cav.getEigenmode(1.064E-6).getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(2.97079039599111E-5, this.cav.getEigenmode(1.064E-6).getWaistSize("x"), 1.0E-12);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testHemilithicCavity() {
        try {
            ComponentSet set = new ComponentSet();
            set.addComponent(new Substrate(-0.005, 1.0, 0.01, 1.0E12, -0.025, 0.025));
            set.addComponent(new Substrate(0.02625, 2.233, 0.0065, 1.0E12, 0.008, 0.025));
            this.cav = new Cavity("OPA", set, false, "right", "right");
            Assert.assertTrue(this.cav.isStable());
            Assert.assertEquals(2.3384834E-5, this.cav.getInnerEigenmode(1.064E-6).getWaistSize("x"), 1.0E-12);
            Assert.assertEquals(0.024895278, this.cav.getInnerEigenmode(1.064E-6).getWaistPosition("x"), 1.0E-9);
        }
        catch (JamMtException je) {
            Assert.assertTrue(false);
        }
    }

    @Test
    public void testSimpleCavity() {
        try {
            ComponentSet set = new ComponentSet();
            set.addComponent(new Substrate(-0.05, 1.0, 0.0, 1.0E12, -0.075, 0.025));
            set.addComponent(new Substrate(0.05, 1.0, 0.0, 0.075, 1.0E12, 0.025));
            this.cav = new Cavity("Test", set, false, "right", "left");
            Assert.assertTrue(this.cav.isStable());
            Assert.assertEquals(0.0, this.cav.getInnerEigenmode(1.064E-6).getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(1.09426719794068E-4, this.cav.getInnerEigenmode(1.064E-6).getWaistSize("x"), 1.0E-12);
            Assert.assertEquals(0.0, this.cav.getEigenmode(1.064E-6).getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(1.09426719794068E-4, this.cav.getEigenmode(1.064E-6).getWaistSize("x"), 1.0E-12);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testConfocalCavity() {
        try {
            ComponentSet set = new ComponentSet();
            set.addComponent(new Substrate(0.0, 1.0, 0.0, -0.1, -0.1, 0.025));
            set.addComponent(new Substrate(0.2, 1.0, 0.0, 0.1, 0.1, 0.025));
            this.cav = new Cavity("Test", set, false, "right", "left");
            Assert.assertFalse(this.cav.isStable());
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }

    @Test
    public void testCavityWithLensInside() {
        try {
            ComponentSet set = new ComponentSet();
            set.addComponent(new Substrate(-0.05, 1.0, 0.0, 1.0E12, -0.075, 0.025));
            set.addComponent(new Lens(0.0, 0.1, 0.025));
            set.addComponent(new Substrate(0.05, 1.0, 0.0, 0.075, 1.0E12, 0.025));
            this.cav = new Cavity("Test", set, false, "right", "left");
            Assert.assertTrue(this.cav.isStable());
            Assert.assertEquals(-0.075, this.cav.getInnerEigenmode(1.064E-6).getRadiusAt(-0.05, "x"), 1.0E-12);
        }
        catch (JamMtException e) {
            Assert.assertFalse(true);
        }
    }
}

