/*
 * Decompiled with CFR 0.152.
 */
package tests;

import components.Lens;
import components.PartialBeam;
import components.Substrate;
import org.junit.Assert;
import org.junit.Test;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentSet;
import utils.JamMtException;

public class Beam_Test {
    private final double EPS = 1.0E-12;

    @Test
    public void testGetWaistSizeAfterLens() {
        ComponentSet lenses = new ComponentSet();
        try {
            lenses.addComponent(new Lens(0.0, 0.1, 0.025));
            Beam b = new Beam(new PartialBeam(3.7E-4, 0.0, 1.064E-6), lenses, new CavitySet());
            Assert.assertTrue(b.getNumberOfBeams() == 2);
            Assert.assertEquals(0.0942326285920086, b.getLast().getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(8.88568031021834E-5, b.getLast().getWaistSize("x"), 1.0E-12);
        }
        catch (JamMtException e) {
            Assert.assertTrue(false);
        }
    }

    @Test
    public void testGetWaistSizeAfterSubstrate() {
        ComponentSet lenses = new ComponentSet();
        try {
            lenses.addComponent(new Substrate(0.0, 1.5, 0.0, -0.1, 0.1, 0.025));
            Beam b = new Beam(new PartialBeam(3.7E-4, 0.0, 1.064E-6), lenses, new CavitySet());
            Assert.assertTrue(0.1 == ((Substrate)lenses.getLenses().get(0)).getFocalLength("x"));
            Assert.assertTrue(b.getNumberOfBeams() == 3);
            Assert.assertEquals(0.0942326285920086, b.getLast().getWaistPosition("x"), 1.0E-12);
            Assert.assertEquals(8.88568031021834E-5, b.getLast().getWaistSize("x"), 1.0E-12);
        }
        catch (JamMtException e) {
            Assert.assertTrue(false);
        }
    }
}

