/*
 * Decompiled with CFR 0.152.
 */
package tests;

import org.junit.Assert;
import org.junit.Test;
import utils.ABCDmatrix;
import utils.JamMtException;

public class ABCDmatrix_Test {
    private final double EPS = 1.0E-12;

    @Test(expected=JamMtException.class)
    public void testCheckMatrix() throws JamMtException {
        ABCDmatrix M = new ABCDmatrix(1.0, 1.0, 1.0, 1.0);
    }

    @Test(expected=JamMtException.class)
    public void testSetElementThrowsException() throws JamMtException {
        ABCDmatrix M = new ABCDmatrix(2.0, 0.0, 3.0, 0.5);
        M.setElement("E", 0.0);
    }

    @Test(expected=JamMtException.class)
    public void testGetElementThrowsException() throws JamMtException {
        ABCDmatrix M = new ABCDmatrix(2.0, 0.0, 3.0, 0.5);
        M.getElement("E");
    }

    @Test
    public void testInvertMatrix() {
        try {
            ABCDmatrix M = new ABCDmatrix(2.0, 0.0, 3.0, 0.5).invert();
            Assert.assertEquals(0.5, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(-3.0, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(2.0, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    @Test
    public void testTimesLeft() {
        try {
            ABCDmatrix M = new ABCDmatrix(2.0, 0.0, 3.0, 0.5);
            M.timesLeft(new ABCDmatrix(0.5, 0.0, 2.0, 2.0));
            Assert.assertEquals(1.0, M.getElement("A"), 1.0E-12);
            Assert.assertEquals(0.0, M.getElement("B"), 1.0E-12);
            Assert.assertEquals(10.0, M.getElement("C"), 1.0E-12);
            Assert.assertEquals(1.0, M.getElement("D"), 1.0E-12);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }
}

