/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class Baseline {
    static final int BRB_NONE = 0;
    public static final int BRB_CONSTANT_ASCENT = 1;
    public static final int BRB_CONSTANT_DESCENT = 2;
    public static final int BRB_CENTER_OFFSET = 3;
    public static final int BRB_OTHER = 4;
    private static final Rectangle viewRect;
    private static final Rectangle textRect;
    private static final Rectangle iconRect;
    private static final int EDGE_SPACING = 2;
    private static final int TEXT_SPACING = 2;
    private static final Insets EMPTY_INSETS;
    private static JLabel TABLE_LABEL;
    private static JLabel LIST_LABEL;
    private static JLabel TREE_LABEL;
    private static Class CLASSIC_WINDOWS;
    private static boolean checkedForClassic;
    private static Class WINDOWS_CLASS;
    private static boolean checkedForWindows;
    private static boolean inSandbox;
    private static boolean checkedForOcean;
    private static boolean usingOcean;
    private static final Map BASELINE_MAP;
    private static final Map BRB_I_MAP;
    private static final Method COMPONENT_BASELINE_METHOD;
    private static final Method COMPONENT_BRB_METHOD;
    private static final Object ENUM_BRB_CENTER_OFFSET;
    private static final Object ENUM_BRB_CONSTANT_ASCENT;
    private static final Object ENUM_BRB_CONSTANT_DESCENT;
    private static final Object ENUM_BRB_OTHER;
    private static JList brbList;
    private static ListCellRenderer brbListCellRenderer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.jdesktop.layout.Baseline");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        viewRect = new Rectangle();
        textRect = new Rectangle();
        iconRect = new Rectangle();
        EMPTY_INSETS = new Insets(0, 0, 0, 0);
        BASELINE_MAP = Collections.synchronizedMap(new HashMap(1));
        BRB_I_MAP = Collections.synchronizedMap(new HashMap(1));
        Method method = null;
        Method method2 = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.awt.Component");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method = clazz2.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.awt.Component");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method2 = clazz3.getMethod("getBaselineResizeBehavior", new Class[0]);
            Class<?> clazz4 = Class.forName("java.awt.Component$BaselineResizeBehavior");
            object = Baseline.getFieldValue(clazz4, "CENTER_OFFSET");
            object2 = Baseline.getFieldValue(clazz4, "CONSTANT_ASCENT");
            object3 = Baseline.getFieldValue(clazz4, "CONSTANT_DESCENT");
            object4 = Baseline.getFieldValue(clazz4, "OTHER");
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (method == null || method2 == null || object == null || object3 == null || object2 == null || object4 == null) {
            method2 = null;
            method = null;
            object4 = null;
            object3 = null;
            object2 = null;
            object = null;
        }
        COMPONENT_BASELINE_METHOD = method;
        COMPONENT_BRB_METHOD = method2;
        ENUM_BRB_CENTER_OFFSET = object;
        ENUM_BRB_CONSTANT_ASCENT = object2;
        ENUM_BRB_CONSTANT_DESCENT = object3;
        ENUM_BRB_OTHER = object4;
    }

    private static Object getFieldValue(Class clazz, String string) throws IllegalAccessException, NoSuchFieldException {
        return clazz.getField(string).get(null);
    }

    static int getBaselineResizeBehavior(Component component) {
        if (component instanceof JComponent) {
            return Baseline.getBaselineResizeBehavior((JComponent)component);
        }
        return 4;
    }

    public static int getBaselineResizeBehavior(JComponent jComponent) {
        Method method = Baseline.getBRBIMethod(jComponent);
        if (method != null) {
            return Baseline.invokeBRBIMethod(method, jComponent);
        }
        if (COMPONENT_BRB_METHOD != null) {
            return Baseline.getBaselineResizeBehaviorUsingMustang(jComponent);
        }
        String string = jComponent.getUIClassID();
        if (string == "ButtonUI" || string == "CheckBoxUI" || string == "RadioButtonUI" || string == "ToggleButtonUI") {
            return Baseline.getButtonBaselineResizeBehavior((AbstractButton)jComponent);
        }
        if (string == "ComboBoxUI") {
            return Baseline.getComboBoxBaselineResizeBehavior((JComboBox)jComponent);
        }
        if (string == "TextAreaUI") {
            return Baseline.getTextAreaBaselineResizeBehavior((JTextArea)jComponent);
        }
        if (string == "TextFieldUI" || string == "FormattedTextFieldUI" || string == "PasswordFieldUI") {
            return Baseline.getSingleLineTextBaselineResizeBehavior((JTextField)jComponent);
        }
        if (string == "LabelUI") {
            return Baseline.getLabelBaselineResizeBehavior((JLabel)jComponent);
        }
        if (string == "ListUI") {
            return Baseline.getListBaselineResizeBehavior((JList)jComponent);
        }
        if (string == "PanelUI") {
            return Baseline.getPanelBaselineResizeBehavior((JPanel)jComponent);
        }
        if (string == "ProgressBarUI") {
            return Baseline.getProgressBarBaselineResizeBehavior((JProgressBar)jComponent);
        }
        if (string == "SliderUI") {
            return Baseline.getSliderBaselineResizeBehavior((JSlider)jComponent);
        }
        if (string == "SpinnerUI") {
            return Baseline.getSpinnerBaselineResizeBehavior((JSpinner)jComponent);
        }
        if (string == "ScrollPaneUI") {
            return Baseline.getScrollPaneBaselineBaselineResizeBehavior((JScrollPane)jComponent);
        }
        if (string == "TabbedPaneUI") {
            return Baseline.getTabbedPaneBaselineResizeBehavior((JTabbedPane)jComponent);
        }
        if (string == "TableUI") {
            return Baseline.getTableBaselineResizeBehavior((JTable)jComponent);
        }
        if (string == "TreeUI") {
            return Baseline.getTreeBaselineResizeBehavior((JTree)jComponent);
        }
        return 4;
    }

    private static int getBaselineResizeBehaviorUsingMustang(JComponent jComponent) {
        block11: {
            Object object;
            block10: {
                block9: {
                    object = COMPONENT_BRB_METHOD.invoke((Object)jComponent, null);
                    if (object != ENUM_BRB_CENTER_OFFSET) break block9;
                    return 3;
                }
                if (object != ENUM_BRB_CONSTANT_ASCENT) break block10;
                return 1;
            }
            try {
                if (object == ENUM_BRB_CONSTANT_DESCENT) {
                    return 2;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError();
            }
        }
        return 4;
    }

    private static Method getBRBIMethod(Component component) {
        Class<?> clazz = component.getClass();
        while (clazz != null) {
            if (BRB_I_MAP.containsKey(clazz)) {
                Method method = (Method)BRB_I_MAP.get(clazz);
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = component.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length - 1;
        while (n >= 0) {
            Class<?>[] classArray;
            Method method = methodArray[n];
            if ("getBaselineResizeBehaviorInt".equals(method.getName()) && (classArray = method.getParameterTypes()).length == 0) {
                BRB_I_MAP.put(clazz, method);
                return method;
            }
            --n;
        }
        BRB_I_MAP.put(clazz, null);
        return null;
    }

    private static int invokeBRBIMethod(Method method, Component component) {
        int n = 4;
        try {
            n = (Integer)method.invoke((Object)component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return n;
    }

    private static int getTreeBaselineResizeBehavior(JTree jTree) {
        return 1;
    }

    private static int getSingleLineTextBaselineResizeBehavior(JTextField jTextField) {
        return 3;
    }

    private static int getTextAreaBaselineResizeBehavior(JTextArea jTextArea) {
        return 1;
    }

    private static int getTableBaselineResizeBehavior(JTable jTable) {
        return 1;
    }

    private static int getTabbedPaneBaselineResizeBehavior(JTabbedPane jTabbedPane) {
        switch (jTabbedPane.getTabPlacement()) {
            case 1: 
            case 2: 
            case 4: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    private static int getSpinnerBaselineResizeBehavior(JSpinner jSpinner) {
        return Baseline.getBaselineResizeBehavior(jSpinner.getEditor());
    }

    private static int getSliderBaselineResizeBehavior(JSlider jSlider) {
        return 4;
    }

    private static int getScrollPaneBaselineBaselineResizeBehavior(JScrollPane jScrollPane) {
        return 1;
    }

    private static int getProgressBarBaselineResizeBehavior(JProgressBar jProgressBar) {
        if (jProgressBar.isStringPainted() && jProgressBar.getOrientation() == 0) {
            return 3;
        }
        return 4;
    }

    private static int getPanelBaselineResizeBehavior(JPanel jPanel) {
        Border border = jPanel.getBorder();
        if (border instanceof TitledBorder) {
            switch (((TitledBorder)border).getTitlePosition()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: 
                case 5: 
                case 6: {
                    return 2;
                }
            }
        }
        return 4;
    }

    private static int getListBaselineResizeBehavior(JList jList) {
        return 1;
    }

    private static int getLabelBaselineResizeBehavior(JLabel jLabel) {
        if (jLabel.getClientProperty("html") != null) {
            return 4;
        }
        switch (jLabel.getVerticalAlignment()) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        return 4;
    }

    private static int getButtonBaselineResizeBehavior(AbstractButton abstractButton) {
        if (abstractButton.getClientProperty("html") != null) {
            return 4;
        }
        switch (abstractButton.getVerticalAlignment()) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        return 4;
    }

    private static int getComboBoxBaselineResizeBehavior(JComboBox jComboBox) {
        if (jComboBox.isEditable()) {
            return Baseline.getBaselineResizeBehavior(jComboBox.getEditor().getEditorComponent());
        }
        ListCellRenderer listCellRenderer = jComboBox.getRenderer();
        if (listCellRenderer == null) {
            if (brbListCellRenderer == null) {
                brbListCellRenderer = new DefaultListCellRenderer();
            }
            listCellRenderer = brbListCellRenderer;
        }
        Object e = null;
        Object e2 = jComboBox.getPrototypeDisplayValue();
        if (e2 != null) {
            e = e2;
        } else if (jComboBox.getModel().getSize() > 0) {
            e = jComboBox.getModel().getElementAt(0);
        }
        if (e != null) {
            if (brbList == null) {
                brbList = new JList();
            }
            Component component = listCellRenderer.getListCellRendererComponent(brbList, e, -1, false, false);
            return Baseline.getBaselineResizeBehavior(component);
        }
        return 4;
    }

    public static int getBaseline(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        return Baseline.getBaseline(jComponent, dimension.width, dimension.height);
    }

    private static Method getBaselineMethod(JComponent jComponent) {
        if (COMPONENT_BASELINE_METHOD != null) {
            return COMPONENT_BASELINE_METHOD;
        }
        Class<?> clazz = jComponent.getClass();
        while (clazz != null) {
            if (BASELINE_MAP.containsKey(clazz)) {
                Method method = (Method)BASELINE_MAP.get(clazz);
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = jComponent.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length - 1;
        while (n >= 0) {
            Class<?>[] classArray;
            Method method = methodArray[n];
            if ("getBaseline".equals(method.getName()) && (classArray = method.getParameterTypes()).length == 2 && classArray[0] == Integer.TYPE && classArray[1] == Integer.TYPE) {
                BASELINE_MAP.put(clazz, method);
                return method;
            }
            --n;
        }
        BASELINE_MAP.put(clazz, null);
        return null;
    }

    private static int invokeBaseline(Method method, JComponent jComponent, int n, int n2) {
        int n3 = -1;
        try {
            n3 = (Integer)method.invoke((Object)jComponent, new Integer(n), new Integer(n2));
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return n3;
    }

    private static boolean isKnownLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getID();
        return string == "GTK" || string == "Aqua" || Baseline.isMetal(lookAndFeel) || Baseline.isWindows(lookAndFeel);
    }

    public static int getBaseline(JComponent jComponent, int n, int n2) {
        Method method = Baseline.getBaselineMethod(jComponent);
        if (method != null) {
            return Baseline.invokeBaseline(method, jComponent, n, n2);
        }
        Object object = UIManager.get("Baseline.instance");
        if (object != null && object instanceof Baseline) {
            return ((Baseline)object).getComponentBaseline(jComponent, n, n2);
        }
        if (!Baseline.isKnownLookAndFeel()) {
            return -1;
        }
        String string = jComponent.getUIClassID();
        int n3 = -1;
        if (string == "ButtonUI" || string == "CheckBoxUI" || string == "RadioButtonUI" || string == "ToggleButtonUI") {
            n3 = Baseline.getButtonBaseline((AbstractButton)jComponent, n2);
        } else {
            if (string == "ComboBoxUI") {
                return Baseline.getComboBoxBaseline((JComboBox)jComponent, n2);
            }
            if (string == "TextAreaUI") {
                return Baseline.getTextAreaBaseline((JTextArea)jComponent, n2);
            }
            if (string == "FormattedTextFieldUI" || string == "PasswordFieldUI" || string == "TextFieldUI") {
                n3 = Baseline.getSingleLineTextBaseline((JTextComponent)jComponent, n2);
            } else if (string == "LabelUI") {
                n3 = Baseline.getLabelBaseline((JLabel)jComponent, n2);
            } else if (string == "ListUI") {
                n3 = Baseline.getListBaseline((JList)jComponent, n2);
            } else if (string == "PanelUI") {
                n3 = Baseline.getPanelBaseline((JPanel)jComponent, n2);
            } else if (string == "ProgressBarUI") {
                n3 = Baseline.getProgressBarBaseline((JProgressBar)jComponent, n2);
            } else if (string == "SliderUI") {
                n3 = Baseline.getSliderBaseline((JSlider)jComponent, n2);
            } else if (string == "SpinnerUI") {
                n3 = Baseline.getSpinnerBaseline((JSpinner)jComponent, n2);
            } else if (string == "ScrollPaneUI") {
                n3 = Baseline.getScrollPaneBaseline((JScrollPane)jComponent, n2);
            } else if (string == "TabbedPaneUI") {
                n3 = Baseline.getTabbedPaneBaseline((JTabbedPane)jComponent, n2);
            } else if (string == "TableUI") {
                n3 = Baseline.getTableBaseline((JTable)jComponent, n2);
            } else if (string == "TreeUI") {
                n3 = Baseline.getTreeBaseline((JTree)jComponent, n2);
            }
        }
        return Math.max(n3, -1);
    }

    private static Insets rotateInsets(Insets insets, int n) {
        switch (n) {
            case 2: {
                return new Insets(insets.left, insets.top, insets.right, insets.bottom);
            }
            case 3: {
                return new Insets(insets.bottom, insets.left, insets.top, insets.right);
            }
            case 4: {
                return new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
        }
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private static int getMaxTabHeight(JTabbedPane jTabbedPane) {
        int n;
        int n2 = n = jTabbedPane.getFontMetrics(jTabbedPane.getFont()).getHeight();
        boolean bl = false;
        int n3 = jTabbedPane.getTabCount() - 1;
        while (n3 >= 0) {
            Icon icon = jTabbedPane.getIconAt(n3);
            if (icon != null) {
                int n4 = icon.getIconHeight();
                n2 = Math.max(n2, n4);
                if (n4 > n) {
                    bl = true;
                }
            }
            --n3;
        }
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        n2 += 2;
        if (!Baseline.isMetal() || !bl) {
            n2 += insets.top + insets.bottom;
        }
        return n2;
    }

    private static int getTabbedPaneBaseline(JTabbedPane jTabbedPane, int n) {
        if (jTabbedPane.getTabCount() > 0) {
            if (Baseline.isAqua()) {
                return Baseline.getAquaTabbedPaneBaseline(jTabbedPane, n);
            }
            Insets insets = jTabbedPane.getInsets();
            UIManager.getInsets("TabbedPane.contentBorderInsets");
            Insets insets2 = Baseline.rotateInsets(UIManager.getInsets("TabbedPane.tabAreaInsets"), jTabbedPane.getTabPlacement());
            FontMetrics fontMetrics = jTabbedPane.getFontMetrics(jTabbedPane.getFont());
            int n2 = Baseline.getMaxTabHeight(jTabbedPane);
            iconRect.setBounds(0, 0, 0, 0);
            textRect.setBounds(0, 0, 0, 0);
            viewRect.setBounds(0, 0, Short.MAX_VALUE, n2);
            SwingUtilities.layoutCompoundLabel(jTabbedPane, fontMetrics, "A", null, 0, 0, 0, 11, viewRect, iconRect, textRect, 0);
            int n3 = Baseline.textRect.y + fontMetrics.getAscent();
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    n3 += insets.top + insets2.top;
                    if (Baseline.isWindows()) {
                        n3 = jTabbedPane.getTabCount() > 1 ? ++n3 : --n3;
                    }
                    return n3;
                }
                case 3: {
                    n3 = jTabbedPane.getHeight() - insets.bottom - insets2.bottom - n2 + n3;
                    if (Baseline.isWindows()) {
                        n3 = jTabbedPane.getTabCount() > 1 ? --n3 : ++n3;
                    }
                    return n3;
                }
                case 2: 
                case 4: {
                    if (Baseline.isAqua()) {
                        return -1;
                    }
                    n3 += insets.top + insets2.top;
                    if (Baseline.isWindows()) {
                        n3 += n2 % 2;
                    }
                    return n3;
                }
            }
        }
        return -1;
    }

    private static int getAquaTabbedPaneBaseline(JTabbedPane jTabbedPane, int n) {
        Font font = jTabbedPane.getFont();
        FontMetrics fontMetrics = jTabbedPane.getFontMetrics(font);
        int n2 = fontMetrics.getAscent();
        switch (jTabbedPane.getTabPlacement()) {
            case 1: {
                int n3 = 5;
                if (jTabbedPane.getFont().getSize() > 12) {
                    n3 = 6;
                }
                int n4 = 20 - fontMetrics.getHeight();
                return n3 + (n4 /= 2) + n2 - 1;
            }
            case 3: {
                int n5 = jTabbedPane.getFont().getSize() > 12 ? 6 : 4;
                return n - (20 - ((20 - fontMetrics.getHeight()) / 2 + n2)) - n5;
            }
            case 2: 
            case 4: {
                return -1;
            }
        }
        return -1;
    }

    private static int getSliderBaseline(JSlider jSlider, int n) {
        if (jSlider.getPaintLabels() && !Baseline.isGTK()) {
            Integer n2;
            boolean bl = Baseline.isAqua();
            FontMetrics fontMetrics = jSlider.getFontMetrics(jSlider.getFont());
            Insets insets = jSlider.getInsets();
            Insets insets2 = (Insets)UIManager.get("Slider.focusInsets");
            if (jSlider.getOrientation() == 0) {
                int n3;
                int n4;
                int n5 = 8;
                int n6 = n - insets.top - insets.bottom - insets2.top - insets2.bottom;
                int n7 = 20;
                if (Baseline.isMetal()) {
                    n5 = (Integer)UIManager.get("Slider.majorTickLength") + 5;
                    n7 = UIManager.getIcon("Slider.horizontalThumbIcon").getIconHeight();
                } else if (Baseline.isWindows() && Baseline.isXP()) {
                    ++n7;
                }
                int n8 = n7;
                if (bl || jSlider.getPaintTicks()) {
                    n8 += n5;
                }
                int n9 = insets.top + insets2.top + (n6 - (n8 += fontMetrics.getAscent() + fontMetrics.getDescent()) - 1) / 2;
                if (bl) {
                    if (jSlider.getPaintTicks()) {
                        n4 = jSlider.getUI().getPreferredSize((JComponent)jSlider).height;
                        n3 = n - n4;
                        if (n3 > 0) {
                            n9 -= Math.min(1, n3);
                        }
                    } else {
                        --n9;
                    }
                }
                n4 = n7;
                n3 = n9 + n4;
                int n10 = n5;
                if (!bl && !jSlider.getPaintTicks()) {
                    n10 = 0;
                }
                int n11 = n3 + n10;
                return n11 + fontMetrics.getAscent();
            }
            boolean bl2 = jSlider.getInverted();
            Integer n12 = n2 = bl2 ? Baseline.getMinSliderValue(jSlider) : Baseline.getMaxSliderValue(jSlider);
            if (n2 != null) {
                int n13 = 11;
                if (Baseline.isMetal()) {
                    n13 = UIManager.getIcon("Slider.verticalThumbIcon").getIconHeight();
                }
                int n14 = Math.max(fontMetrics.getHeight() / 2, n13 / 2);
                int n15 = insets2.top + insets.top;
                int n16 = n15 + n14;
                int n17 = n - insets2.top - insets2.bottom - insets.top - insets.bottom - n14 - n14;
                Baseline.getMaxSliderValue(jSlider).intValue();
                int n18 = jSlider.getMinimum();
                int n19 = jSlider.getMaximum();
                double d = (double)n19 - (double)n18;
                double d2 = (double)n17 / d;
                int n20 = n16 + (n17 - 1);
                if (bl) {
                    n16 -= 3;
                    n20 += 6;
                }
                int n21 = n16;
                double d3 = !bl2 ? d2 * ((double)n19 - (double)n2.intValue()) : d2 * ((double)n2.intValue() - (double)n18);
                n21 = bl ? (int)((double)n21 + Math.floor(d3)) : (int)((long)n21 + Math.round(d3));
                n21 = Math.max(n16, n21);
                n21 = Math.min(n20, n21);
                if (bl) {
                    return n21 + fontMetrics.getAscent();
                }
                return n21 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
            }
        }
        return -1;
    }

    private static Integer getMaxSliderValue(JSlider jSlider) {
        Dictionary dictionary = jSlider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = jSlider.getMinimum() - 1;
            while (enumeration.hasMoreElements()) {
                n = Math.max(n, (Integer)enumeration.nextElement());
            }
            if (n == jSlider.getMinimum() - 1) {
                return null;
            }
            return new Integer(n);
        }
        return null;
    }

    private static Integer getMinSliderValue(JSlider jSlider) {
        Dictionary dictionary = jSlider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = jSlider.getMaximum() + 1;
            while (enumeration.hasMoreElements()) {
                n = Math.min(n, (Integer)enumeration.nextElement());
            }
            if (n == jSlider.getMaximum() + 1) {
                return null;
            }
            return new Integer(n);
        }
        return null;
    }

    private static int getProgressBarBaseline(JProgressBar jProgressBar, int n) {
        if (jProgressBar.isStringPainted() && jProgressBar.getOrientation() == 0) {
            FontMetrics fontMetrics = jProgressBar.getFontMetrics(jProgressBar.getFont());
            Insets insets = jProgressBar.getInsets();
            int n2 = insets.top;
            if (Baseline.isWindows() && Baseline.isXP()) {
                if (jProgressBar.isIndeterminate()) {
                    n2 = -1;
                    --n;
                } else {
                    n2 = 0;
                    n -= 3;
                }
            } else {
                if (Baseline.isGTK()) {
                    return (n - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
                }
                if (Baseline.isAqua()) {
                    if (jProgressBar.isIndeterminate()) {
                        return -1;
                    }
                    --n2;
                    n -= insets.top + insets.bottom;
                } else {
                    n -= insets.top + insets.bottom;
                }
            }
            return n2 + (n + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
        }
        return -1;
    }

    private static int getTreeBaseline(JTree jTree, int n) {
        int n2 = jTree.getRowHeight();
        if (TREE_LABEL == null) {
            TREE_LABEL = new JLabel("X");
            TREE_LABEL.setIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        JLabel jLabel = TREE_LABEL;
        jLabel.setFont(jTree.getFont());
        if (n2 <= 0) {
            n2 = jLabel.getPreferredSize().height;
        }
        return Baseline.getLabelBaseline(jLabel, n2) + jTree.getInsets().top;
    }

    private static int getTableBaseline(JTable jTable, int n) {
        if (TABLE_LABEL == null) {
            TABLE_LABEL = new JLabel("");
            TABLE_LABEL.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        JLabel jLabel = TABLE_LABEL;
        jLabel.setFont(jTable.getFont());
        int n2 = jTable.getRowMargin();
        int n3 = Baseline.getLabelBaseline(jLabel, jTable.getRowHeight() - n2);
        return n3 += n2 / 2;
    }

    private static int getTextAreaBaseline(JTextArea jTextArea, int n) {
        Insets insets = jTextArea.getInsets();
        FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
        return insets.top + fontMetrics.getAscent();
    }

    private static int getListBaseline(JList jList, int n) {
        int n2 = jList.getFixedCellHeight();
        if (LIST_LABEL == null) {
            LIST_LABEL = new JLabel("X");
            LIST_LABEL.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        JLabel jLabel = LIST_LABEL;
        jLabel.setFont(jList.getFont());
        if (n2 == -1) {
            n2 = jLabel.getPreferredSize().height;
        }
        return Baseline.getLabelBaseline(jLabel, n2) + jList.getInsets().top;
    }

    private static int getScrollPaneBaseline(JScrollPane jScrollPane, int n) {
        int n2;
        Component component = jScrollPane.getViewport().getView();
        if (component instanceof JComponent && (n2 = Baseline.getBaseline((JComponent)component)) > 0) {
            return n2 + jScrollPane.getViewport().getY();
        }
        return -1;
    }

    private static int getPanelBaseline(JPanel jPanel, int n) {
        TitledBorder titledBorder;
        Border border = jPanel.getBorder();
        if (border instanceof TitledBorder && (titledBorder = (TitledBorder)border).getTitle() != null && !"".equals(titledBorder.getTitle())) {
            Border border2;
            Font font = titledBorder.getTitleFont();
            if (font == null && (font = jPanel.getFont()) == null) {
                font = new Font("Dialog", 0, 12);
            }
            Insets insets = (border2 = titledBorder.getBorder()) != null ? border2.getBorderInsets(jPanel) : EMPTY_INSETS;
            FontMetrics fontMetrics = jPanel.getFontMetrics(font);
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getDescent();
            int n4 = fontMetrics.getAscent();
            int n5 = 2;
            int n6 = n - 4;
            switch (((TitledBorder)border).getTitlePosition()) {
                case 1: {
                    int n7 = n4 + n3 + (Math.max(2, 4) - 2);
                    return n5 + n7 - (n3 + 2);
                }
                case 0: 
                case 2: {
                    int n8 = Math.max(0, n4 / 2 + 2 - 2);
                    return n5 + n8 - n3 + (insets.top + n4 + n3) / 2;
                }
                case 3: {
                    return n5 + insets.top + n4 + 2;
                }
                case 4: {
                    return n5 + n6 - (insets.bottom + n3 + 2);
                }
                case 5: {
                    return n5 + (n6 -= n2 / 2) - n3 + (n4 + n3 - insets.bottom) / 2;
                }
                case 6: {
                    return n5 + (n6 -= n2) + n4 + 2;
                }
            }
        }
        return -1;
    }

    private static int getSpinnerBaseline(JSpinner jSpinner, int n) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = jSpinner.getInsets();
            Insets insets2 = defaultEditor.getInsets();
            int n2 = insets.top + insets2.top;
            if ((n -= n2 + insets.bottom + insets2.bottom) <= 0) {
                return -1;
            }
            return n2 + Baseline.getSingleLineTextBaseline(jFormattedTextField, n);
        }
        Insets insets = jSpinner.getInsets();
        FontMetrics fontMetrics = jSpinner.getFontMetrics(jSpinner.getFont());
        return insets.top + fontMetrics.getAscent();
    }

    private static int getLabelBaseline(JLabel jLabel, int n) {
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        Baseline.resetRects(jLabel, n);
        SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, "a", icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), viewRect, iconRect, textRect, jLabel.getIconTextGap());
        return Baseline.textRect.y + fontMetrics.getAscent();
    }

    private static int getComboBoxBaseline(JComboBox jComboBox, int n) {
        Serializable serializable;
        Object object;
        Insets insets = jComboBox.getInsets();
        int n2 = insets.top;
        n -= insets.top + insets.bottom;
        if (jComboBox.isEditable() && (object = jComboBox.getEditor()) != null && object.getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)object.getEditorComponent();
            return n2 + Baseline.getSingleLineTextBaseline(jTextField, n);
        }
        if (Baseline.isMetal()) {
            if (Baseline.isOceanTheme()) {
                n2 += 2;
                n -= 4;
            }
        } else if (Baseline.isWindows() && (object = System.getProperty("os.version")) != null && (double)((Float)(serializable = Float.valueOf((String)object))).floatValue() > 4.0) {
            n2 += 2;
            n -= 4;
        }
        if ((object = jComboBox.getRenderer()) instanceof JLabel) {
            int n3 = n2 + Baseline.getLabelBaseline((JLabel)object, n);
            if (Baseline.isAqua()) {
                return n3 - 1;
            }
            return n3;
        }
        serializable = jComboBox.getFontMetrics(jComboBox.getFont());
        return n2 + ((FontMetrics)serializable).getAscent();
    }

    private static int getSingleLineTextBaseline(JTextComponent jTextComponent, int n) {
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        if (view.getViewCount() > 0) {
            Insets insets = jTextComponent.getInsets();
            int n2 = n - insets.top - insets.bottom;
            int n3 = insets.top;
            View view2 = view.getView(0);
            int n4 = (int)view2.getPreferredSpan(1);
            if (n2 != n4) {
                int n5 = n2 - n4;
                n3 += n5 / 2;
            }
            FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
            return n3 += fontMetrics.getAscent();
        }
        return -1;
    }

    private static int getButtonBaseline(AbstractButton abstractButton, int n) {
        FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
        Baseline.resetRects(abstractButton, n);
        String string = abstractButton.getText();
        if (string != null && string.startsWith("<html>")) {
            return -1;
        }
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, "a", abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, string == null ? 0 : abstractButton.getIconTextGap());
        if (Baseline.isAqua()) {
            return Baseline.textRect.y + fontMetrics.getAscent() + 1;
        }
        return Baseline.textRect.y + fontMetrics.getAscent();
    }

    private static void resetRects(JComponent jComponent, int n) {
        Insets insets = jComponent.getInsets();
        Baseline.viewRect.x = insets.left;
        Baseline.viewRect.y = insets.top;
        Baseline.viewRect.width = jComponent.getWidth() - (insets.right + Baseline.viewRect.x);
        Baseline.viewRect.height = n - (insets.bottom + Baseline.viewRect.y);
        Baseline.textRect.height = 0;
        Baseline.textRect.width = 0;
        Baseline.textRect.y = 0;
        Baseline.textRect.x = 0;
        Baseline.iconRect.height = 0;
        Baseline.iconRect.width = 0;
        Baseline.iconRect.y = 0;
        Baseline.iconRect.x = 0;
    }

    private static boolean isOceanTheme() {
        if (!inSandbox) {
            try {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Field field = clazz.getDeclaredField("currentTheme");
                field.setAccessible(true);
                Object object = field.get(null);
                return "javax.swing.plaf.metal.OceanTheme".equals(object.getClass().getName());
            }
            catch (Exception exception) {
                inSandbox = true;
            }
        }
        if (!checkedForOcean) {
            checkedForOcean = true;
            Baseline.checkForOcean();
        }
        return usingOcean;
    }

    private static void checkForOcean() {
        String string;
        int n;
        String string2;
        String string3 = System.getProperty("java.specification.version");
        int n2 = string3.indexOf(46);
        if (n2 != -1) {
            string2 = string3.substring(0, n2);
            n = string3.indexOf(46, n2 + 1);
            string = n == -1 ? string3.substring(n2 + 1) : string3.substring(n2 + 1, n);
        } else {
            string2 = string3;
            string = null;
        }
        try {
            n = Integer.parseInt(string2);
            int n3 = string != null ? Integer.parseInt(string) : 0;
            usingOcean = n > 1 || n3 > 4;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static boolean isWindows() {
        return Baseline.isWindows(UIManager.getLookAndFeel());
    }

    private static boolean isWindows(LookAndFeel lookAndFeel) {
        if (lookAndFeel.getID() == "Windows") {
            return true;
        }
        if (!checkedForWindows) {
            try {
                WINDOWS_CLASS = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            checkedForWindows = true;
        }
        return WINDOWS_CLASS != null && WINDOWS_CLASS.isInstance(lookAndFeel);
    }

    private static boolean isMetal() {
        return Baseline.isMetal(UIManager.getLookAndFeel());
    }

    private static boolean isMetal(LookAndFeel lookAndFeel) {
        return lookAndFeel.getID() == "Metal" || lookAndFeel instanceof MetalLookAndFeel;
    }

    private static boolean isGTK() {
        return UIManager.getLookAndFeel().getID() == "GTK";
    }

    private static boolean isAqua() {
        return UIManager.getLookAndFeel().getID() == "Aqua";
    }

    private static boolean isXP() {
        if (!checkedForClassic) {
            try {
                CLASSIC_WINDOWS = Class.forName("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            checkedForClassic = true;
        }
        if (CLASSIC_WINDOWS != null && CLASSIC_WINDOWS.isInstance(UIManager.getLookAndFeel())) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean bl = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    protected Baseline() {
    }

    public int getComponentBaseline(JComponent jComponent, int n, int n2) {
        return -1;
    }
}

