/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.parser;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import net.sourceforge.helpgui.gui.HelpView;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.page.PageRoot;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLParser
extends DefaultHandler {
    MutableTreeNode parent;
    DefaultTreeModel model;

    public XMLParser(HelpView helpView) {
        this.parent = (MutableTreeNode)helpView.getJTree().getModel().getRoot();
        this.model = (DefaultTreeModel)helpView.getJTree().getModel();
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String text = null;
        String image = null;
        String target = null;
        boolean home = false;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String aName = attrs.getQName(i);
                if (qName.equals("tocitem")) {
                    if (aName == "text") {
                        text = attrs.getValue(i);
                    } else if (aName == "image") {
                        image = attrs.getValue(i);
                    } else if (aName == "target") {
                        target = attrs.getValue(i);
                    } else if (aName == "home") {
                        home = attrs.getValue(i).equals("true");
                    }
                }
                ++i;
            }
        }
        if (qName.equals("tocitem")) {
            Page node = null;
            if (this.parent instanceof Page) {
                node = new Page(text, image, target, home, (Page)this.parent);
            } else if (this.parent instanceof PageRoot) {
                node = new Page(text, image, target, home, (PageRoot)this.parent);
            }
            this.model.insertNodeInto(node, this.parent, this.parent.getChildCount());
            this.parent = node;
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("tocitem")) {
            this.parent = (MutableTreeNode)this.parent.getParent();
        }
    }
}

