/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.helpgui.gui.MainFrame;
import net.sourceforge.helpgui.gui.TextArea;
import net.sourceforge.helpgui.gui.TreeRenderer;
import net.sourceforge.helpgui.page.LinkedPage;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.page.PageRoot;
import net.sourceforge.helpgui.util.BrowserControl;
import net.sourceforge.helpgui.util.Out;

public class HelpView
extends JPanel
implements MouseListener,
HyperlinkListener {
    private JTree tree;
    private TextArea textarea;
    private DefaultTreeModel model;
    private PageRoot pageRoot;
    LinkedPage linkedPage = new LinkedPage();

    public HelpView() {
        this.pageRoot = new PageRoot();
        this.model = new DefaultTreeModel(this.pageRoot);
        this.tree = new JTree(this.model);
        this.textarea = new TextArea();
        this.textarea.addHyperlinkListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRowHeight(20);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new TreeRenderer());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setPreferredSize(new Dimension(180, 550));
        JScrollPane textAreaScrollPane = new JScrollPane(this.textarea);
        textAreaScrollPane.setPreferredSize(new Dimension(470, 550));
        JSplitPane splitPane = new JSplitPane(1, treeScrollPane, textAreaScrollPane);
        splitPane.setOneTouchExpandable(true);
        GridBagLayout gbPanel = new GridBagLayout();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        this.setLayout(gbPanel);
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        gbcPanel.gridwidth = 1;
        gbcPanel.gridheight = 1;
        gbcPanel.fill = 1;
        gbcPanel.weightx = 1.0;
        gbcPanel.weighty = 1.0;
        gbcPanel.anchor = 10;
        gbPanel.setConstraints(splitPane, gbcPanel);
        this.add(splitPane);
        this.tree.addMouseListener(this);
    }

    public JTree getJTree() {
        return this.tree;
    }

    public TextArea getTextArea() {
        return this.textarea;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.updateTreeSelection(e);
    }

    public void updateTreeSelection(MouseEvent e) {
        int selectedRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (selectedRow != -1) {
            this.tree.setSelectionRow(selectedRow);
            TreePath path = this.tree.getSelectionPath();
            this.updatePage((Page)path.getLastPathComponent(), true);
        } else {
            this.tree.clearSelection();
        }
    }

    public void goHome() {
        if (!this.goHomePage(this.pageRoot.children())) {
            Out.msg("Be carreful you've any Home page defined");
        }
    }

    private boolean goHomePage(Enumeration e) {
        while (e.hasMoreElements()) {
            Page page = (Page)e.nextElement();
            if (page.getHome()) {
                this.updatePage(page, true);
                return true;
            }
            if (!this.goHomePage(page.children())) continue;
            return true;
        }
        return false;
    }

    public void firstNodeExpand() {
        Page firstChild = this.pageRoot.getFirstChild();
        if (firstChild != null) {
            Enumeration e = firstChild.children();
            while (e.hasMoreElements()) {
                Page child = (Page)e.nextElement();
                Object[] path = new Object[]{this.pageRoot, firstChild, child};
                this.tree.scrollPathToVisible(new TreePath(path));
            }
        }
    }

    public void previousPage() {
        this.updatePage(this.linkedPage.getPreviousPage(), false);
    }

    public void nextPage() {
        this.updatePage(this.linkedPage.getNextPage(), false);
    }

    public Page getCurrentPage() {
        return this.linkedPage.getCurrentPage();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getURL().toString();
            if (url.startsWith("http://") || url.startsWith("mailto:")) {
                BrowserControl.displayURL(url);
            } else {
                int ind = url.lastIndexOf(33);
                url = url.substring(ind + 1, url.length());
                url = url.replaceFirst(MainFrame.helpPath + "/", "");
                this.updatePage(this.getLinkedPage(this.pageRoot.children(), url), true);
            }
        }
    }

    private Page getLinkedPage(Enumeration e, String url) {
        while (e.hasMoreElements()) {
            Page page = (Page)e.nextElement();
            if (page.getTarget() != null && page.getTarget().equals(url)) {
                return page;
            }
            Page p = this.getLinkedPage(page.children(), url);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public void updatePage(Page page, boolean insert) {
        if (page == null) {
            return;
        }
        this.linkedPage.addPage(page, insert);
        this.textarea.update(page);
        this.tree.setSelectionPath(page.getPath());
    }

    public void print() {
        block2: {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this.textarea);
            if (!printJob.printDialog()) break block2;
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

