/*
 * Decompiled with CFR 0.152.
 */
package jaolho.data.lma.implementations;

import jaolho.data.lma.LMA;
import jaolho.data.lma.LMAFunction;
import java.util.Arrays;

public class TestFunctions {
    public static LMAFunction sin = new LMAFunction(){

        @Override
        public double getY(double d, double[] dArray) {
            return dArray[0] * Math.sin(d / dArray[1]);
        }

        @Override
        public double getPartialDerivate(double d, double[] dArray, int n) {
            switch (n) {
                case 0: {
                    return Math.sin(d / dArray[1]);
                }
                case 1: {
                    return dArray[0] * Math.cos(d / dArray[1]) * (-d / (dArray[1] * dArray[1]));
                }
            }
            throw new RuntimeException("No such fit parameter: " + n);
        }
    };

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.0, 0.1, 0.2, 0.3, 0.5, 0.7};
        double[] dArray2 = new double[]{2.2, 0.4};
        double[][] dArrayArray = new double[][]{dArray, sin.generateData(dArray, dArray2)};
        LMA lMA = new LMA(sin, new double[]{0.1, 10.0}, dArrayArray, null);
        lMA.fit();
        System.out.println("RESULT PARAMETERS: " + Arrays.toString(lMA.parameters));
    }
}

