/*
 * Decompiled with CFR 0.152.
 */
package jaolho.data.lma.implementations;

import Jama.Matrix;
import jaolho.data.lma.LMAMatrix;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;

public class JAMAMatrix
extends Matrix
implements LMAMatrix {
    private static final long serialVersionUID = -8925816623803983503L;

    public JAMAMatrix(double[][] dArray) {
        super(dArray);
    }

    public JAMAMatrix(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void invert() throws LMAMatrix.InvertException {
        try {
            Matrix matrix = this.inverse();
            this.setMatrix(0, this.getRowDimension() - 1, 0, this.getColumnDimension() - 1, matrix);
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(runtimeException.getMessage());
            printWriter.println("Inversion failed for matrix:");
            this.print(printWriter, NumberFormat.getInstance(), 5);
            throw new LMAMatrix.InvertException(stringWriter.toString());
        }
    }

    @Override
    public void setElement(int n, int n2, double d) {
        this.set(n, n2, d);
    }

    @Override
    public double getElement(int n, int n2) {
        return this.get(n, n2);
    }

    @Override
    public void multiply(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.getRowDimension(); ++i) {
            dArray2[i] = 0.0;
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + this.getElement(i, j) * dArray[j];
            }
        }
    }

    public static void main(String[] stringArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("jakkajaaa");
        System.out.println(stringWriter);
    }
}

