/*
 * Decompiled with CFR 0.152.
 */
package io;

import components.BeamAnalyzer;
import components.Cavity;
import components.Component;
import components.Lens;
import components.Material;
import components.PartialBeam;
import components.Substrate;
import components.TextLabel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import utils.CavitySet;
import utils.ComponentSet;
import utils.JamMtException;
import utils.Settings;

public class XmlDoc {
    private Settings sets;
    private String fname;
    private boolean create;
    private Document doc;
    private Element root;

    public XmlDoc(String fname, boolean create) throws JamMtException {
        this.fname = fname;
        this.create = create;
        this.sets = new Settings();
        if (create) {
            this.doc = new Document(new Element("JamMt"));
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                this.doc = builder.build(new File(fname));
            }
            catch (JDOMException e) {
                throw new JamMtException("Error while parsing file '" + fname + "'");
            }
            catch (IOException ex) {
                throw new JamMtException("File not found '" + fname + "'");
            }
        }
        this.root = this.doc.getRootElement();
        if (create) {
            this.root.addContent(new Comment("This file was automatically created by JamMt"));
        }
    }

    public void writeSettings(Settings sets) {
        this.sets = sets;
        this.writeBeam(sets.beam.getInitialBeam());
        this.writeLensSet(sets.components.getLenses(), "LSdisp");
        this.writeLensSet(sets.defaultLenses.getLenses(), "LSavail");
        this.writeLensSet(sets.fittingLenses.getLenses(), "LSfit");
        this.writeAnalyzerSet(sets.components.getBeamAnalyzer());
        this.writeTextLabelSet(sets.components.getTextLabel());
        this.writeCavitySet(sets.CSdisp.getCavities(), "CSdisp");
        this.writeCavitySet(sets.defaultCavities.getCavities(), "CSavail");
        this.writeMaterials(sets.materials);
        this.writeSimpleFields(sets);
    }

    private void writeBeam(PartialBeam b) {
        Element beam = new Element("Beam");
        beam.setAttribute("w0x", "" + b.getWaistSize("x"));
        beam.setAttribute("z0x", "" + b.getWaistPosition("x"));
        beam.setAttribute("w0y", "" + b.getWaistSize("y"));
        beam.setAttribute("z0y", "" + b.getWaistPosition("y"));
        beam.setAttribute("lambda", "" + b.getWaveLength());
        this.root.addContent(beam);
    }

    private void writeTextLabelSet(ArrayList<TextLabel> set) {
        Element textlabel = new Element("TextLabelSet");
        for (TextLabel label : set) {
            Element lab = new Element("TextLabel");
            lab.setAttribute("Name", label.getName());
            lab.setAttribute("Label", label.getLabel().replace("\n", "\\n"));
            lab.setAttribute("gid", "" + label.getGroupID());
            lab.setAttribute("z", "" + label.getPosition());
            textlabel.addContent(lab);
        }
        this.root.addContent(textlabel);
    }

    private void writeAnalyzerSet(ArrayList<BeamAnalyzer> set) {
        Element analyzer = new Element("AnalyzerSet");
        for (BeamAnalyzer ba : set) {
            Element ana = new Element("Analyzer");
            ana.setAttribute("Name", ba.getName());
            ana.setAttribute("gid", "" + ba.getGroupID());
            ana.setAttribute("z", "" + ba.getPosition());
            analyzer.addContent(ana);
        }
        this.root.addContent(analyzer);
    }

    public void writeLensSet(ArrayList<Lens> set, String name) {
        Element lenses = new Element("LensSet");
        lenses.setAttribute("Name", name);
        for (Lens l : set) {
            if (l.isCavityComponent()) continue;
            if (l instanceof Substrate) {
                Element sub = new Element("Substrate");
                Substrate s = (Substrate)l;
                sub.setAttribute("Name", s.getName());
                sub.setAttribute("z", "" + s.getPosition());
                sub.setAttribute("n", "" + s.getIndexOfRefraction());
                sub.setAttribute("a", "" + s.getAperture());
                sub.setAttribute("d", "" + s.getThickness());
                sub.setAttribute("gid", "" + s.getGroupID());
                sub.setAttribute("R1x", "" + s.getLeftRoc("x"));
                sub.setAttribute("R2x", "" + s.getRightRoc("x"));
                sub.setAttribute("R1y", "" + s.getLeftRoc("y"));
                sub.setAttribute("R2y", "" + s.getRightRoc("y"));
                sub.setAttribute("angle", "" + s.getAngleInDegrees());
                sub.setAttribute("mirror", "" + s.getMirror());
                sub.setAttribute("coating", "" + s.getCoating());
                if (s.getMaterial() != null) {
                    sub.setAttribute("Material", "" + s.getMaterial().getName());
                }
                lenses.addContent(sub);
                continue;
            }
            Element lens = new Element("Lens");
            lens.setAttribute("Name", l.getName());
            lens.setAttribute("z", "" + l.getPosition());
            try {
                lens.setAttribute("fx", "" + l.getFocalLength("x"));
                lens.setAttribute("fy", "" + l.getFocalLength("y"));
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            lens.setAttribute("a", "" + l.getAperture());
            lens.setAttribute("d", "" + l.getThickness());
            lens.setAttribute("gid", "" + l.getGroupID());
            lenses.addContent(lens);
        }
        this.root.addContent(lenses);
    }

    private void writeCavitySet(Vector<Cavity> set, String name) {
        Element cavities = new Element("CavitySet");
        cavities.setAttribute("Name", name);
        for (Cavity cav : set) {
            Element cavity = new Element("Cavity");
            cavity.setAttribute("Name", cav.getName());
            try {
                cavity.setAttribute("Ref1", cav.getEndMirror("left").getCoating());
                cavity.setAttribute("Ref2", cav.getEndMirror("right").getCoating());
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            cavity.setAttribute("Group", "" + cav.isGrouped());
            for (Lens l : cav.getComponents().getLenses()) {
                if (l instanceof Substrate) {
                    Element sub = new Element("Substrate");
                    Substrate s = (Substrate)l;
                    sub.setAttribute("Name", s.getName());
                    sub.setAttribute("z", "" + s.getPosition());
                    sub.setAttribute("n", "" + s.getIndexOfRefraction());
                    sub.setAttribute("a", "" + s.getAperture());
                    sub.setAttribute("d", "" + s.getThickness());
                    sub.setAttribute("gid", "" + s.getGroupID());
                    sub.setAttribute("R1x", "" + s.getLeftRoc("x"));
                    sub.setAttribute("R2x", "" + s.getRightRoc("x"));
                    sub.setAttribute("R1y", "" + s.getLeftRoc("y"));
                    sub.setAttribute("R2y", "" + s.getRightRoc("y"));
                    sub.setAttribute("angle", "" + s.getAngleInDegrees());
                    sub.setAttribute("mirror", "" + s.getMirror());
                    sub.setAttribute("coating", "" + s.getCoating());
                    if (s.getMaterial() != null) {
                        sub.setAttribute("Material", "" + s.getMaterial().getName());
                    }
                    cavity.addContent(sub);
                    continue;
                }
                Element lens = new Element("Lens");
                lens.setAttribute("Name", l.getName());
                lens.setAttribute("z", "" + l.getPosition());
                try {
                    lens.setAttribute("fx", "" + l.getFocalLength("x"));
                    lens.setAttribute("fy", "" + l.getFocalLength("y"));
                }
                catch (JamMtException je) {
                    Logger.getLogger("JamMt").severe(je.toString());
                }
                lens.setAttribute("a", "" + l.getAperture());
                lens.setAttribute("d", "" + l.getThickness());
                lens.setAttribute("gid", "" + l.getGroupID());
                cavity.addContent(lens);
            }
            cavities.addContent(cavity);
        }
        this.root.addContent(cavities);
    }

    private void writeSimpleFields(Settings s) {
        Element sets = new Element("Settings");
        Element yAxis = new Element("yAxis");
        Element y2Axis = new Element("y2Axis");
        Element autoScale = new Element("autoScale");
        Element xMin = new Element("xMin");
        Element xMax = new Element("xMax");
        Element yMin = new Element("yMin");
        Element yMax = new Element("yMax");
        Element y2Min = new Element("y2Min");
        Element y2Max = new Element("y2Max");
        Element xRes = new Element("xRes");
        Element info = new Element("info");
        Element showTan = new Element("showTan");
        Element rotate = new Element("rotate");
        Element colortheme = new Element("colortheme");
        Element openPath = new Element("openPath");
        Element savePath = new Element("savePath");
        Element dataPath = new Element("dataPath");
        Element exportPath = new Element("exportPath");
        Element dx_min = new Element("dx_min");
        Element single_lens_use = new Element("single_lens_use");
        Element right_focus = new Element("right_focus");
        Element lens_overlap = new Element("lens_overlap");
        Element nearby_solution = new Element("nearby_solution");
        Element target_w0 = new Element("target_w0");
        Element target_z0_min = new Element("target_z0_min");
        Element target_z0_max = new Element("target_z0_max");
        Element target_w0_y = new Element("target_w0_y");
        Element target_z0_min_y = new Element("target_z0_min_y");
        Element target_z0_max_y = new Element("target_z0_max_y");
        Element shiftingRange_start = new Element("shiftingRange_start");
        Element shiftingRange_end = new Element("shiftingRange_end");
        Element fitVisibility = new Element("fitVisibility");
        Element Nlenses = new Element("Nlenses");
        Element gridSize = new Element("grid_size");
        yAxis.addContent("" + s.yAxis);
        y2Axis.addContent("" + s.y2Axis);
        autoScale.addContent("" + s.autoScale);
        xMin.addContent("" + s.xMin);
        xMax.addContent("" + s.xMax);
        yMin.addContent("" + s.yMin);
        yMax.addContent("" + s.yMax);
        y2Min.addContent("" + s.y2Min);
        y2Max.addContent("" + s.y2Max);
        xRes.addContent("" + s.getResolution());
        info.addContent("" + s.info);
        showTan.addContent("" + s.showTan);
        rotate.addContent("" + s.rotate);
        colortheme.addContent("" + s.colortheme);
        openPath.addContent("" + s.openPath);
        savePath.addContent("" + s.savePath);
        dataPath.addContent("" + s.dataPath);
        exportPath.addContent("" + s.exportPath);
        dx_min.addContent("" + s.dx_min);
        single_lens_use.addContent("" + s.single_lens_use);
        right_focus.addContent("" + s.right_focus);
        lens_overlap.addContent("" + s.lens_overlap);
        nearby_solution.addContent("" + s.nearby_solution);
        target_w0.addContent("" + s.target_w0);
        target_z0_min.addContent("" + s.target_z0_min);
        target_z0_max.addContent("" + s.target_z0_max);
        target_w0_y.addContent("" + s.target_w0_y);
        target_z0_min_y.addContent("" + s.target_z0_min_y);
        target_z0_max_y.addContent("" + s.target_z0_max_y);
        shiftingRange_start.addContent("" + s.shiftingRange_start);
        shiftingRange_end.addContent("" + s.shiftingRange_end);
        fitVisibility.addContent("" + s.fitVisibility);
        Nlenses.addContent("" + s.Nlenses);
        gridSize.addContent("" + s.getGridSize());
        sets.addContent(yAxis);
        sets.addContent(y2Axis);
        sets.addContent(autoScale);
        sets.addContent(xMin);
        sets.addContent(xMax);
        sets.addContent(yMin);
        sets.addContent(yMax);
        sets.addContent(y2Min);
        sets.addContent(y2Max);
        sets.addContent(xRes);
        sets.addContent(info);
        sets.addContent(showTan);
        sets.addContent(rotate);
        sets.addContent(colortheme);
        sets.addContent(openPath);
        sets.addContent(savePath);
        sets.addContent(dataPath);
        sets.addContent(exportPath);
        sets.addContent(dx_min);
        sets.addContent(single_lens_use);
        sets.addContent(right_focus);
        sets.addContent(lens_overlap);
        sets.addContent(nearby_solution);
        sets.addContent(target_w0);
        sets.addContent(target_z0_min);
        sets.addContent(target_z0_max);
        sets.addContent(target_w0_y);
        sets.addContent(target_z0_min_y);
        sets.addContent(target_z0_max_y);
        sets.addContent(shiftingRange_start);
        sets.addContent(shiftingRange_end);
        sets.addContent(fitVisibility);
        sets.addContent(Nlenses);
        sets.addContent(gridSize);
        this.root.addContent(sets);
    }

    public void writeMaterials(ArrayList<Material> mats) {
        for (Material m : mats) {
            Element material = new Element("Material");
            double B1 = m.getCoefficients()[0];
            double B2 = m.getCoefficients()[1];
            double B3 = m.getCoefficients()[2];
            double C1 = m.getCoefficients()[3];
            double C2 = m.getCoefficients()[4];
            double C3 = m.getCoefficients()[5];
            material.setAttribute("Name", m.getName());
            material.setAttribute("B1", "" + B1);
            material.setAttribute("B2", "" + B2);
            material.setAttribute("B3", "" + B3);
            material.setAttribute("C1", "" + C1);
            material.setAttribute("C2", "" + C2);
            material.setAttribute("C3", "" + C3);
            this.root.addContent(material);
        }
    }

    public PartialBeam loadBeam() {
        double w0x = 3.7E-4;
        double w0y = 3.7E-4;
        double z0x = 0.0;
        double z0y = 0.0;
        double lambda = 1.064E-6;
        Element beam = this.root.getChild("Beam");
        try {
            if (beam == null) {
                return new PartialBeam(w0x, z0x, w0y, z0y, lambda);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        Iterator atts = beam.getAttributes().iterator();
        try {
            while (atts.hasNext()) {
                Attribute at = (Attribute)atts.next();
                if (at.getName().equals("w0x")) {
                    w0x = at.getDoubleValue();
                }
                if (at.getName().equals("z0x")) {
                    z0x = at.getDoubleValue();
                }
                if (at.getName().equals("w0y")) {
                    w0y = at.getDoubleValue();
                }
                if (at.getName().equals("z0y")) {
                    z0y = at.getDoubleValue();
                }
                if (!at.getName().equals("lambda")) continue;
                lambda = at.getDoubleValue();
            }
            return new PartialBeam(w0x, z0x, w0y, z0y, lambda);
        }
        catch (Exception e) {
            Logger.getLogger("JamMt").severe(e.toString());
            return null;
        }
    }

    public ArrayList<BeamAnalyzer> loadAnalyzerSet() {
        ArrayList<BeamAnalyzer> balist = new ArrayList<BeamAnalyzer>();
        Iterator it = this.root.getChildren("AnalyzerSet").iterator();
        Element set = null;
        if (!it.hasNext()) {
            return balist;
        }
        set = (Element)it.next();
        it = set.getChildren("Analyzer").iterator();
        while (it.hasNext()) {
            String name = "Beam analyzer";
            double z = 0.0;
            int gid = 0;
            try {
                Element s = (Element)it.next();
                for (Attribute at : s.getAttributes()) {
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("gid")) {
                        gid = at.getIntValue();
                    }
                    if (!at.getName().equals("z")) continue;
                    z = at.getDoubleValue();
                }
                balist.add(new BeamAnalyzer(name, z, gid));
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        }
        return balist;
    }

    public ArrayList<TextLabel> loadTextLabelSet() {
        ArrayList<TextLabel> balist = new ArrayList<TextLabel>();
        Iterator it = this.root.getChildren("TextLabelSet").iterator();
        Element set = null;
        if (!it.hasNext()) {
            return balist;
        }
        set = (Element)it.next();
        it = set.getChildren("TextLabel").iterator();
        while (it.hasNext()) {
            String name = "Text label";
            String label = "";
            double z = 0.0;
            int gid = 0;
            try {
                Element s = (Element)it.next();
                for (Attribute at : s.getAttributes()) {
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("Label")) {
                        label = at.getValue().replace("\\n", "\n");
                    }
                    if (at.getName().equals("gid")) {
                        gid = at.getIntValue();
                    }
                    if (!at.getName().equals("z")) continue;
                    z = at.getDoubleValue();
                }
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
            balist.add(new TextLabel(name, label, z, gid));
        }
        return balist;
    }

    public ArrayList<Component> loadLensSet(String setName, ComponentSet lenses) {
        boolean setFound = false;
        ArrayList<Substrate> subs = this.loadSubstrateSet(setName.replace('L', 'S'));
        if (lenses != null) {
            for (Substrate s : subs) {
                lenses.addComponent(s);
            }
        }
        if (subs.size() != 0) {
            String name = setName.replace('L', 'S');
            String warn = "\n   WARNING: Found old syntax in file!   \n";
            warn = warn + "            The set '" + name + "' is no longer supported!   \n";
            warn = warn + "\n";
            warn = warn + "            Please save the file with this version of JamMt!   \n";
            warn = warn + "\n";
            Logger.getLogger("JamMt").severe(warn);
            setFound = true;
        }
        Iterator it = this.root.getChildren("LensSet").iterator();
        Element set2 = null;
        while (it.hasNext()) {
            set2 = (Element)it.next();
            if (!set2.getAttribute("Name").getValue().equals(setName)) continue;
            setFound = true;
            break;
        }
        if (set2 == null) {
            for (Element set2 : this.root.getChildren("SubstrateSet")) {
                if (!set2.getAttribute("Name").getValue().equals(setName)) continue;
                setFound = true;
                break;
            }
        }
        if (!setFound || set2 == null) {
            return new ArrayList<Component>();
        }
        return this.getLenses(set2).getComponents();
    }

    private ComponentSet getLenses(Element set) {
        double z;
        String name;
        ComponentSet lenses = new ComponentSet();
        Iterator it = set.getChildren("Lens").iterator();
        while (it.hasNext()) {
            name = "Lens";
            z = 0.0;
            double fx = 0.1;
            double fy = 0.1;
            double a = 0.025;
            double d = 0.03;
            int gid = 0;
            try {
                Element l = (Element)it.next();
                for (Attribute at : l.getAttributes()) {
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("z")) {
                        z = at.getDoubleValue();
                    }
                    if (at.getName().equals("f")) {
                        fx = fy = at.getDoubleValue();
                    }
                    if (at.getName().equals("fx")) {
                        fx = at.getDoubleValue();
                    }
                    if (at.getName().equals("fy")) {
                        fy = at.getDoubleValue();
                    }
                    if (at.getName().equals("a")) {
                        a = at.getDoubleValue();
                    }
                    if (at.getName().equals("d")) {
                        d = at.getDoubleValue();
                    }
                    if (!at.getName().equals("gid")) continue;
                    gid = at.getIntValue();
                }
                Lens lens = new Lens(z, fx, fy, a);
                lens.setThickness(d);
                lens.setGroupID(gid);
                lens.setName(name);
                lenses.addComponent(lens);
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        }
        it = set.getChildren("Substrate").iterator();
        while (it.hasNext()) {
            name = "Substrate";
            z = 0.0;
            double n = 1.0;
            double a = 0.025;
            double d = 0.03;
            double R1x = Double.NEGATIVE_INFINITY;
            double R2x = Double.POSITIVE_INFINITY;
            double R1y = Double.NEGATIVE_INFINITY;
            double R2y = Double.POSITIVE_INFINITY;
            double angle = 0.0;
            int mirror = 0;
            String mat = "";
            int gid = 0;
            String coating = "";
            try {
                Element s = (Element)it.next();
                for (Attribute at : s.getAttributes()) {
                    if (at.getName().equals("R1")) {
                        R1x = R1y = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2")) {
                        R2x = R2y = at.getDoubleValue();
                    }
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("z")) {
                        z = at.getDoubleValue();
                    }
                    if (at.getName().equals("n")) {
                        n = at.getDoubleValue();
                    }
                    if (at.getName().equals("a")) {
                        a = at.getDoubleValue();
                    }
                    if (at.getName().equals("d")) {
                        d = at.getDoubleValue();
                    }
                    if (at.getName().equals("gid")) {
                        gid = at.getIntValue();
                    }
                    if (at.getName().equals("R1x")) {
                        R1x = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2x")) {
                        R2x = at.getDoubleValue();
                    }
                    if (at.getName().equals("R1y")) {
                        R1y = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2y")) {
                        R2y = at.getDoubleValue();
                    }
                    if (at.getName().equals("angle")) {
                        angle = at.getDoubleValue();
                    }
                    if (at.getName().equals("mirror")) {
                        mirror = at.getIntValue();
                    }
                    if (at.getName().equals("Material")) {
                        mat = at.getValue();
                    }
                    if (!at.getName().equals("coating")) continue;
                    coating = at.getValue();
                }
                Substrate sub = new Substrate(z, n, d, R1x, R2x, R1y, R2y, a);
                sub.setMaterial(this.getMaterialForName(mat));
                sub.setAngleInDegrees(angle);
                sub.setGroupID(gid);
                sub.setName(name);
                if (!coating.equals("")) {
                    sub.setCoating(coating);
                }
                sub.setMirror(mirror);
                lenses.addComponent(sub);
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        }
        return lenses;
    }

    public ArrayList<Substrate> loadSubstrateSet(String setName) {
        ArrayList<Substrate> subs = new ArrayList<Substrate>();
        boolean setFound = false;
        Iterator it = this.root.getChildren("SubstrateSet").iterator();
        Element set = null;
        while (it.hasNext()) {
            set = (Element)it.next();
            if (!set.getAttribute("Name").getValue().equals(setName)) continue;
            setFound = true;
            break;
        }
        if (!setFound) {
            return new ArrayList<Substrate>();
        }
        it = set.getChildren("Substrate").iterator();
        while (it.hasNext()) {
            String name = "Substrate";
            double z = 0.0;
            double n = 1.0;
            double a = 0.025;
            double d = 0.03;
            double R1x = Double.NEGATIVE_INFINITY;
            double R2x = Double.POSITIVE_INFINITY;
            double R1y = Double.NEGATIVE_INFINITY;
            double R2y = Double.POSITIVE_INFINITY;
            double angle = 0.0;
            String mat = "";
            int gid = 0;
            int mirror = 0;
            String coating = "";
            try {
                Element s = (Element)it.next();
                for (Attribute at : s.getAttributes()) {
                    if (at.getName().equals("R1")) {
                        R1x = R1y = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2")) {
                        R2x = R2y = at.getDoubleValue();
                    }
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("z")) {
                        z = at.getDoubleValue();
                    }
                    if (at.getName().equals("n")) {
                        n = at.getDoubleValue();
                    }
                    if (at.getName().equals("a")) {
                        a = at.getDoubleValue();
                    }
                    if (at.getName().equals("d")) {
                        d = at.getDoubleValue();
                    }
                    if (at.getName().equals("gid")) {
                        gid = at.getIntValue();
                    }
                    if (at.getName().equals("R1x")) {
                        R1x = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2x")) {
                        R2x = at.getDoubleValue();
                    }
                    if (at.getName().equals("R1y")) {
                        R1y = at.getDoubleValue();
                    }
                    if (at.getName().equals("R2y")) {
                        R2y = at.getDoubleValue();
                    }
                    if (at.getName().equals("angle")) {
                        angle = at.getDoubleValue();
                    }
                    if (at.getName().equals("mirror")) {
                        mirror = at.getIntValue();
                    }
                    if (at.getName().equals("Material")) {
                        mat = at.getValue();
                    }
                    if (!at.getName().equals("coating")) continue;
                    coating = at.getValue();
                }
                Substrate sub = new Substrate(z, n, d, R1x, R2x, R1y, R2y, a);
                sub.setMaterial(this.getMaterialForName(mat));
                sub.setAngleInDegrees(angle);
                sub.setGroupID(gid);
                sub.setMirror(mirror);
                sub.setName(name);
                if (!coating.equals("")) {
                    sub.setCoating(coating);
                }
                subs.add(sub);
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        }
        return subs;
    }

    public void loadCavitySet(CavitySet ret, String setName) {
        boolean setFound = false;
        Iterator it = this.root.getChildren("CavitySet").iterator();
        Element set = null;
        while (it.hasNext()) {
            set = (Element)it.next();
            if (!set.getAttribute("Name").getValue().equals(setName)) continue;
            setFound = true;
            break;
        }
        if (!setFound) {
            return;
        }
        it = set.getChildren("Cavity").iterator();
        while (it.hasNext()) {
            String name = "Cavity";
            String ref1 = "right";
            String ref2 = "left";
            boolean group = true;
            Element s = (Element)it.next();
            try {
                for (Attribute at : s.getAttributes()) {
                    if (at.getName().equals("Name")) {
                        name = at.getValue();
                    }
                    if (at.getName().equals("Ref1")) {
                        ref1 = at.getValue();
                    }
                    if (at.getName().equals("Ref2")) {
                        ref2 = at.getValue();
                    }
                    if (!at.getName().equals("Group")) continue;
                    group = at.getBooleanValue();
                }
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
            ComponentSet lenses = new ComponentSet();
            lenses.setComponents(this.getLenses(s).getComponents());
            try {
                Cavity cav = new Cavity(name, lenses, group, ref1, ref2);
                ret.getCavities().add(cav);
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
    }

    public void loadSettings(Settings sets) {
        this.sets = sets;
        try {
            sets.beam.setInitialBeam(this.loadBeam());
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        sets.components.setComponents(this.loadLensSet("LSdisp", sets.components));
        sets.fittingLenses.setComponents(this.loadLensSet("LSfit", sets.fittingLenses));
        sets.defaultLenses.setComponents(this.loadLensSet("LSavail", sets.defaultLenses));
        for (BeamAnalyzer ba : this.loadAnalyzerSet()) {
            ba.setBeam(sets.beam);
            sets.components.addComponent(ba);
        }
        for (TextLabel label : this.loadTextLabelSet()) {
            sets.components.addComponent(label);
        }
        this.loadCavitySet(sets.CSdisp, "CSdisp");
        this.loadCavitySet(sets.defaultCavities, "CSavail");
        this.loadSimpleSettings(sets);
        sets.materials = this.loadMaterials();
    }

    private void loadSimpleSettings(Settings sets) {
        Element e = this.root.getChild("Settings");
        if (e == null) {
            sets = new Settings();
            return;
        }
        for (Element el : e.getChildren()) {
            try {
                if (el.getName().equals("yAxis")) {
                    sets.yAxis = el.getText();
                }
                if (el.getName().equals("y2Axis")) {
                    sets.y2Axis = el.getText();
                }
                if (el.getName().equals("autoScale")) {
                    sets.autoScale = Boolean.parseBoolean(el.getText());
                }
                if (el.getName().equals("xMin")) {
                    sets.xMin = el.getText();
                }
                if (el.getName().equals("xMax")) {
                    sets.xMax = el.getText();
                }
                if (el.getName().equals("yMin")) {
                    sets.yMin = el.getText();
                }
                if (el.getName().equals("yMax")) {
                    sets.yMax = el.getText();
                }
                if (el.getName().equals("y2Min")) {
                    sets.y2Min = el.getText();
                }
                if (el.getName().equals("y2Max")) {
                    sets.y2Max = el.getText();
                }
                if (el.getName().equals("xRes")) {
                    sets.setResolution(Integer.parseInt(el.getText()));
                }
                if (el.getName().equals("info")) {
                    sets.info = Boolean.parseBoolean(el.getText());
                }
                if (el.getName().equals("showTan")) {
                    sets.showTan = Boolean.parseBoolean(el.getText());
                }
                if (el.getName().equals("rotate")) {
                    sets.rotate = Boolean.parseBoolean(el.getText());
                }
                if (el.getName().equals("colortheme")) {
                    sets.colortheme = el.getText();
                }
                if (el.getName().equals("openPath")) {
                    sets.openPath = el.getText();
                }
                if (el.getName().equals("savePath")) {
                    sets.savePath = el.getText();
                }
                if (el.getName().equals("dataPath")) {
                    sets.dataPath = el.getText();
                }
                if (el.getName().equals("exportPath")) {
                    sets.exportPath = el.getText();
                }
                if (el.getName().equals("target_w0")) {
                    sets.target_w0 = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_w0_y")) {
                    sets.target_w0_y = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_z0")) {
                    Logger.getLogger("JamMt").severe("Found old syntax in file!\nPlease save the file again with this new version of JamMt.");
                    sets.target_z0_min = Double.parseDouble(el.getText());
                    sets.target_z0_max = Double.parseDouble(el.getText());
                    sets.target_z0_min_y = Double.parseDouble(el.getText());
                    sets.target_z0_max_y = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_z0_min")) {
                    sets.target_z0_min = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_z0_max")) {
                    sets.target_z0_max = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_z0_min_y")) {
                    sets.target_z0_min_y = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("target_z0_max_y")) {
                    sets.target_z0_max_y = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("shiftingRange_start")) {
                    sets.shiftingRange_start = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("shiftingRange_end")) {
                    sets.shiftingRange_end = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("fitVisibility")) {
                    sets.fitVisibility = Double.parseDouble(el.getText());
                }
                if (el.getName().equals("Nlenses")) {
                    sets.Nlenses = Integer.parseInt(el.getText());
                }
                if (!el.getName().equals("grid_size")) continue;
                sets.setGridSize(Integer.parseInt(el.getText()));
            }
            catch (Exception ex) {
                Logger.getLogger("JamMt").severe(ex.toString());
            }
        }
    }

    public ArrayList<Material> loadMaterials() {
        ArrayList<Material> mats = new ArrayList<Material>();
        double[] bv = new double[]{0.0, 0.0, 0.0};
        double[] cv = new double[]{0.0, 0.0, 0.0};
        String name = "";
        Iterator it = this.root.getChildren("Material").iterator();
        try {
            while (it.hasNext()) {
                Element e = (Element)it.next();
                name = e.getAttribute("Name").getValue();
                bv[0] = e.getAttribute("B1").getDoubleValue();
                bv[1] = e.getAttribute("B2").getDoubleValue();
                bv[2] = e.getAttribute("B3").getDoubleValue();
                cv[0] = e.getAttribute("C1").getDoubleValue();
                cv[1] = e.getAttribute("C2").getDoubleValue();
                cv[2] = e.getAttribute("C3").getDoubleValue();
                mats.add(new Material(name, bv, cv));
            }
        }
        catch (Exception ex) {
            Logger.getLogger("JamMt").severe(ex.toString());
        }
        return mats;
    }

    private Material getMaterialForName(String name) {
        Material mat = null;
        ArrayList<Material> mlist = this.loadMaterials();
        for (Material m : mlist) {
            if (!m.getName().equals(name)) continue;
            mat = m;
            break;
        }
        return mat;
    }

    public void close() {
        if (this.create) {
            try {
                XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                out.output(this.doc, (OutputStream)new FileOutputStream(this.fname));
            }
            catch (Exception e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        }
    }
}

