/*
 * Decompiled with CFR 0.152.
 */
package io;

import gui.MainWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFrame;

public class Print2DtoStream
implements Printable {
    private double llx;
    private double lly;
    private double urx;
    private double ury;
    private JFrame window = MainWindow.getInstance().getMainWnd();

    public Print2DtoStream(String fname) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        if (fname.endsWith(".eps")) {
            flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String MimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, MimeType);
            if (factories.length == 0) {
                Logger.getLogger("JamMt").severe("No suitable output device found!");
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(fname);
                StreamPrintService sps = factories[0].getPrintService(fos);
                DocPrintJob pj = sps.createPrintJob();
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                pj.print(doc, aset);
                fos.close();
                this.fixBoundingBox(fname);
            }
            catch (PrintException pe) {
                Logger.getLogger("JamMt").severe(pe.toString());
            }
            catch (IOException e) {
                Logger.getLogger("JamMt").severe(e.toString());
            }
        } else {
            this.createImage(fname);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        Container cp = this.window.getContentPane();
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pf.getImageableX(), pf.getImageableY());
            double scale = pf.getImageableWidth() / (double)cp.getWidth();
            this.llx = pf.getImageableX();
            this.lly = pf.getHeight() - pf.getImageableY() - scale * (double)cp.getHeight();
            this.urx = pf.getImageableX() + pf.getImageableWidth();
            this.ury = this.lly + scale * (double)cp.getHeight();
            g2.scale(scale, scale);
            ((Component)cp).print(g2);
            return 0;
        }
        return 1;
    }

    private void fixBoundingBox(String fname) throws IOException {
        String zeile;
        FileWriter file = new FileWriter("tmp.ps");
        BufferedReader is = new BufferedReader(new FileReader(fname));
        is.readLine();
        file.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        file.write("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury + "\n");
        while ((zeile = is.readLine()) != null) {
            if (zeile.contains("Deferred")) continue;
            file.write(zeile + "\n");
        }
        file.close();
        is.close();
        new File("tmp.ps").renameTo(new File(fname));
    }

    private void createImage(String fname) {
        Container cp = this.window.getContentPane();
        int iWidth = cp.getWidth();
        int iHeight = cp.getHeight();
        BufferedImage img = new BufferedImage(iWidth, iHeight, 2);
        Graphics2D g2 = img.createGraphics();
        String iFmt = fname.substring(fname.lastIndexOf(46) + 1);
        ((Component)cp).print(g2);
        try {
            ImageIO.write((RenderedImage)img, iFmt, new File(fname));
        }
        catch (Exception ex) {
            Logger.getLogger("JamMt").severe(ex.toString());
        }
    }
}

