/*
 * Decompiled with CFR 0.152.
 */
package io;

import gui.MessageBox;
import io.FileExport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import utils.FileFilter;
import utils.GaussBeamFitter;
import utils.Settings;

public class IOFile {
    private String path = "";
    private String ext = "";
    private Settings sets;

    public IOFile(Settings sets) {
        this.sets = sets;
    }

    public String showDialog(JFrame owner, String title) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        int ret = 0;
        if (title.equals("Open file")) {
            this.path = this.sets.openPath;
            fc.setFileFilter(new FileFilter(".jam", "JamMt settings (*.jam)"));
        } else if (title.equals("Save file")) {
            this.path = this.sets.savePath;
            fc.setFileFilter(new FileFilter(".jam", "JamMt settings (*.jam)"));
        } else if (title.equals("Export ...")) {
            this.path = this.sets.exportPath;
            fc.setFileFilter(new FileFilter(".kat", "Finesse file (*.kat)"));
            fc.setFileFilter(new FileFilter(".oct", "Octave text data format (*.oct)"));
            fc.setFileFilter(new FileFilter(".mat", "Matlab binary format (*.mat)"));
            fc.setFileFilter(new FileFilter(".dat", "Tab separated data (*.dat)"));
            fc.setFileFilter(new FileFilter(".csv", "Comma separated data (*.csv)"));
            fc.setFileFilter(new FileFilter(".txt", "Ascii text (*.txt)"));
            fc.setFileFilter(new FileFilter(".png", "Portable Network Graphics (*.png)"));
            fc.setFileFilter(new FileFilter(".gif", "Graphics Interchange Format (*.gif)"));
            fc.setFileFilter(new FileFilter(".jpg", "Joint Photographic Experts Group Format (*.jpg)"));
            fc.setFileFilter(new FileFilter(".eps", "Encapsulated Postscript (*.eps)"));
        } else if (title.equals("Export database")) {
            this.path = this.sets.exportPath;
            fc.setFileFilter(new FileFilter(".jamDB", "JamMt database (*.jamDB)"));
        } else if (title.equals("Import database")) {
            this.path = this.sets.openPath;
            fc.setFileFilter(new FileFilter(".jamDB", "JamMt database (*.jamDB)"));
        } else if (title.equals("Import beam data")) {
            this.path = this.sets.dataPath;
        }
        fc.setCurrentDirectory(new File(this.path));
        if (title.equals("Open file") || title.equals("Import database") || title.equals("Import beam data")) {
            ret = fc.showOpenDialog(owner);
        } else if (title.equals("Save file") || title.equals("Export ...") || title.equals("Export database")) {
            ret = fc.showSaveDialog(owner);
        } else {
            return "";
        }
        if (ret == 0) {
            String fname = fc.getSelectedFile().getAbsolutePath();
            try {
                fc.getFileFilter().getClass().getMethod("getExtension", new Class[0]);
                this.ext = ((FileFilter)fc.getFileFilter()).getExtension();
                if (!fname.endsWith(this.ext)) {
                    fname = fname + this.ext;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (title.equals("Open file")) {
                this.sets.loadFromFile(fname);
                this.sets.openPath = fc.getCurrentDirectory().getAbsolutePath();
            } else if (title.equals("Save file")) {
                this.sets.writeToFile(fname);
                this.sets.savePath = fc.getCurrentDirectory().getAbsolutePath();
            } else if (title.equals("Export ...")) {
                new FileExport(fname, this.ext);
                this.sets.exportPath = fc.getCurrentDirectory().getAbsolutePath();
            } else {
                if (title.equals("Export database")) {
                    this.sets.exportPath = fc.getCurrentDirectory().getAbsolutePath();
                    return fname;
                }
                if (title.equals("Import database")) {
                    this.sets.openPath = fc.getCurrentDirectory().getAbsolutePath();
                    return fname;
                }
            }
            if (title.equals("Import beam data")) {
                try {
                    GaussBeamFitter bf = new GaussBeamFitter(fname, this.sets.beam.getWaveLength());
                    new MessageBox(owner, bf.messages());
                    this.sets.beam.setInitialBeam(bf.getW0("x"), bf.getZ0("x"), bf.getW0("y"), bf.getZ0("y"), this.sets.beam.getWaveLength());
                    this.sets.dataPath = fc.getCurrentDirectory().getAbsolutePath();
                }
                catch (Exception ex) {
                    Logger.getLogger("JamMt").severe(ex.toString());
                }
            }
        }
        return "";
    }

    public void viewTextFile(String fname, String title) {
        final JFrame wnd = new JFrame(title);
        StringBuffer text = new StringBuffer();
        Class<?> clazz = this.getClass();
        InputStream is = clazz.getResourceAsStream("/" + fname);
        try {
            int c;
            while ((c = is.read()) != -1) {
                text.append((char)c);
            }
        }
        catch (Exception e) {
            String mesg = "Problem in viewing file '" + fname + "':\n\n";
            mesg = mesg + e.toString();
            Logger.getLogger("JamMt").severe(mesg);
        }
        JTextArea txt = new JTextArea(text.toString(), 30, 80);
        txt.setFont(new Font("Monospaced", 0, 12));
        txt.setLineWrap(false);
        txt.setEditable(false);
        Container cp = wnd.getContentPane();
        cp.add((Component)new JScrollPane(txt), "North");
        JButton ok = new JButton("OK");
        ok.setMnemonic('o');
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wnd.setVisible(false);
                wnd.dispose();
            }
        });
        JPanel jp = new JPanel();
        jp.add(ok);
        cp.add((Component)jp, "South");
        wnd.setLocation(150, 100);
        wnd.pack();
        wnd.setVisible(true);
    }
}

