/*
 * Decompiled with CFR 0.152.
 */
package io;

import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import components.Lens;
import components.PartialBeam;
import components.Substrate;
import gui.MainWindow;
import io.Print2DtoStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import utils.Beam;
import utils.ComponentSet;
import utils.Formatter;
import utils.JamMtException;
import utils.TimeStamp;

public class FileExport {
    private String fname;
    private double[] pos;
    private double[] w;
    private double[] roc;
    private double[] phi;

    public FileExport(String fname, String ext) {
        this.fname = fname;
        if (ext.equals(".txt")) {
            this.AsciiExport();
        } else if (ext.equals(".kat")) {
            this.FinesseExport();
        } else if (ext.equals(".oct")) {
            this.OctaveExport();
        } else if (ext.equals(".mat")) {
            this.MatlabExport();
        } else if (ext.equals(".dat")) {
            this.DataExport("\t");
        } else if (ext.equals(".csv")) {
            this.DataExport(",");
        } else {
            new Print2DtoStream(fname);
        }
    }

    private String getHeader(String comment) {
        String header = comment + " This file was automatically generated by JamMt\n";
        TimeStamp time = new TimeStamp();
        header = header + comment + "Generated on " + time.getDate() + " at " + time.getTime() + "\n";
        return header;
    }

    private void getRawData() {
        int STEPS = MainWindow.getInstance().getSettings().getResolution();
        double xmin = MainWindow.getInstance().getDrawingArea().getPlot().getDomainAxis(0).getLowerBound();
        double xmax = MainWindow.getInstance().getDrawingArea().getPlot().getDomainAxis(0).getUpperBound();
        Beam beam = MainWindow.getInstance().getBeam();
        this.pos = new double[STEPS];
        this.w = new double[STEPS];
        this.phi = new double[STEPS];
        this.roc = new double[STEPS];
        for (int i = 0; i < STEPS; ++i) {
            this.pos[i] = xmin + (double)i * (xmax - xmin) / (double)STEPS;
            this.w[i] = beam.getWaistSizeAt(this.pos[i], "x");
            this.phi[i] = beam.getGouyPhaseAt(this.pos[i], "x");
            this.roc[i] = beam.getRadiusAt(this.pos[i], "x");
        }
    }

    private void DataExport(String sep) {
        this.getRawData();
        try {
            FileWriter fw = new FileWriter(this.fname);
            fw.write(this.getHeader("#"));
            fw.write("# Position, waist size, Gouy phase, raduis of curvature\n");
            for (int i = 0; i < this.w.length; ++i) {
                fw.write("" + this.pos[i]);
                fw.write(sep + this.w[i]);
                fw.write(sep + this.phi[i]);
                fw.write(sep + this.roc[i] + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    private void MatlabExport() {
        this.getRawData();
        ArrayList<MLArray> vars = new ArrayList<MLArray>();
        vars.add(new MLDouble("z", this.pos, 1));
        vars.add(new MLDouble("w", this.w, 1));
        vars.add(new MLDouble("phi", this.phi, 1));
        vars.add(new MLDouble("roc", this.roc, 1));
        try {
            new MatFileWriter(this.fname, vars);
        }
        catch (Exception e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    private void OctaveExport() {
        this.getRawData();
        int STEPS = this.w.length;
        try {
            int i;
            FileWriter fw = new FileWriter(this.fname);
            fw.write(this.getHeader("#"));
            fw.write("\n# name: z\n# type: matrix\n# rows: 1\n# columns: " + STEPS + "\n");
            for (i = 0; i < STEPS; ++i) {
                fw.write(this.pos[i] + " ");
            }
            fw.write("\n");
            fw.write("\n# name: w\n# type: matrix\n# rows: 1\n# columns: " + STEPS + "\n");
            for (i = 0; i < STEPS; ++i) {
                fw.write(this.w[i] + " ");
            }
            fw.write("\n");
            fw.write("\n# name: phi\n# type: matrix\n# rows: 1\n# columns: " + STEPS + "\n");
            for (i = 0; i < STEPS; ++i) {
                fw.write(this.phi[i] + " ");
            }
            fw.write("\n");
            fw.write("\n# name: roc\n# type: matrix\n# rows: 1\n# columns: " + STEPS + "\n");
            for (i = 0; i < STEPS; ++i) {
                fw.write(this.roc[i] + " ");
            }
            fw.write("\n");
            fw.close();
        }
        catch (IOException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    private void AsciiExport() {
        try {
            FileWriter fw = new FileWriter(this.fname);
            fw.write(this.getHeader("#"));
            PartialBeam ibeam = MainWindow.getInstance().getBeam().getInitialBeam();
            PartialBeam rbeam = MainWindow.getInstance().getBeam().getLast();
            fw.write("Initial beam parameters  : w0 = " + Formatter.autoFormat(ibeam.getWaistSize("x")) + ", z0 = " + Formatter.autoFormat(ibeam.getWaistPosition("x")) + "\n");
            fw.write("Resulting beam parameters: w0 = " + Formatter.autoFormat(rbeam.getWaistSize("x")) + ", z0 = " + Formatter.autoFormat(rbeam.getWaistPosition("x")) + "\n");
            fw.write("\nLenses/substrates:\n");
            try {
                for (Lens l : MainWindow.getInstance().getOpticalComponents().getLenses()) {
                    fw.write(l.getName() + " @ " + Formatter.autoFormat(l.getPosition()) + " with f = " + Formatter.autoFormat(l.getFocalLength("x")) + "\n");
                }
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            fw.close();
        }
        catch (IOException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    private void FinesseExport() {
        try {
            FileWriter fw = new FileWriter(this.fname);
            fw.write(this.getHeader("#"));
            PartialBeam b = MainWindow.getInstance().getBeam().getInitialBeam();
            String bs = "";
            bs = bs + "l initial_beam 1.0 0.0 n0\n\n";
            fw.write(bs);
            ComponentSet ls = MainWindow.getInstance().getOpticalComponents();
            String fs = "";
            String compName = "";
            int nodeNr = 0;
            int lensNr = 1;
            int substrateNr = 1;
            double R = 0.0;
            double T = 1.0;
            if (ls.getLenses().size() == 0) {
                return;
            }
            for (int i = 0; i < ls.getLenses().size(); ++i) {
                double L;
                Lens l = ls.getLenses().get(i);
                if (i == 0) {
                    L = 0.0;
                } else {
                    L = ls.getSpaceBetween(l, ls.getLenses().get(i - 1));
                    fs = fs + "s space" + i + " " + L + " n" + nodeNr + " n" + (nodeNr + 1) + "\n";
                    ++nodeNr;
                }
                if (l instanceof Substrate) {
                    Substrate sub = (Substrate)l;
                    compName = "sub_" + sub.getName() + "_" + substrateNr;
                    fs = fs + "m " + compName + "_iface1" + " " + R + " " + T + " 0.0 n" + nodeNr + " n" + (nodeNr + 1) + "\n";
                    fs = fs + "attr " + compName + "_iface1" + " Rc " + sub.getLeftRoc("x") + "\n";
                    if (i == 0) {
                        L = l.getPosition() < b.getWaistPosition("x") ? b.getWaistPosition("x") - (l.getPosition() + l.getThickness() / 2.0) : b.getWaistPosition("x") - (l.getPosition() - l.getThickness() / 2.0);
                        fs = fs + "gauss beam_parameter " + compName + "_iface1 n" + nodeNr + " " + b.getWaistSize("x") + " " + L + "\n";
                    }
                    fs = fs + "s " + compName + " " + sub.getThickness() + " " + sub.getIndexOfRefraction() + " n" + ++nodeNr + " n" + (nodeNr + 1) + "\n";
                    fs = fs + "m " + compName + "_iface2" + " " + R + " " + T + " 0.0 n" + ++nodeNr + " n" + (nodeNr + 1) + "\n";
                    fs = fs + "attr " + compName + "_iface2" + " Rc " + sub.getRightRoc("x") + "\n";
                    ++substrateNr;
                    ++nodeNr;
                } else {
                    try {
                        compName = "lens_" + l.getName() + "_" + lensNr;
                        fs = fs + "lens " + compName + " " + l.getFocalLength("x") + " n" + nodeNr + " n" + (nodeNr + 1) + "\n";
                    }
                    catch (JamMtException je) {
                        Logger.getLogger("JamMt").severe(je.toString());
                    }
                    if (i == 0) {
                        fs = fs + "gauss beam_parameter " + compName + " n" + nodeNr + " " + b.getWaistSize("x") + " " + (b.getWaistPosition("x") - l.getPosition()) + "\n";
                    }
                    ++nodeNr;
                    ++lensNr;
                }
                fs = fs + "\n";
            }
            fs = fs + "pd detector n" + nodeNr + "\n";
            fs = fs + "trace 10\n";
            fs = fs + "xaxis initial_beam P lin 0.0 0.1 100\n";
            fw.write(fs);
            fw.close();
        }
        catch (IOException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }
}

