/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Lens;
import gui.MainWindow;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_ThermalLensEstimator;
import utils.Beam;
import utils.ComponentSet;
import utils.JamMtException;

public class ThermalLensEstimator
extends Ui_ThermalLensEstimator
implements ActionListener {
    private double k_th = 38.0;
    private double beta = 4.0E-5;
    private double l = 0.013;
    private double alpha = 4.0;
    private double P = 1.0;
    private int Nlenses = 10;
    private ComponentSet lenses = new ComponentSet();
    private JFrame owner;

    public ThermalLensEstimator(JFrame owner) {
        super((Frame)owner, false);
        this.owner = owner;
        this.ok.addActionListener(this);
        this.th_cond.setText("" + this.k_th);
        this.th_coeff.setText("" + this.beta);
        this.length.setText("" + this.l);
        this.abs.setText("" + this.alpha);
        this.power.setText("" + this.P);
        this.nlenses.setText("" + this.Nlenses);
        this.th_cond.selectAll();
        this.th_coeff.selectAll();
        this.length.selectAll();
        this.abs.selectAll();
        this.power.selectAll();
        this.nlenses.selectAll();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.calculateLenses();
    }

    private void calculateLenses() {
        this.k_th = Double.parseDouble(this.th_cond.getText());
        this.beta = Double.parseDouble(this.th_coeff.getText());
        this.l = Double.parseDouble(this.length.getText());
        this.alpha = Double.parseDouble(this.abs.getText());
        this.P = Double.parseDouble(this.power.getText());
        this.Nlenses = Integer.parseInt(this.nlenses.getText());
        for (Lens l : this.lenses.getLenses()) {
            MainWindow.getInstance().getOpticalComponents().removeComponent(l);
        }
        this.lenses = new ComponentSet();
        Beam beam = MainWindow.getInstance().getBeam();
        double dz = this.l / (double)this.Nlenses;
        for (int i = 1; i <= this.Nlenses; ++i) {
            double z = (double)i * dz - dz / 2.0;
            double w = beam.getWaistSizeAt(z, "x");
            double f_th = Math.PI * this.k_th * w * w / (dz * this.alpha * this.P * this.beta);
            try {
                Lens l_th = new Lens(z, f_th, 0.025);
                MainWindow.getInstance().getOpticalComponents().addComponent(l_th);
                this.lenses.addComponent(l_th);
            }
            catch (JamMtException e) {
                new MessageBox(this.owner, e.getMessage());
            }
            beam.updateBeam();
        }
        MainWindow jam = MainWindow.getInstance();
        jam.mainUpdate();
    }
}

