/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Lens;
import components.Material;
import components.Substrate;
import gui.MainWindow;
import gui.SubstrateEditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import ui.Ui_ListEditor;
import utils.ComponentSet;
import utils.JamMtException;

public class SubstrateManager
extends Ui_ListEditor
implements ActionListener {
    private DefaultListModel listcontent = new DefaultListModel();
    private ComponentSet lenses;
    private JFrame owner;

    public SubstrateManager(JFrame owner, String title, ComponentSet lenses) {
        super((Frame)owner, false);
        this.setTitle(title);
        this.owner = owner;
        this.lenses = lenses;
        this.getAvailableLenses();
        this.list.setModel(this.listcontent);
        this.list.setSelectedIndex(0);
        this.edit.addActionListener(this);
        this.delete.addActionListener(this);
        this.add.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    private void getAvailableLenses() {
        boolean i = false;
        this.listcontent.clear();
        for (Lens l : this.lenses.getLenses()) {
            if (l instanceof Substrate) {
                this.listcontent.addElement(l.getName() + " @ z = " + l.getPosition() + ", f = " + ((Substrate)l).getFocalLength("x") * 1000.0 + " mm");
                continue;
            }
            try {
                this.listcontent.addElement(l.getName() + " @ z = " + l.getPosition() + ", f = " + l.getFocalLength("x") * 1000.0 + " mm");
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = this.list.getSelectedIndex();
        ArrayList<Material> materials = MainWindow.getInstance().getSettings().materials;
        if (e.getActionCommand().equals("Edit")) {
            if (i < 0) {
                return;
            }
            new SubstrateEditor(this.owner, (Substrate)this.lenses.getLenses().get(i), materials, this.lenses);
        }
        if (e.getActionCommand().equals("Delete")) {
            if (i < 0) {
                return;
            }
            this.lenses.removeComponent(this.lenses.getLenses().get(i));
        }
        if (e.getActionCommand().equals("Add")) {
            new SubstrateEditor(this.owner, null, materials, this.lenses);
        }
        this.getAvailableLenses();
    }
}

