/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Cavity;
import components.Lens;
import components.Material;
import components.Substrate;
import gui.MainWindow;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JFrame;
import ui.Ui_SubstrateEditor;
import utils.ComponentSet;
import utils.JamMtException;

public class SubstrateEditor
extends Ui_SubstrateEditor
implements ActionListener {
    private boolean adv = false;
    private boolean sym = true;
    private boolean has_material = false;
    private Lens newLens;
    private Lens lensToEdit;
    private ComponentSet set;
    private ArrayList<Material> materials = new ArrayList();
    private JFrame owner;

    public SubstrateEditor(JFrame owner, Lens lensToEdit, ArrayList<Material> materials, ComponentSet set) {
        super((Frame)owner, true);
        this.owner = owner;
        this.lensToEdit = lensToEdit;
        this.set = set;
        if (materials != null) {
            this.materials = materials;
        }
        if (lensToEdit == null) {
            this.setTitle("Add substrate");
            this.newLens = new Substrate();
        } else {
            this.setTitle("Change substrate");
            this.newLens = (Lens)lensToEdit.clone();
        }
        if (this.newLens instanceof Substrate) {
            this.fillFormWithSubstrate((Substrate)this.newLens, true);
        } else {
            this.fillFormWithLens(this.newLens, true);
        }
        this.populatePredefinedSubstrateList();
        this.advanced.addActionListener(this);
        this.ok.addActionListener(this);
        this.material.addActionListener(this);
        this.focalLength.addActionListener(this);
        this.symmetric.addActionListener(this);
        this.predefSub.addActionListener(this);
        this.name.selectAll();
        this.position.selectAll();
        this.aperture.selectAll();
        this.thickness.selectAll();
        this.idxOfRefraction.selectAll();
        this.leftRoc.selectAll();
        this.rightRoc.selectAll();
        this.leftRoc_y.selectAll();
        this.rightRoc_y.selectAll();
        this.angle.selectAll();
        this.advanced.doClick();
        this.advanced.doClick();
        this.setLocationRelativeTo(MainWindow.getInstance().getMainWnd());
        this.setVisible(true);
    }

    private void fillFormWithSubstrate(Substrate s, boolean updatePosition) {
        this.adv = true;
        if (s.getMaterial() != null) {
            this.has_material = true;
        }
        this.sym = s.isSymmetric();
        this.advanced.setSelected(this.adv);
        this.symmetric.setSelected(this.sym);
        this.name.setText("" + s.getName());
        if (updatePosition) {
            this.position.setText("" + s.getPosition());
        }
        this.aperture.setText("" + s.getAperture() * 1000.0);
        this.thickness.setText("" + s.getThickness() * 1000.0);
        this.idxOfRefraction.setText("" + s.getIndexOfRefraction());
        this.leftRoc.setText("" + s.getLeftRoc("x") * 1000.0);
        this.rightRoc.setText("" + s.getRightRoc("x") * 1000.0);
        this.leftRoc_y.setText("" + s.getLeftRoc("y") * 1000.0);
        this.rightRoc_y.setText("" + s.getRightRoc("y") * 1000.0);
        this.angle.setText("" + s.getAngleInDegrees());
        this.populateFocalLengthList(s);
        this.populateMaterialList(s.getMaterial());
        this.populatePredefinedSubstrateList(s.getName());
    }

    private void fillFormWithLens(Lens l, boolean updatePosition) {
        this.fillFormWithSubstrate(new Substrate(), updatePosition);
        this.adv = false;
        this.has_material = false;
        this.sym = l.isSymmetric();
        this.advanced.setSelected(this.adv);
        this.symmetric.setSelected(this.sym);
        this.name.setText("" + l.getName());
        if (updatePosition) {
            this.position.setText("" + l.getPosition());
        }
        this.aperture.setText("" + l.getAperture() * 1000.0);
        this.populateFocalLengthList(l);
    }

    private void populateFocalLengthList(Lens l) {
        this.focalLength.removeAllItems();
        try {
            this.focalLength.addItem("" + l.getFocalLength("x"));
            this.focalLength_y.addItem("" + l.getFocalLength("y"));
            for (Lens lens : MainWindow.getInstance().getSettings().defaultLenses.getLenses()) {
                if (lens instanceof Substrate) continue;
                this.focalLength.addItem("" + lens.getFocalLength("x"));
                this.focalLength_y.addItem("" + lens.getFocalLength("y"));
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
    }

    private void populateMaterialList(Material m) {
        this.material.removeAllItems();
        this.material.insertItemAt("", 0);
        for (Material mat : this.materials) {
            this.material.addItem(mat.getName());
        }
        if (m == null) {
            this.material.setSelectedIndex(0);
        } else {
            int i = 0;
            boolean found = false;
            for (Material mat : this.materials) {
                ++i;
                if (!m.getName().equals(mat.getName())) continue;
                found = true;
                break;
            }
            if (found) {
                this.material.setSelectedIndex(i);
            } else {
                this.material.setSelectedIndex(0);
                Logger.getLogger("JamMt").severe("Material " + m.getName() + " not found!!!");
            }
            try {
                this.idxOfRefraction.setText("" + m.getIndexOfRefraction(MainWindow.getInstance().getBeam().getWaveLength()));
                this.idxOfRefraction.setEnabled(false);
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
    }

    private void populatePredefinedSubstrateList() {
        this.populatePredefinedSubstrateList("");
    }

    private void populatePredefinedSubstrateList(String name) {
        this.predefSub.removeAllItems();
        this.predefSub.insertItemAt("", 0);
        this.predefSub.setSelectedIndex(0);
        for (Lens predef : MainWindow.getInstance().getSettings().defaultLenses.getLenses()) {
            if (!(predef instanceof Substrate)) continue;
            this.predefSub.addItem(predef.getName());
            if (!predef.getName().equals(name)) continue;
            this.predefSub.setSelectedItem(name);
        }
    }

    private void toggleVis() {
        this.adv = this.advanced.isSelected();
        this.sym = this.symmetric.isSelected();
        this.subPanel.setVisible(this.adv);
        this.focalLength.setVisible(!this.adv);
        this.lFocalLength.setVisible(!this.adv);
        this.focalLength_y.setVisible(!this.adv && !this.sym);
        this.lfocalLength_y.setVisible(!this.adv && !this.sym);
        this.leftRoc_y.setVisible(this.adv && !this.sym);
        this.rightRoc_y.setVisible(this.adv && !this.sym);
        this.lleftRoc_y.setVisible(this.adv && !this.sym);
        this.lrightRoc_y.setVisible(this.adv && !this.sym);
        this.idxOfRefraction.setEnabled(!this.has_material);
        if (this.adv) {
            this.advanced.setText("Thin lens");
        } else {
            this.advanced.setText("Thick lens");
        }
        this.pack();
    }

    private Substrate getSubstrateFromForm() throws JamMtException {
        Substrate s = new Substrate();
        s.setName(this.name.getText());
        s.setPosition(Double.parseDouble(this.position.getText()));
        s.setAperture(Double.parseDouble(this.aperture.getText()) * 0.001);
        s.setIndexOfRefraction(Double.parseDouble(this.idxOfRefraction.getText()));
        s.setThickness(Double.parseDouble(this.thickness.getText()) * 0.001);
        s.setLeftRoc(Double.parseDouble(this.leftRoc.getText()) * 0.001);
        s.setRightRoc(Double.parseDouble(this.rightRoc.getText()) * 0.001);
        s.setAngleInDegrees(Double.parseDouble(this.angle.getText()));
        if (!this.symmetric.isSelected()) {
            s.setRightRoc(Double.parseDouble(this.rightRoc_y.getText()) * 0.001, "y");
            s.setLeftRoc(Double.parseDouble(this.leftRoc_y.getText()) * 0.001, "y");
        }
        int mir = s.getMirror();
        Cavity cav = MainWindow.getInstance().getCSdisp().getCavity(this.lensToEdit);
        if (cav != null) {
            if (mir == 1 || mir == 3) {
                cav.setEndMirror("left", s);
            }
            if (mir == 2 || mir == 3) {
                cav.setEndMirror("right", s);
            }
        }
        Material mat = null;
        if (this.material.getSelectedIndex() != 0) {
            mat = this.materials.get(this.material.getSelectedIndex() - 1);
        }
        s.setMaterial(mat);
        return s;
    }

    private Lens getLensFromForm() throws JamMtException {
        Lens l = new Lens();
        l.setName(this.name.getText());
        l.setPosition(Double.parseDouble(this.position.getText()));
        l.setFocalLength(Double.parseDouble((String)this.focalLength.getSelectedItem()));
        l.setAperture(Double.parseDouble(this.aperture.getText()) * 0.001);
        if (!this.symmetric.isSelected()) {
            l.setFocalLength("y", Double.parseDouble((String)this.focalLength_y.getSelectedItem()));
        }
        return l;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("toggleVisibility")) {
            this.toggleVis();
        }
        if (e.getActionCommand().equals("Ok")) {
            try {
                this.newLens = this.adv ? this.getSubstrateFromForm() : this.getLensFromForm();
                if (this.set != null) {
                    if (this.lensToEdit != null) {
                        this.set.removeComponent(this.lensToEdit);
                    }
                    this.set.addComponent(this.newLens);
                    MainWindow.getInstance().getOpticalComponents().setCurrent(this.newLens);
                }
                this.dispose();
            }
            catch (JamMtException ex) {
                new MessageBox(this.owner, ex.getMessage());
            }
        }
        if (e.getActionCommand().equals("material")) {
            int i = this.material.getSelectedIndex();
            if (i <= 0) {
                this.idxOfRefraction.setEnabled(true);
                return;
            }
            Material m = this.materials.get(--i);
            try {
                this.idxOfRefraction.setText("" + m.getIndexOfRefraction(MainWindow.getInstance().getBeam().getWaveLength()));
                this.idxOfRefraction.setEnabled(false);
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
        if (e.getActionCommand().equals("predefSub")) {
            int i = this.predefSub.getSelectedIndex();
            if (i <= 0) {
                return;
            }
            --i;
            Lens current = null;
            int subcnt = 0;
            for (int k = 0; k < MainWindow.getInstance().getSettings().defaultLenses.getLenses().size(); ++k) {
                current = MainWindow.getInstance().getSettings().defaultLenses.getLenses().get(k);
                if (!(current instanceof Substrate)) continue;
                if (subcnt == i) break;
                ++subcnt;
                current = null;
            }
            if (current instanceof Substrate) {
                this.newLens = current;
                this.fillFormWithSubstrate((Substrate)this.newLens, false);
                this.toggleVis();
            }
        }
    }

    public Lens getChosenSubstrate() {
        return this.newLens;
    }
}

