/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Component;
import components.Lens;
import javax.swing.JLabel;
import utils.Beam;
import utils.BeamObserver;
import utils.Formatter;
import utils.Observer;
import utils.Settings;

public class StatusBar
extends JLabel
implements Observer,
BeamObserver {
    private Settings sets;

    public StatusBar(Settings sets) {
        this.sets = sets;
        sets.beam.attach(this);
        for (Lens l : sets.components.getLenses()) {
            l.attach(this);
        }
        sets.components.setStatusBar(this);
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        double w0_ini = this.sets.beam.getInitialBeam().getWaistSize("x");
        double z0_ini = this.sets.beam.getInitialBeam().getWaistPosition("x");
        double w0_res = this.sets.beam.getLast().getWaistSize("x");
        double z0_res = this.sets.beam.getLast().getWaistPosition("x");
        double w0y_ini = this.sets.beam.getInitialBeam().getWaistSize("y");
        double z0y_ini = this.sets.beam.getInitialBeam().getWaistPosition("y");
        double w0y_res = this.sets.beam.getLast().getWaistSize("y");
        double z0y_res = this.sets.beam.getLast().getWaistPosition("y");
        boolean showTangentialPlane = this.sets.showTan;
        boolean verbose = this.sets.info;
        String text = new String("<html>");
        if (showTangentialPlane) {
            text = text.concat("x: ");
        }
        if (verbose) {
            text = text.concat("Initial beam: w0 = " + Formatter.defaultFormat(w0_ini * 1000000.0) + " \u03bcm, z0 = " + Formatter.defaultFormat(z0_ini) + " m; ");
        }
        text = text.concat("Resulting beam: w0 = " + Formatter.defaultFormat(w0_res * 1000000.0) + " \u03bcm, z0 = " + Formatter.defaultFormat(z0_res) + " m");
        if (showTangentialPlane) {
            text = text.concat("<br>y: ");
            if (verbose) {
                text = text.concat("Initial beam: w0 = " + Formatter.defaultFormat(w0y_ini * 1000000.0) + " \u03bcm, z0 = " + Formatter.defaultFormat(z0y_ini) + " m; ");
            }
            text = text.concat("Resulting beam: w0 = " + Formatter.defaultFormat(w0y_res * 1000000.0) + " \u03bcm, z0 = " + Formatter.defaultFormat(z0y_res) + " m");
        }
        text = text.concat("</html>");
        this.setText(text);
    }

    @Override
    public void update(Component c) {
        this.updateStatusBar();
    }

    @Override
    public void beamUpdate(Beam b) {
        this.updateStatusBar();
    }
}

