/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainWindow;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_DisplaySettingsEditor;
import utils.JamMtException;
import utils.Settings;

public class PlotSettingsDialog
extends Ui_DisplaySettingsEditor
implements ActionListener {
    private Settings sets = MainWindow.getInstance().getSettings();
    private JFrame owner;

    public PlotSettingsDialog(JFrame owner) {
        super((Frame)owner, true);
        this.owner = owner;
        this.userInput.setEnabled(!this.sets.autoScale);
        this.yAxis.setSelectedItem(this.sets.yAxis);
        this.y2Axis.setSelectedItem(this.sets.y2Axis);
        this.xRes.setText("" + this.sets.getResolution());
        this.autoscale.setSelected(this.sets.autoScale);
        this.userscale.setSelected(!this.sets.autoScale);
        this.xMin.setText(this.sets.xMin);
        this.xMax.setText(this.sets.xMax);
        this.yMin.setText(this.sets.yMin);
        this.yMax.setText(this.sets.yMax);
        this.y2Min.setText(this.sets.y2Min);
        this.y2Max.setText(this.sets.y2Max);
        this.xRes.selectAll();
        this.xMin.selectAll();
        this.xMax.selectAll();
        this.yMin.selectAll();
        this.yMax.selectAll();
        this.y2Min.selectAll();
        this.y2Max.selectAll();
        this.apply.addActionListener(this);
        this.autoscale.addActionListener(this);
        this.userscale.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Apply")) {
            try {
                this.sets.yAxis = this.yAxis.getSelectedItem().toString();
                this.sets.y2Axis = this.y2Axis.getSelectedItem().toString();
                this.sets.autoScale = this.autoscale.isSelected();
                this.sets.xMin = this.xMin.getText();
                this.sets.xMax = this.xMax.getText();
                this.sets.yMin = this.yMin.getText();
                this.sets.yMax = this.yMax.getText();
                this.sets.y2Min = this.y2Min.getText();
                this.sets.y2Max = this.y2Max.getText();
                this.sets.setResolution(Integer.parseInt(this.xRes.getText()));
                MainWindow.getInstance().mainUpdate();
            }
            catch (JamMtException ex) {
                new MessageBox(this.owner, ex.getMessage());
            }
        }
        this.userInput.setEnabled(this.userscale.isSelected());
    }
}

