/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Lens;
import components.PartialBeam;
import gui.JamMtDialog;
import gui.MainWindow;
import gui.MessageBox;
import gui.SubstrateManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ui.Ui_ModeMatchDialog;
import utils.ComponentSet;
import utils.FitParameter;
import utils.GridSearch;
import utils.JamMtException;
import utils.ModematchingFinder;
import utils.ModematchingSolution;
import utils.Settings;

public class ModeMatchDialog
extends Ui_ModeMatchDialog
implements ActionListener,
PropertyChangeListener {
    private Vector<ModematchingSolution> all_solutions = new Vector();
    private Vector<ModematchingSolution> valid_solutions = new Vector();
    private ComponentSet persistentSet = new ComponentSet();
    private Settings sets;
    private boolean cancel = false;
    private ModematchingFinder fit;
    private JProgressBar pbar;
    private JamMtDialog dia;
    private double w0_ini;
    private double z0_ini;
    private double w0_res;
    private double z0_res_min;
    private double z0_res_max;
    private double vis;
    private double srstart;
    private double ende;
    private double w0_ini_y;
    private double z0_ini_y;
    private double w0_res_y;
    private double z0_res_min_y;
    private double z0_res_max_y;
    private int nl;
    private PartialBeam bres;
    private JFrame owner;

    public ModeMatchDialog(JFrame owner) {
        super((Frame)owner, false);
        this.setModal(false);
        this.owner = owner;
        ArrayList<Lens> LSdisp = MainWindow.getInstance().getOpticalComponents().getLenses();
        this.sets = MainWindow.getInstance().getSettings();
        for (Lens l : LSdisp) {
            this.persistentSet.addComponent(l);
        }
        PartialBeam bini = MainWindow.getInstance().getBeam().getInitialBeam();
        this.w0ini.setText("" + 1000000.0 * bini.getWaistSize("x"));
        this.z0ini.setText("" + bini.getWaistPosition("x"));
        this.w0ini_y.setText("" + 1000000.0 * bini.getWaistSize("y"));
        this.z0ini_y.setText("" + bini.getWaistPosition("y"));
        this.w0tgt.setText("" + this.sets.target_w0 * 1000000.0);
        this.z0tgtmin.setText("" + this.sets.target_z0_min);
        this.z0tgtmax.setText("" + this.sets.target_z0_max);
        this.w0tgt_y.setText("" + this.sets.target_w0_y * 1000000.0);
        this.z0tgtmin_y.setText("" + this.sets.target_z0_min_y);
        this.z0tgtmax_y.setText("" + this.sets.target_z0_max_y);
        this.zMin.setText("" + this.sets.shiftingRange_start);
        this.zMax.setText("" + this.sets.shiftingRange_end);
        this.overlap.setText("" + this.sets.fitVisibility * 100.0);
        this.dz.setText("" + (this.sets.shiftingRange_end - this.sets.shiftingRange_start) / (double)this.sets.getGridSize());
        this.nlenses.setValue(this.sets.Nlenses);
        this.w0ini_y.selectAll();
        this.z0ini_y.selectAll();
        this.w0ini.selectAll();
        this.z0ini.selectAll();
        this.w0tgt.selectAll();
        this.w0tgt_y.selectAll();
        this.dz.selectAll();
        this.z0tgtmin.selectAll();
        this.z0tgtmax.selectAll();
        this.z0tgtmin_y.selectAll();
        this.z0tgtmax_y.selectAll();
        this.zMin.selectAll();
        this.zMax.selectAll();
        this.overlap.selectAll();
        this.rule1.setActionCommand("filter action");
        this.rule2.setActionCommand("filter action");
        this.rule3.setActionCommand("filter action");
        this.rule4.setActionCommand("filter action");
        this.dz1.setActionCommand("filter action");
        this.rule1.addActionListener(this);
        this.rule2.addActionListener(this);
        this.rule3.addActionListener(this);
        this.rule4.addActionListener(this);
        this.dz1.addActionListener(this);
        this.dz1.setText("" + this.sets.dx_min);
        this.dz1.selectAll();
        this.rule1.setSelected(this.sets.right_focus);
        this.rule2.setSelected(this.sets.single_lens_use);
        this.rule3.setSelected(!this.sets.nearby_solution);
        this.rule3.doClick();
        this.rule4.setSelected(this.sets.lens_overlap);
        this.updateStatusBar();
        this.toggleVisibility();
        this.list.addListSelectionListener(new MyListEner());
        this.close.addActionListener(this);
        this.start.addActionListener(this);
        this.edit.addActionListener(this);
        this.filter.addActionListener(this);
        this.symmetric.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void toggleVisibility() {
        boolean vis = !this.symmetric.isSelected();
        this.w0tgt_y.setVisible(vis);
        this.z0tgtmin_y.setVisible(vis);
        this.z0tgtmax_y.setVisible(vis);
        this.w0ini_y.setVisible(vis);
        this.z0ini_y.setVisible(vis);
        this.l_inium.setVisible(vis);
        this.l_inim.setVisible(vis);
        this.l_tgtum.setVisible(vis);
        this.l_tgtm.setVisible(vis);
        this.l_tgtminus.setVisible(vis);
        this.l_iniw0_y.setVisible(vis);
        this.l_iniz0_y.setVisible(vis);
        this.l_tgtw0_y.setVisible(vis);
        this.l_tgtz0_y.setVisible(vis);
        this.pack();
    }

    private void updateStatusBar() {
        String text = "Solutions: ";
        text = text + this.all_solutions.size() + " (total), ";
        text = text + (this.all_solutions.size() - this.valid_solutions.size()) + " (filtered), ";
        text = text + this.valid_solutions.size() + " (shown)";
        this.status.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("symmetric")) {
            this.toggleVisibility();
        }
        if (e.getActionCommand().equals("Close")) {
            this.sets.target_w0 = Double.parseDouble(this.w0tgt.getText()) * 1.0E-6;
            this.sets.target_z0_min = Double.parseDouble(this.z0tgtmin.getText());
            this.sets.target_z0_max = Double.parseDouble(this.z0tgtmax.getText());
            this.sets.shiftingRange_start = Double.parseDouble(this.zMin.getText());
            this.sets.shiftingRange_end = Double.parseDouble(this.zMax.getText());
            this.sets.fitVisibility = Double.parseDouble(this.overlap.getText()) / 100.0;
            this.sets.Nlenses = (Integer)this.nlenses.getValue();
            try {
                this.sets.setGridSize((int)Math.floor((this.sets.shiftingRange_end - this.sets.shiftingRange_start) / Double.parseDouble(this.dz.getText())));
                this.dispose();
            }
            catch (JamMtException ex) {
                new MessageBox(this.owner, ex.getMessage());
            }
        }
        if (e.getActionCommand().equals("Edit lenses")) {
            new SubstrateManager(this.owner, "Fitting lenses", MainWindow.getInstance().getSettings().fittingLenses);
        }
        if (e.getActionCommand().equals("filter action")) {
            this.sets.right_focus = this.rule1.isSelected();
            this.sets.single_lens_use = this.rule2.isSelected();
            this.sets.nearby_solution = this.rule3.isSelected();
            this.sets.lens_overlap = this.rule4.isSelected();
            this.sets.dx_min = Double.parseDouble(this.dz1.getText());
            this.dz1.setEnabled(this.sets.nearby_solution);
            this.showSolutions();
        }
        if (e.getActionCommand().equals("Start search")) {
            this.w0_ini = 1.0E-6 * Double.parseDouble(this.w0ini.getText());
            this.z0_ini = Double.parseDouble(this.z0ini.getText());
            if (this.symmetric.isSelected()) {
                this.w0_ini_y = this.w0_ini;
                this.z0_ini_y = this.z0_ini;
            } else {
                this.w0_ini_y = 1.0E-6 * Double.parseDouble(this.w0ini_y.getText());
                this.z0_ini_y = Double.parseDouble(this.z0ini_y.getText());
            }
            this.w0_res = 1.0E-6 * Double.parseDouble(this.w0tgt.getText());
            this.z0_res_min = Double.parseDouble(this.z0tgtmin.getText());
            this.z0_res_max = Double.parseDouble(this.z0tgtmax.getText());
            if (this.symmetric.isSelected()) {
                this.w0_res_y = this.w0_res;
                this.z0_res_min_y = this.z0_res_min;
                this.z0_res_max_y = this.z0_res_max;
            } else {
                this.w0_res_y = 1.0E-6 * Double.parseDouble(this.w0tgt_y.getText());
                this.z0_res_min_y = Double.parseDouble(this.z0tgtmin_y.getText());
                this.z0_res_max_y = Double.parseDouble(this.z0tgtmax_y.getText());
            }
            this.srstart = Double.parseDouble(this.zMin.getText());
            this.ende = Double.parseDouble(this.zMax.getText());
            this.vis = 0.01 * Double.parseDouble(this.overlap.getText());
            this.nl = (Integer)this.nlenses.getValue();
            try {
                this.sets.setGridSize((int)Math.floor((this.sets.shiftingRange_end - this.sets.shiftingRange_start) / Double.parseDouble(this.dz.getText())));
                if (this.z0_res_min > this.z0_res_max) {
                    throw new JamMtException("Invalid range of the target waist position");
                }
                if (this.vis < 0.0 || this.vis > 1.0) {
                    throw new JamMtException("The visibility has to be in the range [0:1] (was " + this.vis + ").");
                }
                if (this.srstart > this.ende) {
                    throw new JamMtException("Invalid range of the lens shifting range");
                }
                this.bres = new PartialBeam(this.w0_res, this.z0_res_min, this.w0_res_y, this.z0_res_min_y, MainWindow.getInstance().getBeam().getWaveLength());
                this.list.setListData(new Vector());
                this.dia = new JamMtDialog(this, "Fitting ...", true);
                JButton jb_cancel = new JButton("Cancel");
                jb_cancel.setMnemonic('c');
                jb_cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModeMatchDialog.this.cancelFit();
                    }
                });
                this.pbar = new JProgressBar(0, 100);
                this.pbar.setValue(0);
                this.pbar.setStringPainted(true);
                FitParameter fp = new FitParameter();
                fp.visibility = this.vis;
                fp.nl = this.nl;
                fp.z_start = this.srstart;
                fp.z_end = this.ende;
                fp.grid_size = this.sets.getGridSize();
                fp.dz0x = this.z0_res_max - this.z0_res_min;
                fp.dz0y = this.z0_res_max_y - this.z0_res_min_y;
                this.fit = new GridSearch(new PartialBeam(this.w0_ini, this.z0_ini, this.w0_ini_y, this.z0_ini_y, this.bres.getWaveLength()), new PartialBeam(this.w0_res, this.z0_res_min, this.w0_res_y, this.z0_res_min_y, this.bres.getWaveLength()), MainWindow.getInstance().getSettings().fittingLenses, this.persistentSet, fp);
                this.fit.addPropertyChangeListener(this);
                this.fit.execute();
                this.dia.getContentPane().add((Component)this.pbar, "North");
                this.dia.getContentPane().add((Component)jb_cancel, "South");
                this.dia.pack();
                this.dia.setLocationRelativeTo(this);
                this.dia.setVisible(true);
            }
            catch (JamMtException ex) {
                new MessageBox(this.owner, ex.getMessage());
            }
        }
    }

    private void showSolutions() {
        Vector<String> lenslist = new Vector<String>();
        this.valid_solutions = new Vector();
        for (ModematchingSolution sol : this.all_solutions) {
            if (sol.components.vetoLensSet(sol.beam.getWaistPosition("x"), this.sets, this.valid_solutions)) continue;
            this.valid_solutions.add(sol);
        }
        for (ModematchingSolution curSet : this.valid_solutions) {
            lenslist.add("Nr. " + (this.valid_solutions.indexOf(curSet) + 1) + " : " + curSet.toString());
        }
        if (this.all_solutions.size() == 0) {
            lenslist.add("No solution was found!");
        } else if (this.valid_solutions.size() == 0) {
            lenslist.add("All solutions were filtered out!");
        }
        this.list.setListData(lenslist);
        this.updateStatusBar();
    }

    public void cancelFit() {
        this.cancel = true;
        this.fit.done();
        this.dia.setVisible(false);
        this.dia.dispose();
        this.all_solutions = this.fit.getSolutions();
        this.showSolutions();
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("progress".equals(e.getPropertyName())) {
            this.pbar.setValue(this.fit.getProgress());
        } else if ("DONE".equals(e.getNewValue().toString())) {
            this.cancelFit();
        }
    }

    class MyListEner
    implements ListSelectionListener {
        MyListEner() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int i = ((JList)e.getSource()).getSelectedIndex();
                if (i < 0 || i >= ModeMatchDialog.this.valid_solutions.size()) {
                    return;
                }
                try {
                    MainWindow.getInstance().getBeam().setInitialBeam(ModeMatchDialog.this.w0_ini, ModeMatchDialog.this.z0_ini, ModeMatchDialog.this.w0_ini, ModeMatchDialog.this.z0_ini, MainWindow.getInstance().getBeam().getWaveLength());
                }
                catch (JamMtException ex) {
                    new MessageBox(ModeMatchDialog.this.owner, ex.getMessage());
                }
                MainWindow.getInstance().getOpticalComponents().setLenses(((ModematchingSolution)((ModeMatchDialog)ModeMatchDialog.this).valid_solutions.get((int)i)).components.getLenses());
            }
        }
    }
}

