/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.BeamAnalyzer;
import components.Component;
import components.Lens;
import components.Substrate;
import components.TextLabel;
import gui.BeamAnalyzerEditor;
import gui.BeamAnalyzerManager;
import gui.BeamEditor;
import gui.Calculator;
import gui.CavityEditor;
import gui.CavityInformation;
import gui.ComponentOverview;
import gui.DatabaseManager;
import gui.HelpGui;
import gui.LogDialog;
import gui.MaterialEditor;
import gui.MessageBox;
import gui.ModeMatchDialog;
import gui.PlotSettingsDialog;
import gui.SaveStartUpFile;
import gui.StatusBar;
import gui.SubstrateEditor;
import gui.TextLabelEditor;
import gui.ThermalLensEstimator;
import io.IOFile;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import ui.Ui_MainWindow;
import utils.Beam;
import utils.CavitySet;
import utils.ComponentDrawer;
import utils.ComponentSet;
import utils.DrawingArea;
import utils.JamMtException;
import utils.KeyEventHandler;
import utils.Settings;

public class MainWindow
extends Ui_MainWindow
implements ComponentListener,
ActionListener {
    private static MainWindow jam = null;
    private static String fname = "";
    private static FileHandler fh;
    private static LogDialog dh;
    private static String JAM_VERSION;
    private DrawingArea da;
    private Settings sets = new Settings();
    private JComponent glass;
    private boolean FULL_VERSION = true;

    public Beam getBeam() {
        return this.sets.beam;
    }

    public DrawingArea getDrawingArea() {
        return this.da;
    }

    public CavitySet getCSdisp() {
        return this.sets.CSdisp;
    }

    public Settings getSettings() {
        return this.sets;
    }

    public JFrame getMainWnd() {
        return this;
    }

    @Override
    public JComponent getGlassPane() {
        return this.glass;
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.jlp;
    }

    public ComponentSet getOpticalComponents() {
        return this.sets.components;
    }

    public void setCSdisp(CavitySet set) {
        this.sets.CSdisp = set;
    }

    public void setSettings(Settings set) {
        this.sets = set;
    }

    public void setDrawingArea(DrawingArea da) {
        this.da = da;
    }

    public static MainWindow getInstance() {
        if (jam == null) {
            jam = new MainWindow();
        }
        return jam;
    }

    private MainWindow() {
        this.setTitle("JamMt - Just another mode matching tool");
        if (Settings.CONFIG_FILE.exists()) {
            this.sets.loadFromFile();
        }
        this.sets.loadDatabases();
        this.da = new DrawingArea(this.sets);
        this.glass = new ComponentDrawer(this.da, this.sets);
        this.jlp.add((java.awt.Component)this.da, new Integer(0));
        this.jlp.add((java.awt.Component)this.glass, new Integer(1));
        this.statusPanel.setLayout(new GridLayout(1, 1));
        this.statusPanel.add(new StatusBar(this.sets));
        this.open.addActionListener(this);
        this.save.addActionListener(this);
        this.saveAs.addActionListener(this);
        this.reset.addActionListener(this);
        this.clear_plot.addActionListener(this);
        this.export.addActionListener(this);
        this.import_db.addActionListener(this);
        this.import_data.addActionListener(this);
        this.settings.addActionListener(this);
        this.quit.addActionListener(this);
        this.initial_beam.addActionListener(this);
        this.add_substrate.addActionListener(this);
        this.add_material.addActionListener(this);
        this.add_beam_analyzer.addActionListener(this);
        this.add_text_label.addActionListener(this);
        this.move.addActionListener(this);
        this.rotate.addActionListener(this);
        this.verbose.addActionListener(this);
        this.autoscale.addActionListener(this);
        this.z_zoomIn.addActionListener(this);
        this.y_zoomIn.addActionListener(this);
        this.y2_zoomIn.addActionListener(this);
        this.z_zoomOut.addActionListener(this);
        this.y_zoomOut.addActionListener(this);
        this.y2_zoomOut.addActionListener(this);
        this.orth_plane.addActionListener(this);
        this.disp_settings.addActionListener(this);
        this.edit.addActionListener(this);
        this.delete.addActionListener(this);
        this.flip.addActionListener(this);
        this.next.addActionListener(this);
        this.previous.addActionListener(this);
        this.ungroup.addActionListener(this);
        this.ungroup_all.addActionListener(this);
        this.gid1.addActionListener(this);
        this.gid2.addActionListener(this);
        this.gid3.addActionListener(this);
        this.gid4.addActionListener(this);
        this.gid5.addActionListener(this);
        this.gid6.addActionListener(this);
        this.gid7.addActionListener(this);
        this.gid8.addActionListener(this);
        this.gid9.addActionListener(this);
        this.monolithic.addActionListener(this);
        this.left_em.addActionListener(this);
        this.right_em.addActionListener(this);
        this.verbose.setSelected(this.sets.info);
        this.orth_plane.setSelected(this.sets.showTan);
        this.autoscale.setSelected(this.sets.autoScale);
        this.modematching.addActionListener(this);
        this.calculator.addActionListener(this);
        this.thermal_lens.addActionListener(this);
        this.component_overview.addActionListener(this);
        this.beam_analyzer.addActionListener(this);
        this.cavities.addActionListener(this);
        this.documentation.addActionListener(this);
        this.setDefaultCloseOperation(3);
        this.setFocusTraversalKeysEnabled(false);
        this.addComponentListener(this);
        this.addKeyListener(new KeyEventHandler(this.sets));
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int w = this.jlp.getWidth();
        int h = this.jlp.getHeight();
        int gap = 5;
        this.da.setBounds(gap, gap, w - 2 * gap, h - 2 * gap);
        this.glass.setBounds(gap, gap, w - 2 * gap, h - 2 * gap);
    }

    public void mainUpdate() {
        this.verbose.setSelected(this.sets.info);
        this.autoscale.setSelected(this.sets.autoScale);
        this.orth_plane.setSelected(this.sets.showTan);
        this.getBeam().fireUpdate();
        this.getLayeredPane().remove(MainWindow.getInstance().getLayeredPane().getIndexOf(MainWindow.getInstance().getDrawingArea()));
        MainWindow.getInstance().getDrawingArea().createChart();
        this.setDrawingArea(MainWindow.getInstance().getDrawingArea());
        this.getLayeredPane().add((java.awt.Component)MainWindow.getInstance().getDrawingArea(), new Integer(0));
        MainWindow.getInstance().getDrawingArea().updatePlotRange();
        MainWindow.getInstance().getDrawingArea().getPlotData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component current;
        String event = e.getActionCommand();
        if (event.equals("Open")) {
            new IOFile(this.sets).showDialog(this, "Open file");
            this.requestFocus();
            this.setTitle("JamMt (" + this.sets.getCurrentFileBasename() + ")");
            this.mainUpdate();
        }
        if (event.equals("Save as ...")) {
            new IOFile(this.sets).showDialog(this, "Save file");
            this.setTitle("JamMt (" + this.sets.getCurrentFileBasename() + ")");
        }
        if (event.equals("Save")) {
            String fname = this.sets.getCurrentFile();
            if (fname.equals("")) {
                new IOFile(this.sets).showDialog(this, "Save file");
                this.setTitle("JamMt (" + this.sets.getCurrentFileBasename() + ")");
            } else {
                this.sets.writeToFile(this.sets.getCurrentFile());
            }
        }
        if (event.equals("Reset")) {
            this.sets.loadFromFile(this.sets.getCurrentFile());
            this.mainUpdate();
        }
        if (event.equals("Clear plot")) {
            this.sets.components.removeAll();
            this.mainUpdate();
        }
        if (event.equals("Settings")) {
            new SaveStartUpFile(this, this.sets);
        }
        if (event.equals("Export ...")) {
            new IOFile(this.sets).showDialog(this, "Export ...");
        }
        if (event.equals("Database manager")) {
            new DatabaseManager(this, this.sets);
        }
        if (event.equals("Import beam data")) {
            new IOFile(this.sets).showDialog(this, "Import beam data");
        }
        if (event.equals("Quit")) {
            this.dispose();
            System.exit(0);
        }
        if (event.equals("Initial beam")) {
            new BeamEditor(this);
        }
        if (event.equals("Add substrate")) {
            new SubstrateEditor(this, null, this.sets.materials, this.getOpticalComponents());
        }
        if (event.equals("Add beam analyzer")) {
            new BeamAnalyzerEditor(this, null);
        }
        if (event.equals("Add text label")) {
            new TextLabelEditor(this, null);
        }
        if (event.equals("New material")) {
            new MaterialEditor(this, null);
        }
        if (event.equals("Display settings")) {
            new PlotSettingsDialog(this);
        }
        if (event.equals("Verbose")) {
            this.sets.info = !this.sets.info;
            this.sets.beam.fireUpdate();
        }
        if (event.equals("Orthogonal plane")) {
            this.sets.showTan = !this.sets.showTan;
            this.sets.beam.fireUpdate();
        }
        if (event.equals("Autoscale")) {
            this.sets.autoScale = !this.sets.autoScale;
            this.mainUpdate();
        }
        if (event.equals("Move")) {
            this.sets.rotate = false;
            this.sets.beam.fireUpdate();
        }
        if (event.equals("Rotate")) {
            this.sets.rotate = true;
            this.sets.beam.fireUpdate();
        }
        if (event.equals("z_zoomOut")) {
            this.da.zoom("z", 0.1);
        }
        if (event.equals("y_zoomOut")) {
            this.da.zoom("y", 0.1);
        }
        if (event.equals("y2_zoomOut")) {
            this.da.zoom("y2", 0.1);
        }
        if (event.equals("z_zoomIn")) {
            this.da.zoom("z", -0.1);
        }
        if (event.equals("y_zoomIn")) {
            this.da.zoom("y", -0.1);
        }
        if (event.equals("y2_zoomIn")) {
            this.da.zoom("y2", -0.1);
        }
        if (event.equals("Next")) {
            this.sets.components.getNext();
        }
        if (event.equals("Previous")) {
            this.sets.components.getPrevious();
        }
        if (event.equals("Modematching assistant")) {
            new ModeMatchDialog(this);
        }
        if (event.equals("Calculator")) {
            new Calculator(this);
        }
        if (event.equals("Thermal lens estimation")) {
            new ThermalLensEstimator(this);
        }
        if (event.equals("Component overview")) {
            new ComponentOverview(this, this.sets.components);
        }
        if (event.equals("Beam analyzer")) {
            new BeamAnalyzerManager(this);
        }
        if (event.equals("Cavities")) {
            new CavityInformation(this);
        }
        if (event.equals("Documentation")) {
            new HelpGui(this);
        }
        if ((current = this.sets.components.getCurrent()) == null) {
            return;
        }
        if (current instanceof Lens && event.equals("Edit")) {
            new SubstrateEditor(this, (Lens)current, this.sets.materials, this.sets.components);
        }
        if (current instanceof BeamAnalyzer && event.equals("Edit")) {
            new BeamAnalyzerEditor(this, (BeamAnalyzer)current);
        }
        if (current instanceof TextLabel && event.equals("Edit")) {
            new TextLabelEditor(this, (TextLabel)current);
        }
        if (event.equals("Delete")) {
            if (current instanceof Lens && this.sets.CSdisp.getCavity((Lens)current) != null) {
                this.sets.CSdisp.removeCavity(this.sets.CSdisp.getCavity((Lens)current));
            }
            this.sets.components.removeComponent(current);
            this.sets.beam.updateBeam();
        }
        if (current instanceof Substrate) {
            int i;
            Substrate s;
            if (event.equals("Flip")) {
                ((Substrate)current).flip();
            }
            if (event.equals("Left endmirror")) {
                int start;
                s = (Substrate)current;
                this.sets.CSdisp.removeCavity(this.sets.CSdisp.getCavity(s));
                try {
                    s.setMirror(1);
                }
                catch (JamMtException ex) {
                    new MessageBox(this.getMainWnd(), ex.getMessage());
                }
                for (i = start = this.sets.components.getLenses().indexOf(s); i < this.sets.components.getLenses().size(); ++i) {
                    Lens counterPart = this.sets.components.getLenses().get(i);
                    if (!(counterPart instanceof Substrate) || ((Substrate)counterPart).getMirror() != 2) continue;
                    new CavityEditor(this.getMainWnd(), s, (Substrate)counterPart, this.sets.CSdisp);
                    break;
                }
                this.mainUpdate();
            }
            if (event.equals("Right endmirror")) {
                int end;
                s = (Substrate)current;
                this.sets.CSdisp.removeCavity(this.sets.CSdisp.getCavity(s));
                try {
                    s.setMirror(2);
                }
                catch (JamMtException ex) {
                    new MessageBox(this.getMainWnd(), ex.getMessage());
                }
                for (i = end = this.sets.components.getLenses().indexOf(s); i >= 0; --i) {
                    if (!(this.sets.components.getLenses().get(i) instanceof Substrate) || ((Substrate)this.sets.components.getLenses().get(i)).getMirror() != 1) continue;
                    new CavityEditor(this.getMainWnd(), (Substrate)this.sets.components.getLenses().get(i), s, this.sets.CSdisp);
                    break;
                }
                this.mainUpdate();
            }
            if (event.equals("Monolithic cavity")) {
                s = (Substrate)current;
                this.sets.CSdisp.removeCavity(this.sets.CSdisp.getCavity(s));
                try {
                    s.setMirror(3);
                }
                catch (JamMtException ex) {
                    new MessageBox(this.getMainWnd(), ex.getMessage());
                }
                new CavityEditor(this.getMainWnd(), s, s, this.sets.CSdisp);
                if (this.sets.CSdisp.getCavity(s) == null) {
                    try {
                        s.setMirror(0);
                    }
                    catch (JamMtException ex) {
                        new MessageBox(this.getMainWnd(), ex.getMessage());
                    }
                }
                this.mainUpdate();
            }
        }
        if (event.equals("Ungroup all")) {
            this.sets.components.ungroup(current.getGroupID(), false);
        }
        try {
            if (event.equals("Ungroup")) {
                current.setGroupID(0);
            }
            if (event.equals("1")) {
                current.setGroupID(1);
            }
            if (event.equals("2")) {
                current.setGroupID(2);
            }
            if (event.equals("3")) {
                current.setGroupID(3);
            }
            if (event.equals("4")) {
                current.setGroupID(4);
            }
            if (event.equals("5")) {
                current.setGroupID(5);
            }
            if (event.equals("6")) {
                current.setGroupID(6);
            }
            if (event.equals("7")) {
                current.setGroupID(7);
            }
            if (event.equals("8")) {
                current.setGroupID(8);
            }
            if (event.equals("9")) {
                current.setGroupID(9);
            }
        }
        catch (JamMtException ex) {
            Logger.getLogger("JamMt").severe(ex.toString());
        }
    }

    public void parseCommandLine() {
        if (new File(fname).exists()) {
            this.sets.loadFromFile(fname);
            this.setTitle("JamMt (" + this.sets.getCurrentFileBasename() + ")");
        }
        this.mainUpdate();
    }

    private static void initializeStartupFolder(Settings sets) {
        boolean oldini = false;
        if (Settings.STARTUP_FOLDER.exists() && Settings.STARTUP_FOLDER.isFile()) {
            oldini = true;
            sets.loadFromFile(Settings.STARTUP_FOLDER.getPath());
            Settings.STARTUP_FOLDER.delete();
            Settings.STARTUP_FOLDER.mkdir();
            sets.writeToFile();
        } else {
            Settings.STARTUP_FOLDER.mkdir();
            Settings.DB_FOLDER.mkdir();
            Settings.THEME_FOLDER.mkdir();
        }
        if (oldini) {
            Logger.getLogger("JamMt").info("I moved your settings file to '" + Settings.CONFIG_FILE + "'\n");
        }
    }

    public static void main(String[] args) {
        try {
            Locale.setDefault(Locale.ENGLISH);
        }
        catch (Exception e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        if (args.length > 1) {
            System.err.println("Usage: JamMt.jar [filename]");
            System.exit(1);
        }
        if (args.length == 1) {
            fname = args[0];
        }
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        Settings sets = new Settings();
        MainWindow.initializeStartupFolder(sets);
        try {
            fh = new FileHandler(Settings.LOG_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Could not create log file '" + Settings.LOG_FILE + "'");
        }
        fh.setFormatter(new SimpleFormatter());
        fh.setLevel(Level.ALL);
        dh = new LogDialog();
        dh.setLevel(Level.SEVERE);
        Logger jamlog = Logger.getLogger("JamMt");
        jamlog.addHandler(fh);
        jamlog.addHandler(dh);
        LogManager.getLogManager().addLogger(jamlog);
        Logger.getLogger("JamMt").info("JamMt version: " + JAM_VERSION);
        MainWindow mainWnd = MainWindow.getInstance();
        mainWnd.parseCommandLine();
        mainWnd.requestFocus();
    }

    static {
        JAM_VERSION = "0.24";
    }

    static class DefaultExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        DefaultExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            String mesg = e.toString() + "\n\n";
            for (StackTraceElement el : e.getStackTrace()) {
                mesg = mesg + el.toString() + "\n";
            }
            Logger.getLogger("JamMt").severe(mesg);
        }
    }
}

