/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Database;
import gui.DatabaseCreator;
import gui.DatabaseEditor;
import io.IOFile;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ui.Ui_DatabaseManager;
import utils.FileFilter;
import utils.ListManager;
import utils.Settings;

public class DatabaseManager
extends Ui_DatabaseManager
implements ActionListener,
ListSelectionListener {
    private JFrame owner;
    private ListManager<Database> lm;
    private Settings sets;

    public DatabaseManager(JFrame owner, Settings sets) {
        super((Frame)owner, true);
        this.owner = owner;
        this.sets = sets;
        this.new_db.addActionListener(this);
        this.import_db.addActionListener(this);
        this.edit_db.addActionListener(this);
        this.export_db.addActionListener(this);
        this.delete_db.addActionListener(this);
        this.ok.addActionListener(this);
        this.lm = new ListManager(this.db_list);
        this.db_list.addListSelectionListener(this);
        File folder = Settings.DB_FOLDER;
        for (File f : folder.listFiles(new FileFilter(".jamDB"))) {
            this.lm.addItem(new Database(f));
        }
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setVisible(true);
    }

    public void exportDatabase(String file) {
        Database db = this.lm.getSelectedItem();
        if (db != null) {
            db.writeToFile(file);
        }
    }

    public void clearDatabaseFolder() {
        for (File dbfile : Settings.DB_FOLDER.listFiles(new FileFilter(".jamDB"))) {
            dbfile.delete();
        }
    }

    public void removeDatabase() {
        Database db = this.lm.getSelectedItem();
        if (db != null) {
            String fname = db.getName();
            File f = new File(Settings.DB_FOLDER + Settings.FS + fname + ".jamDB");
            f.delete();
        }
    }

    public void addDatabase(Database db) {
        this.lm.addItem(db);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.db_content.setText("");
        Database db = this.lm.getSelectedItem();
        if (db != null) {
            this.db_content.setText(db.contentsToString());
        }
        this.db_content.setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DatabaseEditor dbe;
        Database db;
        String fname;
        String event = e.getActionCommand().toString();
        if (event.equals("New")) {
            new DatabaseCreator(this.owner, this);
        }
        if (event.equals("Import") && !(fname = new IOFile(this.sets).showDialog(this.owner, "Import database")).equals("")) {
            this.lm.addItem(new Database(new File(fname)));
        }
        if (event.equals("Export") && (fname = new IOFile(this.sets).showDialog(this.owner, "Export database")) != "") {
            this.exportDatabase(fname);
        }
        if (event.equals("Delete")) {
            this.removeDatabase();
            this.lm.deleteCurrentItem();
        }
        if (event.equals("Edit") && (db = this.lm.getSelectedItem()) != null && (db = (dbe = new DatabaseEditor(this.owner, db)).getDatabase()) != null) {
            this.lm.updateCurrentItem(db);
        }
        if (event.equals("Ok")) {
            this.clearDatabaseFolder();
            for (Database db2 : this.lm.getContent()) {
                db2.writeToFile();
            }
            this.dispose();
            this.sets.loadDatabases();
        }
    }
}

