/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Database;
import components.Lens;
import components.Material;
import gui.MaterialEditor;
import gui.SubstrateEditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_DatabaseEditor;
import utils.ListManager;

public class DatabaseEditor
extends Ui_DatabaseEditor
implements ActionListener {
    private JFrame owner;
    private Database database;
    private ListManager<Lens> slm;
    private ListManager<Material> mlm;

    public DatabaseEditor(JFrame owner, Database db) {
        super((Frame)owner, true);
        this.owner = owner;
        this.database = db;
        this.slm = new ListManager<Lens>(this.substrate_list, db.getSubstrates());
        this.mlm = new ListManager<Material>(this.material_list, db.getMaterials());
        this.db_name.setText(db.getName());
        this.disable_db.setSelected(!db.isEnabled());
        this.add.addActionListener(this);
        this.change.addActionListener(this);
        this.remove.addActionListener(this);
        this.ok.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String event = e.getActionCommand();
        int idx = this.tabbedPane.getSelectedIndex();
        Lens s = null;
        if (event.equals("Add")) {
            if (idx == 1) {
                SubstrateEditor se = new SubstrateEditor(this.owner, s, this.mlm.getContent(), null);
                this.slm.addItem(se.getChosenSubstrate());
            } else if (idx == 0) {
                MaterialEditor me = new MaterialEditor(this.owner, null);
                this.mlm.addItem(me.getChosenMaterial());
            }
        } else if (event.equals("Change")) {
            Material m;
            Lens sub;
            if (idx == 1 && (sub = this.slm.getSelectedItem()) != null) {
                SubstrateEditor se = new SubstrateEditor(this.owner, sub, this.mlm.getContent(), null);
                this.slm.updateCurrentItem(se.getChosenSubstrate());
            }
            if (idx == 0 && (m = this.mlm.getSelectedItem()) != null) {
                MaterialEditor me = new MaterialEditor(this.owner, m);
                this.mlm.updateCurrentItem(me.getChosenMaterial());
            }
        } else if (event.equals("Delete")) {
            if (idx == 1) {
                this.slm.deleteCurrentItem();
            } else if (idx == 0) {
                this.mlm.deleteCurrentItem();
            }
        } else if (event.equals("Ok")) {
            this.database.setName(this.db_name.getText());
            this.database.setEnabled(!this.disable_db.isSelected());
            this.dispose();
        }
    }

    public Database getDatabase() {
        return this.database;
    }
}

