/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Component;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import ui.Ui_ComponentOverview;
import utils.ComponentSet;
import utils.Formatter;
import utils.JamMtException;

public class ComponentOverview
extends Ui_ComponentOverview
implements ActionListener {
    private ArrayList<Component> clist;
    private String[] header;
    private Object[][] data;
    private JTable table;
    private JFrame owner;

    public ComponentOverview(JFrame owner, ComponentSet components) {
        super((Frame)owner, true);
        this.owner = owner;
        this.clist = components.getComponents();
        this.grid.setText("25");
        try {
            this.updateTableData();
        }
        catch (JamMtException e) {
            new MessageBox(owner, e.getMessage());
        }
        this.table = new JTable(this.data, this.header);
        TableColumn column = null;
        for (int i = 1; i < this.clist.size() + 1; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setMinWidth(150);
        }
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.panel.add((java.awt.Component)new JScrollPane(this.table), "Center");
        this.panel.add((java.awt.Component)this.genHelpText(), "South");
        this.grid.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setVisible(true);
    }

    private void updateTable() {
        try {
            this.updateTableData();
            int N = this.clist.size() + 1;
            for (int i = 0; i < N - 1; ++i) {
                for (int j = 0; j < N; ++j) {
                    this.table.setValueAt(this.data[i][j], i, j);
                }
            }
        }
        catch (JamMtException e) {
            new MessageBox(this.owner, e.getMessage());
        }
    }

    private void updateTableData() throws JamMtException {
        double gsize = Double.parseDouble(this.grid.getText()) * 0.001;
        if (gsize <= 0.0) {
            throw new JamMtException("The table grid size has to be greater than zero (was " + gsize + ").");
        }
        int N = this.clist.size() + 1;
        this.header = new String[N];
        this.header[0] = "";
        int cnt = 1;
        for (Component c : this.clist) {
            this.header[cnt++] = c.getName();
        }
        this.data = new Object[N - 1][N];
        int cnt1 = 0;
        int cnt2 = 1;
        for (Component c1 : this.clist) {
            cnt2 = 1;
            this.data[cnt1][0] = c1.getName();
            for (Component c2 : this.clist) {
                double dist = c1.distanceTo(c2);
                this.data[cnt1][cnt2++] = Formatter.residualFormat(dist, gsize);
            }
            ++cnt1;
        }
    }

    private JPanel genHelpText() {
        JPanel p = new JPanel(new GridLayout(8, 1));
        String h = "This table gives an overview over all component distances.";
        p.add(new JLabel(h));
        h = "Please make sure to use meaningful component names.";
        p.add(new JLabel(h));
        h = "";
        p.add(new JLabel(h));
        h = "The integer value 'N' in the table is given in units of the grid spacing 'u'.";
        p.add(new JLabel(h));
        h = "The number in brackets is the residual distance 'r'.";
        p.add(new JLabel(h));
        h = "The total distance of two components is therefore given by 'N*u + r'.";
        p.add(new JLabel(h));
        h = "";
        p.add(new JLabel(h));
        h = "You can enter a new grid spacing and hit enter.";
        p.add(new JLabel(h));
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateTable();
    }
}

