/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Cavity;
import components.Component;
import components.Lens;
import gui.MainWindow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import ui.Ui_CavityInformation;
import utils.Beam;
import utils.BeamObserver;
import utils.Observer;

public class CavityInformation
extends Ui_CavityInformation
implements ActionListener,
Observer,
BeamObserver {
    DefaultListModel listcontent = new DefaultListModel();

    public CavityInformation(JFrame owner) {
        super((Frame)owner, true);
        this.setModal(false);
        MainWindow.getInstance().getBeam().attach(this);
        for (Lens l : MainWindow.getInstance().getOpticalComponents().getLenses()) {
            l.attach(this);
        }
        this.getAvailableCavities(this.listcontent);
        this.list.setModel(this.listcontent);
        this.list.setSelectedIndex(0);
        this.add.addActionListener(this);
        this.toggle.addActionListener(this);
        this.delete.addActionListener(this);
        this.updateDisplay();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int idx;
        if (e.getActionCommand().equals("Delete")) {
            idx = this.list.getSelectedIndex();
            if (idx >= 0) {
                MainWindow.getInstance().getCSdisp().removeCavity(MainWindow.getInstance().getCSdisp().getCavities().get(idx));
            }
            this.getAvailableCavities(this.listcontent);
            this.detail.setText("");
        }
        if (e.getActionCommand().equals("Toggle group") && (idx = this.list.getSelectedIndex()) >= 0) {
            MainWindow.getInstance().getCSdisp().toggleGroup(MainWindow.getInstance().getCSdisp().getCavities().get(idx));
        }
        if (e.getActionCommand().equals("Add cavity") && (idx = this.list.getSelectedIndex()) >= 0) {
            MainWindow.getInstance().getSettings().defaultCavities.getCavities().add(MainWindow.getInstance().getCSdisp().getCavities().get(idx));
        }
    }

    private void getAvailableCavities(DefaultListModel dlm) {
        dlm.clear();
        for (Cavity cav : MainWindow.getInstance().getCSdisp().getCavities()) {
            dlm.addElement(cav.getName());
        }
    }

    private void updateDisplay() {
        int idx = this.list.getSelectedIndex();
        if (idx >= 0 && MainWindow.getInstance().getCSdisp().getCavities().size() != 0) {
            this.detail.setText(MainWindow.getInstance().getCSdisp().getInfo(MainWindow.getInstance().getCSdisp().getCavities().get(idx)));
        }
    }

    @Override
    public void beamUpdate(Beam b) {
        this.updateDisplay();
    }

    @Override
    public void update(Component comp) {
        if (comp instanceof Lens) {
            this.updateDisplay();
        }
    }
}

