/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.Cavity;
import components.Substrate;
import gui.CavityInformation;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_CavityEditor;
import utils.CavitySet;

public class CavityEditor
extends Ui_CavityEditor
implements ActionListener {
    private Substrate m1;
    private Substrate m2;
    private CavitySet cavities;
    private JFrame owner;

    public CavityEditor(JFrame owner, Substrate m1, Substrate m2, CavitySet cavities) {
        super((Frame)owner, true);
        this.owner = owner;
        this.m1 = m1;
        this.m2 = m2;
        this.cavities = cavities;
        if (m1 == m2) {
            this.m1_coating.setSelectedItem("Left");
            this.m2_coating.setSelectedItem("Right");
            this.m1_coating.setEnabled(false);
            this.m2_coating.setEnabled(false);
        } else {
            this.m1_coating.setSelectedItem("Right");
            this.m2_coating.setSelectedItem("Left");
        }
        this.ok.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cavities.getCavities().add(new Cavity(this.name.getText(), this.m1, this.m2, this.group.isSelected(), ((String)this.m1_coating.getSelectedItem()).toLowerCase(), ((String)this.m2_coating.getSelectedItem()).toLowerCase()));
        this.m1.setCavityComponent(true);
        this.m2.setCavityComponent(true);
        this.cavities.getBeam().updateBeam();
        this.dispose();
        new CavityInformation(this.owner);
    }
}

