/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EquationEditor;
import gui.MainWindow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import ui.Ui_Calculator;
import utils.Formatter;
import utils.JamMtException;
import utils.MathParser;

public class Calculator
extends Ui_Calculator
implements ActionListener {
    private DefaultListModel listcontent = new DefaultListModel();
    private ArrayList<String> eqns = new ArrayList();
    private JFrame owner;

    public Calculator(JFrame owner) {
        super((Frame)owner, false);
        this.eqns = MainWindow.getInstance().getSettings().eqns;
        this.getListContent(this.listcontent);
        this.list.setModel(this.listcontent);
        this.add.addActionListener(this);
        this.delete.addActionListener(this);
        this.edit.addActionListener(this);
        this.calculate.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void getListContent(DefaultListModel dlm) {
        dlm.clear();
        for (String eqn : this.eqns) {
            dlm.addElement(eqn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Calculate")) {
            String expr = this.exp.getText();
            MathParser mp = new MathParser(expr);
            mp.setFunctions(this.eqns);
            try {
                this.result.setText("Result: " + Formatter.defaultFormat(mp.getValue()));
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").info(je.getMessage());
                this.result.setText("Unable to parse expression");
            }
        }
        if (e.getActionCommand().equals("Add")) {
            new EquationEditor(this.owner, "");
        }
        if (e.getActionCommand().equals("Edit")) {
            int i = this.list.getSelectedIndex();
            new EquationEditor(this.owner, this.eqns.get(i));
        }
        if (e.getActionCommand().equals("Delete")) {
            int i = this.list.getSelectedIndex();
            this.eqns.remove(i);
        }
        this.getListContent(this.listcontent);
    }
}

